/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.longrest;

import org.jbpm.process.longrest.ActiveTasks;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServiceProcessEventListener
extends DefaultProcessEventListener {
    private ActiveTasks activeProcesses;
    private final Logger logger = LoggerFactory.getLogger(RestServiceProcessEventListener.class);

    public RestServiceProcessEventListener(ActiveTasks activeProcesses) {
        this.activeProcesses = activeProcesses;
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        ProcessInstance processInstance = event.getProcessInstance();
        long processInstanceId = processInstance.getId();
        this.logger.debug("Started process: {}({})", (Object)processInstance.getProcessName(), (Object)processInstanceId);
        this.activeProcesses.started();
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)event.getProcessInstance();
        NodeInstance nodeInstance = event.getNodeInstance();
        this.logger.debug("Leaving node {} ({}) with id: {} in the process: {} with id: {}.", new Object[]{nodeInstance.getNodeName(), nodeInstance.getClass(), nodeInstance.getId(), processInstance.getProcess().getName(), processInstance.getId()});
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        ProcessInstance processInstance = event.getProcessInstance();
        this.logger.info("Process completed: {}({})", (Object)processInstance.getProcessName(), (Object)processInstance.getId());
        this.activeProcesses.completed();
    }
}

