/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.longrest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.undertow.Undertow;
import io.undertow.servlet.api.DeploymentInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.Cookie;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jbpm.process.longrest.ActiveTasks;
import org.jbpm.process.longrest.JaxRsActivator;
import org.jbpm.process.longrest.LongRunningRestServiceWorkItemHandler;
import org.jbpm.process.longrest.RemoteInvocationException;
import org.jbpm.process.longrest.RestServiceProcessEventListener;
import org.jbpm.process.longrest.bpm.TestFunctions;
import org.jbpm.process.longrest.demoservices.CookieListener;
import org.jbpm.process.longrest.demoservices.EventType;
import org.jbpm.process.longrest.demoservices.ServiceListener;
import org.jbpm.process.longrest.demoservices.dto.PreBuildRequest;
import org.jbpm.process.longrest.demoservices.dto.Request;
import org.jbpm.process.longrest.demoservices.dto.Scm;
import org.jbpm.process.longrest.util.Maps;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServiceWorkitemIntegrationTest
extends JbpmJUnitBaseTestCase {
    private final Logger logger = LoggerFactory.getLogger(RestServiceWorkitemIntegrationTest.class);
    private static int PORT = 8080;
    private static String DEFAULT_HOST = "localhost";
    private UndertowJaxrsServer server;
    private ObjectMapper objectMapper = new ObjectMapper();
    private final ActiveTasks activeProcesses = new ActiveTasks();
    private final ServiceListener serviceListener = new ServiceListener();
    private final CookieListener cookieListener = new CookieListener();

    public RestServiceWorkitemIntegrationTest() {
        super(true, true);
    }

    @Before
    public void preTestSetup() throws Exception {
        System.setProperty("HOSTNAME_HTTP", "localhost:8080");
        this.setupPoolingDataSource();
        HashMap<String, ResourceType> resources = new HashMap<String, ResourceType>();
        resources.put("execute-rest.bpmn", ResourceType.BPMN2);
        resources.put("test-process.bpmn", ResourceType.BPMN2);
        this.manager = this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, resources);
        this.customProcessListeners.add(new RestServiceProcessEventListener(this.activeProcesses));
        this.customHandlers.put("LongRunningRestService", new LongRunningRestServiceWorkItemHandler(this.manager));
        this.bootUpServices();
    }

    @After
    public void postTestTeardown() throws Exception {
        this.logger.info("Stopping http server ...");
        this.server.stop();
    }

    private void bootUpServices() throws Exception {
        this.server = new UndertowJaxrsServer();
        ResteasyDeployment deployment = new ResteasyDeployment();
        deployment.setApplicationClass(JaxRsActivator.class.getName());
        DeploymentInfo deploymentInfo = this.server.undertowDeployment(deployment, "/");
        deploymentInfo.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        deploymentInfo.setDeploymentName("TestServices");
        deploymentInfo.setContextPath("/");
        deploymentInfo.addServletContextAttribute("serviceListener", (Object)this.serviceListener);
        deploymentInfo.addServletContextAttribute("cookieListener", (Object)this.cookieListener);
        deploymentInfo.addServletContextAttribute("runtimeManager", (Object)this.manager);
        this.server.deploy(deploymentInfo);
        Undertow.Builder builder = Undertow.builder().addHttpListener(PORT, "localhost");
        this.server.start(builder);
    }

    @Test(timeout=15000L)
    public void shouldInvokeRemoteServiceAndReceiveCallback() throws Exception {
        ArrayBlockingQueue<ProcessVariableChangedEvent> variableChangedQueue = new ArrayBlockingQueue<ProcessVariableChangedEvent>(1000);
        ProcessEventListener processEventListener = this.getProcessEventListener(variableChangedQueue, "preBuildResult", "buildResult", "completionResult");
        this.customProcessListeners.add(processEventListener);
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession kieSession = runtimeEngine.getKieSession();
        Semaphore callbackCompleted = new Semaphore(0);
        ServiceListener.Subscription subscription = this.serviceListener.subscribe(EventType.CALLBACK_COMPLETED, v -> callbackCompleted.release());
        HashMap<String, Object> labels = new HashMap<String, Object>();
        labels.put("A", 1);
        labels.put("lines", "two\nlines");
        labels.put("quote", "String \"literal\".");
        ProcessInstance processInstance = kieSession.startProcess("testProcess", Collections.singletonMap("input", this.getProcessParameters(1, 30, 1, 30, labels)));
        this.manager.disposeRuntimeEngine(runtimeEngine);
        variableChangedQueue.take();
        variableChangedQueue.take();
        Map preBuildCallbackResult = (Map)((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
        this.logger.info("preBuildCallbackResult: " + preBuildCallbackResult);
        Map preBuildResponse = Maps.getStringObjectMap((Map)preBuildCallbackResult, (String)"response");
        Assert.assertEquals((Object)"new-scm-tag", Maps.getStringObjectMap((Map)preBuildResponse, (String)"scm").get("revision"));
        Map initialResponse = Maps.getStringObjectMap((Map)preBuildCallbackResult, (String)"initialResponse");
        Assert.assertTrue((boolean)initialResponse.get("cancelUrl").toString().startsWith("http://localhost:8080/demo-service/cancel/"));
        Map buildCallbackResult = (Map)((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
        this.logger.info("buildCallbackResult: " + buildCallbackResult);
        Map buildResponse = Maps.getStringObjectMap((Map)preBuildCallbackResult, (String)"response");
        Assert.assertEquals((Object)"SUCCESS", buildResponse.get("status"));
        Map completionResult = (Map)((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
        this.logger.info("completionResult: " + completionResult);
        Assert.assertEquals((Object)"SUCCESS", completionResult.get("status"));
        Map responseLabels = (Map)((Map)completionResult.get("response")).get("labels");
        Assert.assertEquals(labels.get("lines"), responseLabels.get("lines"));
        Assert.assertEquals(labels.get("quote"), responseLabels.get("quote"));
        this.logger.info("Waiting for callback to complete...");
        callbackCompleted.acquire(2);
        this.logger.info("Callback completed.");
        this.customProcessListeners.remove(processEventListener);
        this.serviceListener.unsubscribe(subscription);
    }

    @Test(timeout=20000L)
    public void shouldCatchException() throws Exception {
        ArrayBlockingQueue<ProcessVariableChangedEvent> variableChangedQueue = new ArrayBlockingQueue<ProcessVariableChangedEvent>(1000);
        ProcessEventListener processEventListener = this.getProcessEventListener(variableChangedQueue, "preBuildResult");
        this.customProcessListeners.add(processEventListener);
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession kieSession = runtimeEngine.getKieSession();
        Map<String, Object> processParameters = this.getProcessParameters(2, 10, 10, 10, Collections.emptyMap());
        processParameters.put("preBuildServiceUrl", "http://host-not-found:8080/");
        ProcessInstance processInstance = kieSession.startProcess("testProcess", Collections.singletonMap("input", processParameters));
        this.manager.disposeRuntimeEngine(runtimeEngine);
        variableChangedQueue.take();
        Map preBuildCallbackResult = (Map)((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
        this.logger.info("preBuildCallbackResult: " + preBuildCallbackResult);
        RemoteInvocationException exception = (RemoteInvocationException)preBuildCallbackResult.get("error");
        this.logger.info("Expected exception: {}.", (Object)exception.getMessage());
        Assert.assertNotNull((Object)exception);
        this.customProcessListeners.remove(processEventListener);
    }

    @Test(timeout=20000L)
    public void shouldRetryFailedRequest() throws Exception {
        ArrayBlockingQueue<ProcessVariableChangedEvent> variableChangedQueue = new ArrayBlockingQueue<ProcessVariableChangedEvent>(1000);
        ProcessEventListener processEventListener = this.getProcessEventListener(variableChangedQueue, "preBuildResult", "retryAttempt", "completionResult");
        this.customProcessListeners.add(processEventListener);
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession kieSession = runtimeEngine.getKieSession();
        Map<String, Object> processParameters = this.getProcessParameters(2, 10, 10, 10, Collections.emptyMap());
        processParameters.put("preBuildServiceUrl", "http://host-not-found:8080/");
        processParameters.put("retryDelay", 250);
        processParameters.put("maxRetries", 3);
        ProcessInstance processInstance = kieSession.startProcess("testProcess", Collections.singletonMap("input", processParameters));
        this.manager.disposeRuntimeEngine(runtimeEngine);
        variableChangedQueue.take();
        variableChangedQueue.take();
        variableChangedQueue.take();
        variableChangedQueue.take();
        Integer retryAttempt = (Integer)((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
        Assert.assertEquals((Object)"3", (Object)retryAttempt.toString());
        Map preBuildCallbackResult = (Map)((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
        this.logger.info("preBuildCallbackResult: " + preBuildCallbackResult);
        RemoteInvocationException exception = (RemoteInvocationException)preBuildCallbackResult.get("error");
        this.logger.info("Expected exception: {}.", (Object)exception.getMessage());
        Assert.assertNotNull((Object)exception);
        variableChangedQueue.take();
        variableChangedQueue.take();
        variableChangedQueue.take();
        ProcessVariableChangedEvent event = (ProcessVariableChangedEvent)variableChangedQueue.take();
        Object newValue = event.getNewValue();
        this.customProcessListeners.remove(processEventListener);
    }

    @Test(timeout=15000L)
    public void testTimeoutServiceDoesNotRespondCancelSuccess() throws InterruptedException {
        ArrayBlockingQueue<ProcessVariableChangedEvent> variableChangedQueue = new ArrayBlockingQueue<ProcessVariableChangedEvent>(1000);
        ProcessEventListener processEventListener = this.getProcessEventListener(variableChangedQueue, "restResponse", "preBuildResult");
        this.customProcessListeners.add(processEventListener);
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession kieSession = runtimeEngine.getKieSession();
        Semaphore callbackCompleted = new Semaphore(0);
        AtomicInteger buildRequested = new AtomicInteger();
        ServiceListener.Subscription subscription = this.serviceListener.subscribe(EventType.CALLBACK_COMPLETED, v -> callbackCompleted.release());
        ServiceListener.Subscription buildSubscription = this.serviceListener.subscribe(EventType.BUILD_REQUESTED, v -> buildRequested.incrementAndGet());
        ProcessInstance processInstance = kieSession.startProcess("testProcess", Collections.singletonMap("input", this.getProcessParameters(10, 30, 1, 30, Collections.emptyMap())));
        this.manager.disposeRuntimeEngine(runtimeEngine);
        variableChangedQueue.take();
        ((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
        RuntimeEngine runtimeEngineCancel = this.getRuntimeEngine(processInstance.getId());
        this.logger.info("Signalling cancel ...");
        runtimeEngineCancel.getKieSession().signalEvent("CancelAll", null);
        this.manager.disposeRuntimeEngine(runtimeEngineCancel);
        Map preBuildCallbackResult = (Map)((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
        this.logger.info("preBuildCallbackResult: " + preBuildCallbackResult);
        Map preBuildResponse = Maps.getStringObjectMap((Map)preBuildCallbackResult, (String)"response");
        Assert.assertEquals((Object)"true", preBuildResponse.get("cancelled"));
        this.logger.info("Waiting for all processes to complete...");
        this.activeProcesses.waitAllCompleted();
        this.logger.info("All processes completed.");
        this.logger.info("Waiting for callback to complete...");
        callbackCompleted.acquire();
        this.logger.info("Callback completed.");
        Assert.assertEquals((long)0L, (long)buildRequested.get());
        this.customProcessListeners.remove(processEventListener);
        this.serviceListener.unsubscribe(subscription);
    }

    @Test(timeout=15000L)
    public void serviceTimesOutInternalCancelSucceeds() throws InterruptedException {
        ArrayBlockingQueue<ProcessVariableChangedEvent> variableChangedQueue = new ArrayBlockingQueue<ProcessVariableChangedEvent>(1000);
        ProcessEventListener processEventListener = this.getProcessEventListener(variableChangedQueue, "preBuildResult", "completionResult");
        this.customProcessListeners.add(processEventListener);
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession kieSession = runtimeEngine.getKieSession();
        Semaphore callbackCompleted = new Semaphore(0);
        ServiceListener.Subscription subscription = this.serviceListener.subscribe(EventType.CALLBACK_COMPLETED, v -> callbackCompleted.release());
        HashMap cookies = new HashMap();
        this.cookieListener.addConsumer(h -> cookies.putAll(h));
        ProcessInstance processInstance = kieSession.startProcess("testProcess", Collections.singletonMap("input", this.getProcessParameters(10, 2, 1, 30, Collections.emptyMap())));
        this.manager.disposeRuntimeEngine(runtimeEngine);
        variableChangedQueue.take();
        ((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
        Map preBuildResult = (Map)((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
        this.logger.info("preBuildResult: " + preBuildResult);
        Map preBuildResponse = Maps.getStringObjectMap((Map)preBuildResult, (String)"response");
        Assert.assertEquals((Object)"true", preBuildResponse.get("cancelled"));
        Assert.assertEquals((Object)"TIMED_OUT", preBuildResult.get("status"));
        Map<String, Object> completionResult = this.getChangedVariable(variableChangedQueue, "completionResult");
        this.logger.info("completionResult: " + completionResult);
        Assert.assertEquals((Object)"SUCCESS", (Object)completionResult.get("status"));
        this.activeProcesses.waitAllCompleted();
        callbackCompleted.acquire();
        Assert.assertFalse((boolean)cookies.isEmpty());
        Assert.assertEquals((Object)"myCookieValue", (Object)((Cookie)cookies.get("myCookieName")).getValue());
        this.customProcessListeners.remove(processEventListener);
        this.serviceListener.unsubscribe(subscription);
    }

    @Test(timeout=15000L)
    public void serviceTimesOutInternalCancelTimesOut() throws InterruptedException {
        ArrayBlockingQueue<ProcessVariableChangedEvent> variableChangedQueue = new ArrayBlockingQueue<ProcessVariableChangedEvent>(1000);
        ProcessEventListener processEventListener = this.getProcessEventListener(variableChangedQueue, "preBuildResult");
        this.customProcessListeners.add(processEventListener);
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession kieSession = runtimeEngine.getKieSession();
        Semaphore callbackCompleted = new Semaphore(0);
        ServiceListener.Subscription subscription = this.serviceListener.subscribe(EventType.CALLBACK_COMPLETED, v -> callbackCompleted.release());
        ProcessInstance processInstance = kieSession.startProcess("testProcess", Collections.singletonMap("input", this.getProcessParameters(10, 2, 10, 2, Collections.emptyMap())));
        this.manager.disposeRuntimeEngine(runtimeEngine);
        variableChangedQueue.take();
        ((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
        Map preBuildResult = (Map)((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
        this.logger.info("preBuildResult: " + preBuildResult);
        Map preBuildResponse = Maps.getStringObjectMap((Map)preBuildResult, (String)"response");
        Assert.assertEquals((Object)"TIMED_OUT", preBuildResult.get("status"));
        this.activeProcesses.waitAllCompleted();
        callbackCompleted.acquire();
        this.customProcessListeners.remove(processEventListener);
        this.serviceListener.unsubscribe(subscription);
    }

    @Test(timeout=15000L)
    public void shouldStartAndCompleteExecuteRestProcess() throws InterruptedException {
        final Semaphore processFinished = new Semaphore(0);
        final ArrayBlockingQueue variableChangedQueue = new ArrayBlockingQueue(1000);
        DefaultProcessEventListener processEventListener = new DefaultProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                RestServiceWorkitemIntegrationTest.this.logger.info("Event ID: {}, event node ID: {}, event node name: {}", new Object[]{event.getNodeInstance().getId(), event.getNodeInstance().getNodeId(), event.getNodeInstance().getNodeName()});
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                RestServiceWorkitemIntegrationTest.this.logger.info("Process completed, unblocking test.");
                processFinished.release();
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                String variableId = event.getVariableId();
                RestServiceWorkitemIntegrationTest.this.logger.info("Process: {}, variable: {}, changed to: {}.", new Object[]{event.getProcessInstance().getProcessName(), variableId, event.getNewValue()});
                String[] enqueueEvents = new String[]{"result"};
                if (Arrays.asList(enqueueEvents).contains(variableId)) {
                    variableChangedQueue.add(event);
                }
            }
        };
        this.customProcessListeners.add(processEventListener);
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession kieSession = runtimeEngine.getKieSession();
        ProcessInstance processInstance = kieSession.startProcess("org.jbpm.process.longrest.executerest", this.getExecuteRestParameters());
        this.manager.disposeRuntimeEngine(runtimeEngine);
        boolean completed = processFinished.tryAcquire(15L, TimeUnit.SECONDS);
        if (!completed) {
            Assert.fail((String)"Failed to complete the process.");
        }
        Map result = (Map)((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
        this.logger.info("result: " + result);
        Assert.assertEquals((Object)"new-scm-tag", Maps.getStringObjectMap((Map)Maps.getStringObjectMap((Map)result, (String)"response"), (String)"scm").get("revision"));
        this.customProcessListeners.remove(processEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=15000L)
    public void shouldFailWhenThereIsNoHeartBeat() throws InterruptedException {
        ArrayBlockingQueue<ProcessVariableChangedEvent> variableChangedQueue = new ArrayBlockingQueue<ProcessVariableChangedEvent>(1000);
        ProcessEventListener processEventListener = this.getProcessEventListener(variableChangedQueue, "preBuildResult");
        this.customProcessListeners.add(processEventListener);
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession kieSession = runtimeEngine.getKieSession();
        Semaphore callbackCompleted = new Semaphore(0);
        ServiceListener.Subscription subscription = this.serviceListener.subscribe(EventType.CALLBACK_COMPLETED, v -> callbackCompleted.release());
        TestFunctions.addHeartBeatToRequest = true;
        try {
            ProcessInstance processInstance = kieSession.startProcess("testProcess", Collections.singletonMap("input", this.getProcessParameters(10, 10, 10, 2, 2, 4, Collections.emptyMap())));
            this.manager.disposeRuntimeEngine(runtimeEngine);
            variableChangedQueue.take();
            Map preBuildResult = (Map)((ProcessVariableChangedEvent)variableChangedQueue.take()).getNewValue();
            this.logger.info("preBuildResult: " + preBuildResult);
            Map preBuildResponse = Maps.getStringObjectMap((Map)preBuildResult, (String)"response");
            Assert.assertEquals((Object)"DIED", preBuildResult.get("status"));
            this.activeProcesses.waitAllCompleted();
            callbackCompleted.acquire();
            this.customProcessListeners.remove(processEventListener);
            this.serviceListener.unsubscribe(subscription);
        }
        finally {
            TestFunctions.addHeartBeatToRequest = false;
        }
    }

    private Map<String, Object> getExecuteRestParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("requestMethod", "POST");
        parameters.put("requestHeaders", null);
        parameters.put("requestUrl", "http://localhost:8080/demo-service/prebuild");
        parameters.put("requestTemplate", this.getPreBuildRequestBody());
        parameters.put("taskTimeout", "10");
        parameters.put("cancel", false);
        parameters.put("cancelTimeout", null);
        parameters.put("cancelUrlJsonPointer", null);
        parameters.put("cancelUrlTemplate", null);
        parameters.put("cancelUrlTemplate", null);
        parameters.put("cancelMethod", null);
        parameters.put("cancelHeaders", null);
        parameters.put("successEvalTemplate", null);
        return parameters;
    }

    private String getPreBuildRequestBody() {
        PreBuildRequest request = new PreBuildRequest();
        Scm scm = new Scm();
        scm.setUrl("https://github.com/kiegroup/jbpm-work-items.git");
        request.setScm(scm);
        Request callback = new Request();
        callback.setMethod("POST");
        callback.setUrl("@{system.callbackUrl}");
        request.setCallback(callback);
        try {
            return this.objectMapper.writeValueAsString((Object)request);
        }
        catch (JsonProcessingException e) {
            Assert.fail((String)("Cannot serialize preBuildRequest: " + e.getMessage()));
            return null;
        }
    }

    private Map<String, Object> getProcessParameters(int preBuildCallbackDelay, int preBuildTimeout, int cancelDelay, int preBuildCancelTimeout, Map<String, Object> labels) {
        return this.getProcessParameters(preBuildCallbackDelay, preBuildTimeout, cancelDelay, preBuildCancelTimeout, 10, 0, labels);
    }

    private Map<String, Object> getProcessParameters(int preBuildCallbackDelay, int preBuildTimeout, int cancelDelay, int preBuildCancelTimeout, int cancelHeartBeatAfter, int heartbeatTimeout, Map<String, Object> labels) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("serviceBaseUrl", "http://localhost:8080/demo-service");
        parameters.put("preBuildServiceUrl", "http://localhost:8080/demo-service/prebuild?callbackDelay=" + preBuildCallbackDelay + "&cancelDelay=" + cancelDelay + "&cancelHeartBeatAfter=" + cancelHeartBeatAfter);
        parameters.put("preBuildTimeout", preBuildTimeout);
        parameters.put("preBuildCancelTimeout", preBuildCancelTimeout);
        parameters.put("retryDelay", 0);
        parameters.put("maxRetries", 0);
        parameters.put("heartbeatTimeout", heartbeatTimeout);
        HashMap<String, Object> buildConfiguration = new HashMap<String, Object>();
        buildConfiguration.put("id", "1");
        buildConfiguration.put("scmRepoURL", "https://github.com/kiegroup/jbpm-work-items.git");
        buildConfiguration.put("scmRevision", "main");
        buildConfiguration.put("preBuildSyncEnabled", "true");
        buildConfiguration.put("buildScript", "true");
        buildConfiguration.put("labels", labels);
        parameters.put("buildConfiguration", buildConfiguration);
        return parameters;
    }

    private KieSession getKieSession(long processInstanceId) {
        RuntimeEngine runtimeEngine = this.getRuntimeEngine(processInstanceId);
        return runtimeEngine.getKieSession();
    }

    private RuntimeEngine getRuntimeEngine(long processInstanceId) {
        ProcessInstanceIdContext processInstanceContext = ProcessInstanceIdContext.get((Long)processInstanceId);
        return this.manager.getRuntimeEngine((Context)processInstanceContext);
    }

    private ProcessEventListener getProcessEventListener(final BlockingQueue<ProcessVariableChangedEvent> variableChangedQueue, final String ... enqueueEvents) {
        return new DefaultProcessEventListener(){

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                String variableId = event.getVariableId();
                RestServiceWorkitemIntegrationTest.this.logger.info("Process: {}, variable: {}, changed to: {}.", new Object[]{event.getProcessInstance().getProcessName(), variableId, event.getNewValue()});
                if (Arrays.asList(enqueueEvents).contains(variableId)) {
                    variableChangedQueue.add(event);
                }
            }
        };
    }

    private Map<String, Object> getChangedVariable(BlockingQueue<ProcessVariableChangedEvent> variableChangedQueue, String variableName) throws InterruptedException {
        ProcessVariableChangedEvent event;
        while (!(event = variableChangedQueue.take()).getVariableId().equals(variableName)) {
        }
        return (Map)event.getNewValue();
    }
}

