/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.longrest.bpm;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.api.runtime.process.ProcessContext;

public class TestFunctions
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final Logger logger = Logger.getLogger(TestFunctions.class.getName());
    public static boolean addHeartBeatToRequest = false;

    public String getPreBuildTemplate() {
        String template = "{     'scm': {       'url': @{quote(input.buildConfiguration.scmRepoURL)},       'revision': @{quote(input.buildConfiguration.scmRevision)}    },    'syncEnabled': @{quote(input.buildConfiguration.preBuildSyncEnabled)},    'callback': {       'url': @{quote(system.callbackUrl)},       'method': @{quote(system.callbackMethod)} ";
        if (addHeartBeatToRequest) {
            template = template + "   },    'heartBeat': {       'url': @{quote(system.heartBeatUrl)},       'method': @{quote(system.heartBeatMethod)} ";
        }
        template = template + "   } }";
        return template.replace("'", "\"");
    }

    public String getBuildTemplate() {
        return "{     'buildScript': @{quote(input.buildConfiguration.buildScript)},    'scm': {       'url': @{quote(preBuildResult.response.scm.url)},       'revision': @{quote(preBuildResult.response.scm.revision)}    },    'callback': {       'url': @{quote(system.callbackUrl)},       'method': @{quote(system.callbackMethod)}    } }".replace("'", "\"");
    }

    public String getCompletionTemplate() {
        return "{    'buildConfigurationId': @{quote(input.buildConfiguration.id)},    'scm': {       'url': @{quote(preBuildResult.?response.?scm.url)},       'revision': @{quote(preBuildResult.?response.?scm.revision)}    },    'completionStatus': '@{functions.getCompletionStatus(preBuildResult.?status, ?buildResult.?status)}',    'labels': @{asJson(input.buildConfiguration.labels, true)} }".replace("'", "\"");
    }

    public static void logInfo(ProcessContext kcontext, String msg) {
        logger.info("Process: " + kcontext.getProcessInstance().getProcessName() + " id: " + kcontext.getProcessInstance().getId() + " ; " + msg);
    }

    public static ProcessCompletionStatus getCompletionStatus(String prebuildStatus, String buildStatus) {
        try {
            logger.info("PrebuildStatus: " + prebuildStatus);
            logger.info("BuildStatus: " + buildStatus);
            if (prebuildStatus == null) {
                logger.info("Operation failed with SYSTEM_ERROR.");
                return ProcessCompletionStatus.SYSTEM_ERROR;
            }
            if (prebuildStatus.equals("FAILED")) {
                logger.info("Operation FAILED.");
                return ProcessCompletionStatus.FAILED;
            }
            if (prebuildStatus.equals("CANCELLED")) {
                logger.info("Operation CANCELLED.");
                return ProcessCompletionStatus.CANCELLED;
            }
            if (prebuildStatus.equals("TIMED_OUT")) {
                logger.info("Operation TIMED_OUT.");
                return ProcessCompletionStatus.TIMED_OUT;
            }
            if (buildStatus != null) {
                if (buildStatus.equals("FAILED")) {
                    logger.info("Operation FAILED.");
                    return ProcessCompletionStatus.FAILED;
                }
                if (buildStatus.equals("CANCELLED")) {
                    logger.info("Operation CANCELLED.");
                    return ProcessCompletionStatus.CANCELLED;
                }
                if (buildStatus.equals("TIMED_OUT")) {
                    logger.info("Operation TIMED_OUT.");
                    return ProcessCompletionStatus.TIMED_OUT;
                }
            }
            logger.info("Process status SUCCESS.");
            return ProcessCompletionStatus.SUCCESS;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error processing process status.", e);
            return ProcessCompletionStatus.SYSTEM_ERROR;
        }
    }

    public static enum ProcessCompletionStatus {
        SUCCESS,
        FAILED,
        CANCELLED,
        TIMED_OUT,
        SYSTEM_ERROR;

    }
}

