/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.longrest.demoservices;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import org.jbpm.process.longrest.demoservices.EventType;

public class ServiceListener {
    private Collection<Subscription> subscriptions = new HashSet<Subscription>();

    public void fire(EventType eventType, Object event) {
        this.subscriptions.stream().filter(s -> eventType.equals((Object)s.getEventType())).forEach(s -> s.getConsumer().accept(event));
    }

    public Subscription subscribe(EventType eventType, Consumer<Object> consumer) {
        Subscription subscription = new Subscription(eventType, consumer);
        this.subscriptions.add(subscription);
        return subscription;
    }

    public void unsubscribe(Subscription subscription) {
        this.subscriptions.remove(subscription);
    }

    public class Subscription {
        private EventType eventType;
        private Consumer<Object> consumer;

        public Subscription(EventType eventType, Consumer<Object> consumer) {
            this.eventType = eventType;
            this.consumer = consumer;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public Consumer<Object> getConsumer() {
            return this.consumer;
        }
    }
}

