/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.mavenembedder;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.cli.MavenCli;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenEmbedderUtils {
    private static final Logger logger = LoggerFactory.getLogger(MavenEmbedderUtils.class);

    public static Map<String, Object> executeMavenGoals(MavenCli cli, String resultsKey, String projectRoot, String commandLineOptions, String goals, String workDir) throws Exception {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ByteArrayOutputStream baosOut = new ByteArrayOutputStream();
        ByteArrayOutputStream baosErr = new ByteArrayOutputStream();
        PrintStream cliOut = new PrintStream(baosOut, true);
        PrintStream cliErr = new PrintStream(baosErr, true);
        Object[] allCommandLineOptions = new String[]{};
        if (commandLineOptions != null && commandLineOptions.length() > 0) {
            allCommandLineOptions = commandLineOptions.split("\\s+");
        }
        Object[] allGoals = goals.split("\\s+");
        String[] allOptions = (String[])ArrayUtils.addAll((Object[])allGoals, (Object[])allCommandLineOptions);
        int result = cli.doMain(allOptions, workDir, cliOut, cliErr);
        String stdout = baosOut.toString("UTF-8");
        String stderr = baosErr.toString("UTF-8");
        if (result != 0) {
            logger.error("Maven build finished with unexpected result = {}", (Object)result);
            if (StringUtils.isNotEmpty((CharSequence)stdout)) {
                logger.error("Standard output of the Maven command was :\n{}", (Object)stdout);
            }
            if (StringUtils.isNotEmpty((CharSequence)stderr)) {
                logger.error("Standard error output of the Maven command was:\n{}", (Object)stderr);
            }
            throw new RuntimeException(String.format("Maven build finished with unexpected result = %s. See the error log for more information", result));
        }
        HashMap<String, String> mavenResults = new HashMap<String, String>();
        mavenResults.put("stdout", stdout);
        mavenResults.put("stderr", stderr);
        results.put(resultsKey, mavenResults);
        return results;
    }

    public static enum MavenEmbedderMode {
        SYNC,
        ASYNC;

    }
}

