/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.owm;

import java.util.HashMap;
import net.aksingh.owmjapis.core.OWM;
import net.aksingh.owmjapis.model.CurrentWeather;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.owm.CurrentWeatherData;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="CurrentWeatherDefinitions.wid", name="CurrentWeather", displayName="CurrentWeather", defaultHandler="mvel: new org.jbpm.process.workitem.owm.CurrentWeatherWorkitemHandler()", documentation="openweathermap-workitem/index.html", parameters={@WidParameter(name="CityName", required=true), @WidParameter(name="CountryCode")}, results={@WidResult(name="CurrentWeatherData")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="openweathermap-workitem", version="7.10.0.Final")}, serviceInfo=@WidService(category="Weather Info", description="Retrieve weather info using OpenWeatherMap", keywords="openweathermap,weather,current", action=@WidAction(title="Get current weather information for a location")))
public class CurrentWeatherWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(CurrentWeatherWorkitemHandler.class);
    private static final String RESULTS_VALUES = "CurrentWeatherData";
    private String apiKey;
    private OWM owm;

    public CurrentWeatherWorkitemHandler(String apiKey) {
        this.apiKey = apiKey;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            CurrentWeather currentWeather;
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String cityName = (String)workItem.getParameter("CityName");
            String countryCode = (String)workItem.getParameter("CountryCode");
            HashMap<String, CurrentWeatherData> results = new HashMap<String, CurrentWeatherData>();
            CurrentWeatherData cwd = new CurrentWeatherData();
            if (this.owm == null) {
                this.owm = new OWM(this.apiKey);
            }
            if ((currentWeather = countryCode == null ? this.owm.currentWeatherByCityName(cityName) : this.owm.currentWeatherByCityName(cityName, OWM.Country.valueOf((String)countryCode))).hasRespCode() && currentWeather.getRespCode() == 200) {
                if (currentWeather.hasCityName()) {
                    cwd.setCityName(currentWeather.getCityName());
                }
                if (currentWeather.hasDateTime()) {
                    cwd.setDate(currentWeather.getDateTime());
                }
                if (currentWeather.hasMainData()) {
                    cwd.setTemp(currentWeather.getMainData().getTemp());
                    cwd.setMinTemp(currentWeather.getMainData().getTempMin());
                    cwd.setMaxTemp(currentWeather.getMainData().getTempMax());
                    cwd.setPressure(currentWeather.getMainData().getPressure());
                    cwd.setHumidity(currentWeather.getMainData().getHumidity());
                }
                if (currentWeather.hasRainData()) {
                    cwd.setPrecipitation(currentWeather.getRainData().getPrecipVol3h());
                }
                if (currentWeather.hasCloudData()) {
                    cwd.setCloud(currentWeather.getCloudData().getCloud());
                }
                if (currentWeather.hasSnowData()) {
                    cwd.setSnow(currentWeather.getSnowData().getSnowVol3h());
                }
                if (currentWeather.hasWindData()) {
                    cwd.setWidDegree(currentWeather.getWindData().getDegree());
                    cwd.setWindSpeed(currentWeather.getWindData().getSpeed());
                    cwd.setWindGust(currentWeather.getWindData().getGust());
                }
                if (currentWeather.hassystemData()) {
                    cwd.setSunrise(currentWeather.getSystemData().getSunriseDateTime());
                    cwd.setSunset(currentWeather.getSystemData().getSunsetDateTime());
                }
            } else {
                logger.error("Unable to retrieve weather info.");
            }
            results.put(RESULTS_VALUES, cwd);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public void setOWM(OWM owm) {
        this.owm = owm;
    }
}

