/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.owm;

import java.util.HashMap;
import java.util.List;
import net.aksingh.owmjapis.core.OWM;
import net.aksingh.owmjapis.model.DailyWeatherForecast;
import net.aksingh.owmjapis.model.param.ForecastData;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.owm.CurrentWeatherWorkitemHandler;
import org.jbpm.process.workitem.owm.DailyForecastData;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="DailyForecastDefinitions.wid", name="DailyForecast", displayName="DailyForecast", defaultHandler="mvel: new org.jbpm.process.workitem.owm.DailyForecastWorkitemHandler(\"apiKey\")", documentation="openweathermap-workitem/index.html", category="openweathermap-workitem", icon="DailyForecast.png", parameters={@WidParameter(name="CityName", required=true), @WidParameter(name="CountryCode")}, results={@WidResult(name="DailyForecastData", runtimeType="org.jbpm.process.workitem.owm.DailyForecastData")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="openweathermap-workitem", version="7.24.0.Final")}, serviceInfo=@WidService(category="Weather Info", description="Retrieve weather info using OpenWeatherMap", keywords="openweathermap,weather,daily,forecase", action=@WidAction(title="Get the weather daily forecast for a location"), authinfo=@WidAuth(required=true, params={"apiKey"}, paramsdescription={"OpenWeatherMap api key"}, referencesite="https://openweathermap.org/appid")))
public class DailyForecastWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(CurrentWeatherWorkitemHandler.class);
    private static final String RESULTS_VALUES = "DailyForecastData";
    private String apiKey;
    private OWM owm;

    public DailyForecastWorkitemHandler(String apiKey) {
        this.apiKey = apiKey;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            DailyWeatherForecast dailyWeatherForecast;
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String cityName = (String)workItem.getParameter("CityName");
            String countryCode = (String)workItem.getParameter("CountryCode");
            HashMap<String, DailyForecastData> results = new HashMap<String, DailyForecastData>();
            DailyForecastData dfd = new DailyForecastData();
            if (this.owm == null) {
                this.owm = new OWM(this.apiKey);
            }
            if ((dailyWeatherForecast = countryCode == null ? this.owm.dailyWeatherForecastByCityName(cityName) : this.owm.dailyWeatherForecastByCityName(cityName, OWM.Country.valueOf((String)countryCode))).hasRespCode() && dailyWeatherForecast.getRespCode().equals("200")) {
                if (dailyWeatherForecast.hasCityData()) {
                    dfd.setCityName(dailyWeatherForecast.getCityData().getName());
                }
                if (dailyWeatherForecast.hasDataCount()) {
                    dfd.setDataCount(dailyWeatherForecast.getDataCount());
                }
                if (dailyWeatherForecast.hasDataList()) {
                    List forecastDataList = dailyWeatherForecast.getDataList();
                    for (ForecastData forecastData : forecastDataList) {
                        DailyForecastData.DailyForecastDay dailyForecastDay = dfd.new DailyForecastData.DailyForecastDay();
                        dailyForecastDay.setDate(forecastData.getDateTime());
                        dailyForecastDay.setCloud(forecastData.getCloud());
                        dailyForecastDay.setHumidity(forecastData.getHumidity());
                        dailyForecastDay.setPressure(forecastData.getPressure());
                        dailyForecastDay.setRain(forecastData.getRain());
                        dailyForecastDay.setSnow(forecastData.getSnow());
                        dailyForecastDay.setSpeed(forecastData.getSpeed());
                        dailyForecastDay.setMaxTemp(forecastData.getTempData().getTempMax());
                        dailyForecastDay.setMinTemp(forecastData.getTempData().getTempMin());
                        dailyForecastDay.setDayTemp(forecastData.getTempData().getTempDay());
                        dailyForecastDay.setMorningTemp(forecastData.getTempData().getTempMorning());
                        dailyForecastDay.setEveningTemp(forecastData.getTempData().getTempEvening());
                        dailyForecastDay.setNightTemp(forecastData.getTempData().getTempNight());
                        dfd.getDailyForecastDayList().add(dailyForecastDay);
                    }
                }
            } else {
                logger.error("Unable to retrieve weather info.");
            }
            results.put(RESULTS_VALUES, dfd);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public void setOWM(OWM owm) {
        this.owm = owm;
    }
}

