/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.owm;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.aksingh.owmjapis.core.OWM;
import net.aksingh.owmjapis.model.CurrentWeather;
import net.aksingh.owmjapis.model.DailyWeatherForecast;
import net.aksingh.owmjapis.model.param.City;
import net.aksingh.owmjapis.model.param.ForecastData;
import net.aksingh.owmjapis.model.param.Main;
import net.aksingh.owmjapis.model.param.Temp;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.owm.CurrentWeatherData;
import org.jbpm.process.workitem.owm.CurrentWeatherWorkitemHandler;
import org.jbpm.process.workitem.owm.DailyForecastData;
import org.jbpm.process.workitem.owm.DailyForecastWorkitemHandler;
import org.jbpm.test.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Matchers;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={OWM.class, CurrentWeather.class, DailyWeatherForecast.class, Main.class, City.class, ForecastData.class, Temp.class})
public class OpenWeatherMapWorkitemHandlerTest
extends AbstractBaseTest {
    private OWM owm;

    @Before
    public void setUp() {
        try {
            this.owm = (OWM)PowerMockito.mock(OWM.class);
            CurrentWeather currentWeather = (CurrentWeather)PowerMockito.mock(CurrentWeather.class);
            DailyWeatherForecast dailyWeatherForecast = (DailyWeatherForecast)PowerMockito.mock(DailyWeatherForecast.class);
            Main mainData = (Main)PowerMockito.mock(Main.class);
            City cityData = (City)PowerMockito.mock(City.class);
            ForecastData forecastData = (ForecastData)PowerMockito.mock(ForecastData.class);
            ArrayList<ForecastData> forecastDataList = new ArrayList<ForecastData>();
            forecastDataList.add(forecastData);
            Temp temp = (Temp)PowerMockito.mock(Temp.class);
            PowerMockito.when((Object)this.owm.currentWeatherByCityName(Matchers.anyString())).thenReturn((Object)currentWeather);
            PowerMockito.when((Object)this.owm.currentWeatherByCityName(Matchers.anyString(), (OWM.Country)Matchers.any(OWM.Country.class))).thenReturn((Object)currentWeather);
            PowerMockito.when((Object)this.owm.dailyWeatherForecastByCityName(Matchers.anyString())).thenReturn((Object)dailyWeatherForecast);
            PowerMockito.when((Object)this.owm.dailyWeatherForecastByCityName(Matchers.anyString(), (OWM.Country)Matchers.any(OWM.Country.class))).thenReturn((Object)dailyWeatherForecast);
            PowerMockito.when((Object)currentWeather.hasRespCode()).thenReturn((Object)true);
            PowerMockito.when((Object)currentWeather.getRespCode()).thenReturn((Object)200);
            PowerMockito.when((Object)currentWeather.hasCityName()).thenReturn((Object)true);
            PowerMockito.when((Object)currentWeather.getCityName()).thenReturn((Object)"testCityName");
            PowerMockito.when((Object)currentWeather.hasMainData()).thenReturn((Object)true);
            PowerMockito.when((Object)currentWeather.getMainData()).thenReturn((Object)mainData);
            PowerMockito.when((Object)mainData.getTemp()).thenReturn((Object)1.0);
            PowerMockito.when((Object)mainData.getTempMin()).thenReturn((Object)2.0);
            PowerMockito.when((Object)mainData.getTempMax()).thenReturn((Object)3.0);
            PowerMockito.when((Object)mainData.getPressure()).thenReturn((Object)4.0);
            PowerMockito.when((Object)mainData.getHumidity()).thenReturn((Object)5.0);
            PowerMockito.when((Object)currentWeather.hasDateTime()).thenReturn((Object)false);
            PowerMockito.when((Object)currentWeather.hasRainData()).thenReturn((Object)false);
            PowerMockito.when((Object)currentWeather.hasSnowData()).thenReturn((Object)false);
            PowerMockito.when((Object)currentWeather.hasCloudData()).thenReturn((Object)false);
            PowerMockito.when((Object)currentWeather.hasWindData()).thenReturn((Object)false);
            PowerMockito.when((Object)currentWeather.hassystemData()).thenReturn((Object)false);
            PowerMockito.when((Object)dailyWeatherForecast.hasRespCode()).thenReturn((Object)true);
            PowerMockito.when((Object)dailyWeatherForecast.getRespCode()).thenReturn((Object)"200");
            PowerMockito.when((Object)dailyWeatherForecast.hasCityData()).thenReturn((Object)true);
            PowerMockito.when((Object)dailyWeatherForecast.getCityData()).thenReturn((Object)cityData);
            PowerMockito.when((Object)cityData.getName()).thenReturn((Object)"testCityName");
            PowerMockito.when((Object)dailyWeatherForecast.hasDataCount()).thenReturn((Object)true);
            PowerMockito.when((Object)dailyWeatherForecast.getDataCount()).thenReturn((Object)1);
            PowerMockito.when((Object)dailyWeatherForecast.hasDataList()).thenReturn((Object)true);
            PowerMockito.when((Object)dailyWeatherForecast.getDataList()).thenReturn(forecastDataList);
            PowerMockito.when((Object)forecastData.getDateTime()).thenReturn((Object)new Date());
            PowerMockito.when((Object)forecastData.getCloud()).thenReturn((Object)1.0);
            PowerMockito.when((Object)forecastData.getHumidity()).thenReturn((Object)2.0);
            PowerMockito.when((Object)forecastData.getCloud()).thenReturn((Object)3.0);
            PowerMockito.when((Object)forecastData.getPressure()).thenReturn((Object)4.0);
            PowerMockito.when((Object)forecastData.getRain()).thenReturn((Object)5.0);
            PowerMockito.when((Object)forecastData.getSnow()).thenReturn((Object)6.0);
            PowerMockito.when((Object)forecastData.getSpeed()).thenReturn((Object)7.0);
            PowerMockito.when((Object)forecastData.getTempData()).thenReturn((Object)temp);
            PowerMockito.when((Object)temp.getTempMax()).thenReturn((Object)8.0);
            PowerMockito.when((Object)temp.getTempMin()).thenReturn((Object)9.0);
            PowerMockito.when((Object)temp.getTempDay()).thenReturn((Object)10.0);
            PowerMockito.when((Object)temp.getTempMorning()).thenReturn((Object)11.0);
            PowerMockito.when((Object)temp.getTempEvening()).thenReturn((Object)12.0);
            PowerMockito.when((Object)temp.getTempNight()).thenReturn((Object)13.0);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCurrentWeather() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("CityName", (Object)"Atlanta");
        workItem.setParameter("CountryCode", (Object)"UNITED_STATES");
        CurrentWeatherWorkitemHandler handler = new CurrentWeatherWorkitemHandler("testAPIKey");
        handler.setOWM(this.owm);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        CurrentWeatherData currentWeatherData = (CurrentWeatherData)((Map)manager.getResults().get(workItem.getId())).get("CurrentWeatherData");
        Assert.assertNotNull((Object)currentWeatherData);
        Assert.assertEquals((Object)1.0, (Object)currentWeatherData.getTemp());
        Assert.assertEquals((Object)2.0, (Object)currentWeatherData.getMinTemp());
        Assert.assertEquals((Object)3.0, (Object)currentWeatherData.getMaxTemp());
        Assert.assertEquals((Object)4.0, (Object)currentWeatherData.getPressure());
        Assert.assertEquals((Object)5.0, (Object)currentWeatherData.getHumidity());
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testCurrentWeatherInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        CurrentWeatherWorkitemHandler handler = new CurrentWeatherWorkitemHandler("testAPIKey");
        handler.setOWM(this.owm);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }

    @Test
    public void testDailyForecast() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("CityName", (Object)"Atlanta");
        workItem.setParameter("CountryCode", (Object)"UNITED_STATES");
        DailyForecastWorkitemHandler handler = new DailyForecastWorkitemHandler("testAPIKey");
        handler.setOWM(this.owm);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        DailyForecastData dailyForecastData = (DailyForecastData)((Map)manager.getResults().get(workItem.getId())).get("DailyForecastData");
        Assert.assertNotNull((Object)dailyForecastData);
        Assert.assertEquals((Object)"testCityName", (Object)dailyForecastData.getCityName());
        Assert.assertEquals((long)1L, (long)dailyForecastData.getDataCount());
        List dailyForecastDays = dailyForecastData.getDailyForecastDayList();
        Assert.assertNotNull((Object)dailyForecastDays);
        Assert.assertEquals((long)1L, (long)dailyForecastDays.size());
        Assert.assertEquals((Object)8.0, (Object)((DailyForecastData.DailyForecastDay)dailyForecastDays.get(0)).getMaxTemp());
        Assert.assertEquals((Object)3.0, (Object)((DailyForecastData.DailyForecastDay)dailyForecastDays.get(0)).getCloud());
        Assert.assertEquals((Object)4.0, (Object)((DailyForecastData.DailyForecastDay)dailyForecastDays.get(0)).getPressure());
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testDailyForecastInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        DailyForecastWorkitemHandler handler = new DailyForecastWorkitemHandler("testAPIKey");
        handler.setOWM(this.owm);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }
}

