/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.parser;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="ParserDefinitions.wid", name="Parser", displayName="Parser", defaultHandler="mvel: new org.jbpm.process.workitem.parser.ParserWorkItemHandler()", parameters={@WidParameter(name="Format"), @WidParameter(name="Type"), @WidParameter(name="Input")}, results={@WidResult(name="Result")}, mavenDepends={@WidMavenDepends(group="com.fasterxml.jackson.core", artifact="jackson-databind", version="2.6.2")})
public class ParserWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    public static final String JSON = "JSON";
    public static final String XML = "XML";
    public static final String FORMAT = "Format";
    public static final String TYPE = "Type";
    public static final String INPUT = "Input";
    public static final String RESULT = "Result";
    private ClassLoader cl;

    public ParserWorkItemHandler() {
        this.cl = ((Object)((Object)this)).getClass().getClassLoader();
    }

    public ParserWorkItemHandler(ClassLoader cl) {
        this.cl = cl;
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void executeWorkItem(WorkItem wi, WorkItemManager wim) {
        Object result = null;
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            String format = wi.getParameter(FORMAT).toString();
            Class<?> type = null;
            Object input = wi.getParameter(INPUT);
            boolean toObject = input instanceof String;
            if (toObject) {
                try {
                    String typeStr = wi.getParameter(TYPE).toString();
                    type = this.cl.loadClass(typeStr);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not load the provided type. The parameter Type is required when parsing from String to Object. Please provide the full qualified name of the target object class.", e);
                }
            }
            if (JSON.equals(format.toUpperCase())) {
                try {
                    result = toObject ? this.convertJSONToObject(input.toString(), type) : this.convertToJSON(input);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error parsing to JSON. Check the input format or the output object", e);
                }
            }
            if (XML.equals(format.toUpperCase())) {
                try {
                    result = toObject ? this.convertXMLToObject(input.toString(), type) : this.convertToXML(input);
                }
                catch (JAXBException e) {
                    throw new RuntimeException("Error parsing to XML. Check the input format or the output object", e);
                }
            }
            results.put(RESULT, result);
            wim.completeWorkItem(wi.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected Object convertXMLToObject(String input, Class<?> type) {
        return JAXB.unmarshal((Reader)new StringReader(input), type);
    }

    protected String convertToXML(Object input) throws JAXBException {
        StringWriter result = new StringWriter();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{input.getClass()});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)false);
        jaxbMarshaller.marshal(input, (Writer)result);
        return result.toString();
    }

    protected Object convertJSONToObject(String input, Class<?> type) throws JsonMappingException, IOException {
        return new ObjectMapper().readValue(input, type);
    }

    protected Object convertToJSON(Object input) throws JsonMappingException, IOException {
        return new ObjectMapper().writeValueAsString(input);
    }
}

