/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.parser;

import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.parser.ParserWorkItemHandler;
import org.jbpm.process.workitem.parser.Person;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

public class ParserWorkItemHandlerTest {
    final int AGE = 27;
    final String NAME = "William";
    final String PERSON_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>27</age><name>William</name></person>";
    final String PERSON_JSON = "{\"name\":\"William\",\"age\":27}";
    ParserWorkItemHandler handler;

    @Before
    public void init() {
        this.handler = new ParserWorkItemHandler();
    }

    @Test
    public void testXmlToObject() {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Input", (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>27</age><name>William</name></person>");
        workItem.setParameter("Format", (Object)"XML");
        workItem.setParameter("Type", (Object)"org.jbpm.process.workitem.parser.Person");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Person result = (Person)results.get("Result");
        Assert.assertEquals((long)27L, (long)result.getAge());
        Assert.assertEquals((Object)"William", (Object)result.getName());
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testXmlToObjectInvalidParams() {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((Object)0, (Object)results);
    }

    @Test
    public void testObjectToXml() {
        TestWorkItemManager manager = new TestWorkItemManager();
        Person p = new Person("William", 27);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Input", (Object)p);
        workItem.setParameter("Format", (Object)"XML");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>27</age><name>William</name></person>", (Object)result);
    }

    @Test
    public void testJsonToObject() {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Input", (Object)"{\"name\":\"William\",\"age\":27}");
        workItem.setParameter("Format", (Object)"JSON");
        workItem.setParameter("Type", (Object)"org.jbpm.process.workitem.parser.Person");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Person result = (Person)results.get("Result");
        Assert.assertEquals((long)27L, (long)result.getAge());
        Assert.assertEquals((Object)"William", (Object)result.getName());
    }

    @Test
    public void testObjectToJson() {
        TestWorkItemManager manager = new TestWorkItemManager();
        Person p = new Person("William", 27);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Input", (Object)p);
        workItem.setParameter("Format", (Object)"JSON");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertEquals((Object)"{\"name\":\"William\",\"age\":27}", (Object)result);
    }
}

