/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.pastebin;

import java.net.URL;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.pastebin.CreatePastebinWorkitemHandler;
import org.jbpm.process.workitem.pastebin.GetExistingPastebinWorkitemHandler;
import org.jbpm.test.AbstractBaseTest;
import org.jpastebin.pastebin.PastebinLink;
import org.jpastebin.pastebin.PastebinPaste;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PastebinWorkitemHandlerTest
extends AbstractBaseTest {
    @Mock
    PastebinPaste pastebin;
    @Mock
    PastebinLink pastebinLink;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.pastebin.paste()).thenReturn((Object)this.pastebinLink);
        Mockito.when((Object)this.pastebinLink.getPaste()).thenReturn((Object)this.pastebin);
    }

    @Test
    public void testCreateNewPasteDocContent() throws Exception {
        URL testURL = new URL("http://testpasteurl");
        Mockito.when((Object)this.pastebinLink.getLink()).thenReturn((Object)testURL);
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Title", (Object)"test Title");
        workItem.setParameter("Format", (Object)"text");
        workItem.setParameter("Visibility", (Object)"0");
        workItem.setParameter("Author", (Object)"testAuthor");
        workItem.setParameter("Pastebin", (Object)this.pastebin);
        DocumentImpl testPasteDoc = new DocumentImpl();
        testPasteDoc.setContent(new String("Test paste to send").getBytes());
        testPasteDoc.setName("testPaste.txt");
        workItem.setParameter("Content", (Object)testPasteDoc);
        CreatePastebinWorkitemHandler handler = new CreatePastebinWorkitemHandler("testDevKey");
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("PasteURL") instanceof URL));
        URL testPasteURL = (URL)((Map)manager.getResults().get(workItem.getId())).get("PasteURL");
        Assert.assertNotNull((Object)testPasteURL);
        Assert.assertEquals((Object)"http://testpasteurl", (Object)testPasteURL.toString());
    }

    @Test
    public void testCreateNewPasteStringContent() throws Exception {
        URL testURL = new URL("http://testpasteurl");
        Mockito.when((Object)this.pastebinLink.getLink()).thenReturn((Object)testURL);
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Title", (Object)"test Title");
        workItem.setParameter("Format", (Object)"text");
        workItem.setParameter("Visibility", (Object)"0");
        workItem.setParameter("Author", (Object)"testAuthor");
        workItem.setParameter("Pastebin", (Object)this.pastebin);
        workItem.setParameter("Content", (Object)"Test paste to send");
        CreatePastebinWorkitemHandler handler = new CreatePastebinWorkitemHandler("testDevKey");
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("PasteURL") instanceof URL));
        URL testPasteURL = (URL)((Map)manager.getResults().get(workItem.getId())).get("PasteURL");
        Assert.assertNotNull((Object)testPasteURL);
        Assert.assertEquals((Object)"http://testpasteurl", (Object)testPasteURL.toString());
    }

    @Test
    public void testGetExistingPasteContent() throws Exception {
        ((PastebinLink)Mockito.doNothing().when((Object)this.pastebinLink)).fetchContent();
        Mockito.when((Object)this.pastebin.getContents()).thenReturn((Object)"test paste content");
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("PastebinKey", (Object)"testKey");
        workItem.setParameter("PastebinLink", (Object)this.pastebinLink);
        workItem.setParameter("Content", (Object)"Test paste to send");
        GetExistingPastebinWorkitemHandler handler = new GetExistingPastebinWorkitemHandler("testDevKey");
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("PasteContent") instanceof String));
        String testPasteContent = (String)((Map)manager.getResults().get(workItem.getId())).get("PasteContent");
        Assert.assertNotNull((Object)testPasteContent);
        Assert.assertEquals((Object)"test paste content", (Object)testPasteContent);
    }
}

