/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.pastebin;

import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.pastebin.CreatePastebinWorkitemHandler;
import org.jpastebin.pastebin.Pastebin;
import org.jpastebin.pastebin.PastebinLink;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GetPastebin.wid", name="GetPastebin", displayName="GetPastebin", defaultHandler="mvel: new org.jbpm.process.workitem.pastebin.GetExistingPastebinWorkitemHandler(\"develKey\")", documentation="pastebin-workitem/index.html", category="pastebin-workitem", icon="GetPastebin.png", parameters={@WidParameter(name="PastebinKey", required=true)}, results={@WidResult(name="PasteContent")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="pastebin-workitem", version="7.44.0.Final")}, serviceInfo=@WidService(category="Pastebin", description="Create new or get existing pastes from Pastebin", keywords="paste,pastebin,get,existing", action=@WidAction(title="Get an existing Pastebin"), authinfo=@WidAuth(required=true, params={"develKey"}, paramsdescription={"Pastebin developer key"}, referencesite="https://pastebin.com/api.php")))
public class GetExistingPastebinWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String develKey;
    private static final Logger logger = LoggerFactory.getLogger(CreatePastebinWorkitemHandler.class);
    private static final String RESULTS_VALUE = "PasteContent";

    public GetExistingPastebinWorkitemHandler(String develKey) {
        this.develKey = develKey;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            HashMap<String, String> results = new HashMap<String, String>();
            String pastebinKey = (String)workItem.getParameter("PastebinKey");
            PastebinLink pastebinLink = (PastebinLink)workItem.getParameter("PastebinLink");
            if (pastebinLink == null) {
                pastebinLink = Pastebin.getPaste((String)pastebinKey);
            }
            pastebinLink.fetchContent();
            results.put(RESULTS_VALUE, pastebinLink.getPaste().getContents());
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }
}

