/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.pastebin;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.jbpm.document.Document;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jpastebin.pastebin.PastebinLink;
import org.jpastebin.pastebin.PastebinPaste;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="CreatePastebin.wid", name="CreatePastebin", displayName="CreatePastebin", defaultHandler="mvel: new org.jbpm.process.workitem.pastebin.CreatePastebinWorkitemHandler(\"develKey\")", documentation="pastebin-workitem/index.html", category="pastebin-workitem", icon="CreatePastebin.png", parameters={@WidParameter(name="Title"), @WidParameter(name="Content", required=true, runtimeType="java.lang.Object"), @WidParameter(name="Format"), @WidParameter(name="Visibility"), @WidParameter(name="Author")}, results={@WidResult(name="PasteURL", runtimeType="java.net.URL")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="pastebin-workitem", version="7.46.0.Final")}, serviceInfo=@WidService(category="Pastebin", description="Create new or get existing pastes from Pastebin", keywords="paste,pastebin,create", action=@WidAction(title="Create a paste on Pastebin"), authinfo=@WidAuth(required=true, params={"develKey"}, paramsdescription={"Pastebin developer key"}, referencesite="https://pastebin.com/api.php")))
public class CreatePastebinWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String develKey;
    private static final Logger logger = LoggerFactory.getLogger(CreatePastebinWorkitemHandler.class);
    private static final String RESULTS_VALUE = "PasteURL";

    public CreatePastebinWorkitemHandler(String develKey) {
        this.develKey = develKey;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            HashMap<String, URL> results = new HashMap<String, URL>();
            String title = (String)workItem.getParameter("Title");
            Object content = workItem.getParameter("Content");
            String format = (String)workItem.getParameter("Format");
            String visibility = (String)workItem.getParameter("Visibility");
            String author = (String)workItem.getParameter("Author");
            PastebinPaste pastebin = (PastebinPaste)workItem.getParameter("Pastebin");
            if (pastebin == null) {
                pastebin = new PastebinPaste();
            }
            pastebin.setDeveloperKey(this.develKey);
            if (content instanceof Document) {
                pastebin.setContents(new String(((Document)content).getContent(), StandardCharsets.UTF_8));
            } else if (content instanceof String) {
                pastebin.setContents((String)content);
            } else {
                throw new IllegalArgumentException("Invalid type for " + content + ". Should be Document or String type");
            }
            if (title != null && title.trim().length() > 0) {
                pastebin.setPasteTitle(title);
            }
            if (format != null && format.trim().length() > 0) {
                pastebin.setPasteFormat(format);
            }
            if (visibility != null && visibility.trim().length() > 0 && visibility.matches("-?\\d+")) {
                int visibilityInt = Integer.parseInt(visibility);
                switch (visibilityInt) {
                    case 0: {
                        pastebin.setVisibility(0);
                        break;
                    }
                    case 1: {
                        pastebin.setVisibility(1);
                        break;
                    }
                    case 2: {
                        pastebin.setVisibility(2);
                        break;
                    }
                    default: {
                        pastebin.setVisibility(0);
                        break;
                    }
                }
            } else {
                pastebin.setVisibility(0);
            }
            if (author != null) {
                pastebin.setPasteAuthor(author);
            }
            PastebinLink pastebinLink = pastebin.paste();
            results.put(RESULTS_VALUE, pastebinLink.getLink());
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }
}

