/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.pdf;

import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.document.Document;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.pdf.GeneratePDFWorkitemHandler;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

public class GeneratePDFWorkitemHandlerTest {
    @Test
    public void testGeneratePDF() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        String testTemplate = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<body>\n<p>Hello ${testData.firstName} ${testData.lastName}</p>\n</body>\n</html>";
        TestTemplateData testTemplateData = new TestTemplateData();
        testTemplateData.setFirstName("testFirstName");
        testTemplateData.setLastName("testLastName");
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("TemplateXHTML", (Object)testTemplate);
        workItem.setParameter("testData", (Object)testTemplateData);
        GeneratePDFWorkitemHandler handler = new GeneratePDFWorkitemHandler();
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("PDFDocument") instanceof Document));
        Document generatedPDFDoc = (Document)((Map)manager.getResults().get(workItem.getId())).get("PDFDocument");
        Assert.assertNotNull((Object)generatedPDFDoc);
        Assert.assertEquals((Object)generatedPDFDoc.getName(), (Object)"generatedpdf.pdf");
        Assert.assertNotNull((Object)generatedPDFDoc.getContent());
        Assert.assertEquals((Object)"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<body>\n<p>Hello testFirstName testLastName</p>\n</body>\n</html>", (Object)handler.getResultXHTML());
    }

    public class TestTemplateData {
        public String firstName;
        public String lastName;

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }
    }
}

