/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.twitter;

import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.twitter.SendDirectMessageWorkitemHandler;
import org.jbpm.process.workitem.twitter.TwitterAuth;
import org.jbpm.process.workitem.twitter.UpdateStatusWorkitemHandler;
import org.jbpm.test.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.modules.junit4.PowerMockRunner;
import twitter4j.DirectMessage;
import twitter4j.Status;
import twitter4j.StatusUpdate;
import twitter4j.Twitter;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"jdk.internal.reflect.*"})
public class TwitterWorkitemHandlerTest
extends AbstractBaseTest {
    @Mock
    Twitter twitter;
    @Mock
    TwitterAuth auth;
    @Mock
    Status status;
    @Mock
    DirectMessage directMessage;

    @Before
    public void setUp() {
        try {
            PowerMockito.when((Object)this.auth.getTwitterService(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), ((Boolean)Matchers.any(Boolean.TYPE)).booleanValue())).thenReturn((Object)this.twitter);
            PowerMockito.when((Object)this.twitter.updateStatus((StatusUpdate)Matchers.any(StatusUpdate.class))).thenReturn((Object)this.status);
            PowerMockito.when((Object)this.twitter.sendDirectMessage(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.directMessage);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUpdateStatus() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("StatusUpdate", (Object)"testUpdateStatus");
        UpdateStatusWorkitemHandler handler = new UpdateStatusWorkitemHandler("testConsumerKey", "testConsumerSecret", "testAccessKey", "testAccessSecret");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        StatusUpdate handlerStatusUpdate = handler.getStatusUpdate();
        Assert.assertNotNull((Object)handlerStatusUpdate);
        Assert.assertEquals((Object)"testUpdateStatus", (Object)handlerStatusUpdate.getStatus());
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testUpdateStatusInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        UpdateStatusWorkitemHandler handler = new UpdateStatusWorkitemHandler("testConsumerKey", "testConsumerSecret", "testAccessKey", "testAccessSecret");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }

    @Test
    public void testUpdateStatusWithMedia() throws Exception {
        DocumentImpl testMediaDoc = new DocumentImpl();
        testMediaDoc.setContent(new String("Test media to send").getBytes());
        testMediaDoc.setName("testMediaToSend.txt");
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("StatusUpdate", (Object)"testUpdateStatus");
        workItem.setParameter("Media", (Object)testMediaDoc);
        UpdateStatusWorkitemHandler handler = new UpdateStatusWorkitemHandler("testConsumerKey", "testConsumerSecret", "testAccessKey", "testAccessSecret");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        StatusUpdate handlerStatusUpdate = handler.getStatusUpdate();
        Assert.assertNotNull((Object)handlerStatusUpdate);
        Assert.assertEquals((Object)"testUpdateStatus", (Object)handlerStatusUpdate.getStatus());
    }

    @Test
    public void testSendDirectMessage() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Message", (Object)"hello there");
        workItem.setParameter("ScreenName", (Object)"testScreenName");
        SendDirectMessageWorkitemHandler handler = new SendDirectMessageWorkitemHandler("testConsumerKey", "testConsumerSecret", "testAccessKey", "testAccessSecret");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testSendDirectMessageInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        SendDirectMessageWorkitemHandler handler = new SendDirectMessageWorkitemHandler("testConsumerKey", "testConsumerSecret", "testAccessKey", "testAccessSecret");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }
}

