/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.vimeo;

import com.clickntap.vimeo.Vimeo;
import com.clickntap.vimeo.VimeoResponse;
import java.io.File;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.vimeo.DeleteVideoWorkitemHandler;
import org.jbpm.process.workitem.vimeo.GetVideoInfoWorkitemHandler;
import org.jbpm.process.workitem.vimeo.UpdateVideoMetadataWorkitemHandler;
import org.jbpm.process.workitem.vimeo.UploadVideoWorkitemHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class VimeoWorkitemHandlerTest {
    @Mock
    Vimeo vimeo;
    @Mock
    VimeoResponse vimeoResponse;

    @Before
    public void setUp() {
        try {
            Mockito.when((Object)this.vimeo.addVideo((File)Mockito.any(File.class), Mockito.anyBoolean())).thenReturn((Object)"testVideEndPoint");
            Mockito.when((Object)this.vimeo.updateVideoMetadata((String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)this.vimeoResponse);
            Mockito.when((Object)this.vimeo.getVideoInfo(Mockito.anyString())).thenReturn((Object)this.vimeoResponse);
            Mockito.when((Object)this.vimeo.removeVideo(Mockito.anyString())).thenReturn((Object)this.vimeoResponse);
            Mockito.when((Object)this.vimeoResponse.getStatusCode()).thenReturn((Object)200);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUploadVideo() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        File tempFile = File.createTempFile("testfile", ".tmp");
        tempFile.deleteOnExit();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("VideoFile", (Object)tempFile);
        workItem.setParameter("Vimeo", (Object)this.vimeo);
        UploadVideoWorkitemHandler handler = new UploadVideoWorkitemHandler("testAccessToken");
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testUpdateVideoMetadata() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("VideoEndpoint", (Object)"testVideoEndpoint");
        workItem.setParameter("Vimeo", (Object)this.vimeo);
        UpdateVideoMetadataWorkitemHandler handler = new UpdateVideoMetadataWorkitemHandler("testAccessToken");
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testGetVideoInfo() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("VideoEndpoint", (Object)"testVideoEndpoint");
        workItem.setParameter("Vimeo", (Object)this.vimeo);
        GetVideoInfoWorkitemHandler handler = new GetVideoInfoWorkitemHandler("testAccessToken");
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testDeleteVideo() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("VideoEndpoint", (Object)"testVideoEndpoint");
        workItem.setParameter("Vimeo", (Object)this.vimeo);
        DeleteVideoWorkitemHandler handler = new DeleteVideoWorkitemHandler("testAccessToken");
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }
}

