/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dashboard.annotation.Install;
import org.jboss.dashboard.provider.DataPropertyFormatterImpl;

@Install
public class jBPMDataPropertyFormatter
extends DataPropertyFormatterImpl {
    private static final String NO_VALUE = "---";
    private static final Double DOUBLE_ZERO = new Double(0.0);

    public String[] getSupportedPropertyIds() {
        return new String[]{"duration", "status", "user_identity", "userid"};
    }

    public String formatValue(String propertyId, Object value, Locale l) {
        String result = null;
        Method m = null;
        try {
            m = ((Object)((Object)this)).getClass().getMethod("formatValue_" + propertyId, Object.class, Locale.class);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            if (m != null) {
                result = (String)m.invoke((Object)this, value, l);
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (result != null) {
            return result;
        }
        return super.formatValue(propertyId, value, l);
    }

    public String formatValue_duration(Object value, Locale l) throws Exception {
        if (value == null || !(value instanceof Number)) {
            return NO_VALUE;
        }
        if (value != null && DOUBLE_ZERO.equals(value)) {
            return NO_VALUE;
        }
        Number lengthInSeconds = (Number)value;
        long millis = lengthInSeconds.longValue();
        if (millis < 0L) {
            millis = 0L;
        }
        return this.formatElapsedTime(millis, l);
    }

    public String formatValue_status(Object value, Locale l) throws Exception {
        try {
            if (value == null) {
                return NO_VALUE;
            }
            if (value instanceof List) {
                return null;
            }
            ResourceBundle i18n = this.getBunle(l);
            return i18n.getString("status." + value.toString());
        }
        catch (Exception e) {
            return value.toString();
        }
    }

    public String formatValue_user_identity(Object value, Locale l) throws Exception {
        return this.formatUser(value, l);
    }

    public String formatValue_userid(Object value, Locale l) throws Exception {
        return this.formatUser(value, l);
    }

    public String formatUser(Object value, Locale l) throws Exception {
        try {
            String valueStr;
            if (value != null && (valueStr = (String)value).trim().length() > 0) {
                return value.toString();
            }
            ResourceBundle i18n = this.getBunle(l);
            return i18n.getString("user.notAssinged");
        }
        catch (Exception e) {
            return value.toString();
        }
    }

    public String formatElapsedTime(long millis, Locale l) {
        long milliseconds = millis;
        long seconds = milliseconds / 1000L;
        milliseconds %= 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        long weeks = days / 7L;
        ResourceBundle i18n = this.getBunle(l);
        String pattern = "ellapsedtime.hours";
        if ((days %= 7L) > 0L) {
            pattern = "ellapsedtime.days";
        }
        if (weeks > 0L) {
            pattern = "ellapsedtime.weeks";
        }
        return MessageFormat.format(i18n.getString(pattern), new Long(seconds), new Long(minutes), new Long(hours), new Long(days), new Long(weeks));
    }

    protected ResourceBundle getBunle(Locale l) {
        return ResourceBundle.getBundle("org.jbpm.dashboard.messages", l);
    }
}

