/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.inject.Inject;
import org.jboss.dashboard.LocaleManager;
import org.jboss.dashboard.annotation.Install;
import org.jboss.dashboard.provider.DataPropertyFormatterImpl;

@Install
public class jBPMDataPropertyFormatter
extends DataPropertyFormatterImpl {
    private static final String NO_VALUE = "---";
    private static final Double DOUBLE_ZERO = new Double(0.0);
    @Inject
    protected LocaleManager localeManager;

    public String[] getSupportedPropertyIds() {
        return new String[]{"pminduration", "pavgduration", "pmaxduration", "tminduration", "tavgduration", "tmaxduration", "status", "userid"};
    }

    public String formatValue(String propertyId, Object value, Locale l) {
        if (value instanceof Collection) {
            return super.formatCollection(propertyId, (Collection)value, ", ", null, null, l);
        }
        if (propertyId.indexOf("duration") != -1) {
            return this.formatValue_duration(value, l);
        }
        if (propertyId.equals("status")) {
            return this.formatValue_status(value, l);
        }
        if (propertyId.equals("userid")) {
            return this.formatValue_userid(value, l);
        }
        return super.formatValue(propertyId, value, l);
    }

    public String formatValue_duration(Object value, Locale l) {
        if (value == null || !(value instanceof Number)) {
            return NO_VALUE;
        }
        if (value != null && DOUBLE_ZERO.equals(value)) {
            return NO_VALUE;
        }
        Number lengthInSeconds = (Number)value;
        long millis = lengthInSeconds.longValue();
        if (millis < 0L) {
            millis = 0L;
        }
        return this.formatElapsedTime(millis, l);
    }

    public String formatValue_status(Object value, Locale l) {
        try {
            if (value == null) {
                return NO_VALUE;
            }
            ResourceBundle i18n = this.getBundle(l);
            return i18n.getString("status." + value.toString());
        }
        catch (Exception e) {
            return value.toString();
        }
    }

    public String formatValue_userid(Object value, Locale l) {
        try {
            String valueStr;
            if (value != null && (valueStr = (String)value).trim().length() > 0) {
                return value.toString();
            }
            ResourceBundle i18n = this.getBundle(l);
            return i18n.getString("user.notAssinged");
        }
        catch (Exception e) {
            return value.toString();
        }
    }

    public String formatElapsedTime(long millis, Locale l) {
        long milliseconds = millis;
        long seconds = milliseconds / 1000L;
        milliseconds %= 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        long weeks = days / 7L;
        ResourceBundle i18n = this.getBundle(l);
        String pattern = "ellapsedtime.hours";
        if ((days %= 7L) > 0L) {
            pattern = "ellapsedtime.days";
        }
        if (weeks > 0L) {
            pattern = "ellapsedtime.weeks";
        }
        return MessageFormat.format(i18n.getString(pattern), new Long(seconds), new Long(minutes), new Long(hours), new Long(days), new Long(weeks));
    }

    protected ResourceBundle getBundle(Locale l) {
        return this.localeManager.getBundle("org.jbpm.dashboard.messages", l);
    }
}

