/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.droolsjbpm.services.api.Domain;
import org.droolsjbpm.services.api.SessionManager;
import org.droolsjbpm.services.api.bpmn2.BPMN2DataService;
import org.droolsjbpm.services.impl.event.listeners.CDIKbaseEventListener;
import org.droolsjbpm.services.impl.event.listeners.CDIProcessEventListener;
import org.droolsjbpm.services.impl.helpers.StatefulKnowledgeSessionDelegate;
import org.jbpm.task.api.TaskServiceEntryPoint;
import org.jbpm.task.wih.CDIHTWorkItemHandler;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderError;
import org.kie.builder.KnowledgeBuilderErrors;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.builder.ResourceType;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.Path;
import org.kie.event.KnowledgeRuntimeEventManager;
import org.kie.event.knowledgebase.KnowledgeBaseEventListener;
import org.kie.event.process.ProcessEventListener;
import org.kie.io.ResourceFactory;
import org.kie.logger.KnowledgeRuntimeLoggerFactory;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.WorkItemHandler;

public class CDISessionManager
implements SessionManager {
    @Inject
    private TaskServiceEntryPoint taskService;
    @Inject
    private CDIHTWorkItemHandler handler;
    @Inject
    private CDIProcessEventListener processListener;
    @Inject
    private CDIKbaseEventListener kbaseEventListener;
    @Inject
    private BPMN2DataService bpmn2Service;
    private Domain domain;
    private Map<String, StatefulKnowledgeSession> ksessions = new HashMap<String, StatefulKnowledgeSession>();
    private Map<String, Integer> ksessionIds = new HashMap<String, Integer>();
    private Map<String, Long> processInstanceIdKsession = new HashMap<String, Long>();
    private Map<String, List<String>> processDefinitionNamesBySession = new HashMap<String, List<String>>();

    public CDISessionManager() {
    }

    public CDISessionManager(Domain domain) {
        this.domain = domain;
    }

    @Override
    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public void buildSessions() {
        this.processListener.setDomainName(this.domain.getName());
        this.kbaseEventListener.setDomainName(this.domain.getName());
        this.processListener.setSessionManager(this);
        Map<String, List<Path>> ksessionAssets = this.domain.getKsessionAssets();
        for (String session : ksessionAssets.keySet()) {
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            for (Path path : ksessionAssets.get(session)) {
                String processString = new String(Files.readAllBytes((Path)path));
                this.addProcessDefinitionToSession(session, this.bpmn2Service.getProcessDesc(processString).getId());
                kbuilder.add(ResourceFactory.newByteArrayResource((byte[])processString.getBytes()), ResourceType.BPMN2);
            }
            if (!kbuilder.getErrors().isEmpty()) {
                KnowledgeBuilderErrors errors = kbuilder.getErrors();
                Iterator iterator = errors.iterator();
                while (iterator.hasNext()) {
                    System.out.println("Error: " + ((KnowledgeBuilderError)iterator.next()).getMessage());
                }
                continue;
            }
            KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
            kbase.addEventListener((KnowledgeBaseEventListener)this.kbaseEventListener);
            kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
            StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
            ksession.addEventListener((ProcessEventListener)this.processListener);
            KnowledgeRuntimeLoggerFactory.newConsoleLogger((KnowledgeRuntimeEventManager)ksession);
            this.handler.setSession((KnowledgeRuntime)ksession);
            this.handler.init();
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)this.handler);
            StatefulKnowledgeSessionDelegate statefulKnowledgeSessionDelegate = new StatefulKnowledgeSessionDelegate(session, ksession, this);
            this.ksessions.put(session, statefulKnowledgeSessionDelegate);
            this.ksessionIds.put(session, ksession.getId());
        }
    }

    @Override
    public Map<String, StatefulKnowledgeSession> getKsessions() {
        return this.ksessions;
    }

    @Override
    public void setKsessions(Map<String, StatefulKnowledgeSession> ksessions) {
        this.ksessions = ksessions;
    }

    @Override
    public void addKsession(String name, StatefulKnowledgeSession ksession) {
        this.ksessions.put(name, ksession);
    }

    @Override
    public Map<String, Long> getProcessInstanceIdKsession() {
        return this.processInstanceIdKsession;
    }

    @Override
    public void setProcessInstanceIdKsession(Map<String, Long> processInstanceIdKsession) {
        this.processInstanceIdKsession = processInstanceIdKsession;
    }

    @Override
    public void addProcessInstanceIdKsession(String ksessionName, Long processInstanceId) {
        this.processInstanceIdKsession.put(ksessionName, processInstanceId);
    }

    @Override
    public StatefulKnowledgeSession getKsessionByName(String ksessionName) {
        return this.ksessions.get(ksessionName);
    }

    @Override
    public String getSessionForProcessInstanceId(Long processInstanceId) {
        for (String sessionName : this.processInstanceIdKsession.keySet()) {
            if (this.processInstanceIdKsession.get(sessionName) != processInstanceId) continue;
            return sessionName;
        }
        return null;
    }

    @Override
    public int getSessionIdByName(String ksessionName) {
        return this.ksessionIds.get(ksessionName);
    }

    @Override
    public Collection<String> getAllSessionsNames() {
        return this.ksessions.keySet();
    }

    public Map<String, List<String>> getProcessDefinitionNamesBySession() {
        return this.processDefinitionNamesBySession;
    }

    @Override
    public void addProcessDefinitionToSession(String sessionName, String processId) {
        if (this.processDefinitionNamesBySession.get(sessionName) == null) {
            this.processDefinitionNamesBySession.put(sessionName, new ArrayList());
        }
        this.processDefinitionNamesBySession.get(sessionName).add(processId);
    }

    @Override
    public void removeProcessDefinitionFromSession(String sessionName, String processId) {
        if (this.processDefinitionNamesBySession.get(sessionName) != null) {
            this.processDefinitionNamesBySession.get(sessionName).remove(processId);
        }
    }

    @Override
    public Collection<String> getProcessesInSession(String sessionName) {
        return this.processDefinitionNamesBySession.get(sessionName);
    }

    @Override
    public String getProcessInSessionByName(String processDefId) {
        for (String sessionName : this.processDefinitionNamesBySession.keySet()) {
            for (String processDef : this.processDefinitionNamesBySession.get(sessionName)) {
                if (!processDef.equals(processDefId)) continue;
                return sessionName;
            }
        }
        return "";
    }
}

