/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.droolsjbpm.services.api.FileException;
import org.droolsjbpm.services.api.FileService;
import org.droolsjbpm.services.api.KnowledgeDomainService;
import org.droolsjbpm.services.api.bpmn2.BPMN2DataService;
import org.droolsjbpm.services.impl.event.listeners.CDIKbaseEventListener;
import org.droolsjbpm.services.impl.event.listeners.CDIProcessEventListener;
import org.jbpm.task.wih.CDIHTWorkItemHandler;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.builder.ResourceType;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.Path;
import org.kie.event.KnowledgeRuntimeEventManager;
import org.kie.event.knowledgebase.KnowledgeBaseEventListener;
import org.kie.event.process.ProcessEventListener;
import org.kie.io.ResourceFactory;
import org.kie.logger.KnowledgeRuntimeLoggerFactory;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.WorkItemHandler;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

@ApplicationScoped
public class KnowledgeDomainServiceImpl
implements KnowledgeDomainService {
    private Map<String, StatefulKnowledgeSession> ksessions = new HashMap<String, StatefulKnowledgeSession>();
    @Inject
    private CDIHTWorkItemHandler handler;
    @Inject
    private CDIProcessEventListener processListener;
    @Inject
    private CDIKbaseEventListener kbaseEventListener;
    @Inject
    private BPMN2DataService bpmn2Service;
    @Inject
    private FileService fs;
    private Map<String, String> availableProcesses = new HashMap<String, String>();
    private long id = 0L;
    private String domainName = "My Business Unit";
    private long parentId;

    @Override
    @PostConstruct
    public void createDomain() {
        this.kbaseEventListener.setDomainName(this.domainName);
        this.processListener.setDomainName(this.domainName);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Iterable<Path> loadFilesByType = null;
        try {
            loadFilesByType = this.fs.loadFilesByType("examples/general/", "bpmn");
        }
        catch (FileException ex) {
            Logger.getLogger(KnowledgeDomainServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (Path p : loadFilesByType) {
            System.out.println(" >>>>>>>>>>>>>>>>>>>>>>>>>>> Loading -> " + p.toString());
            String processString = new String(Files.readAllBytes((Path)p));
            this.availableProcesses.put(this.bpmn2Service.getProcessDesc(processString).getId(), processString);
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])Files.readAllBytes((Path)p)), ResourceType.BPMN2);
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addEventListener((KnowledgeBaseEventListener)this.kbaseEventListener);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.addEventListener((ProcessEventListener)this.processListener);
        KnowledgeRuntimeLoggerFactory.newConsoleLogger((KnowledgeRuntimeEventManager)ksession);
        this.handler.setSession((KnowledgeRuntime)ksession);
        this.handler.init();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)this.handler);
        this.ksessions.put("default", ksession);
    }

    @Override
    public void registerSession(String businessKey, StatefulKnowledgeSession ksession) {
        this.ksessions.put(businessKey, ksession);
    }

    @Override
    public StatefulKnowledgeSession getSession(long sessionId) {
        throw new NotImplementedException();
    }

    @Override
    public StatefulKnowledgeSession getSessionByBusinessKey(String businessKey) {
        return this.ksessions.get(businessKey);
    }

    @Override
    public Collection<StatefulKnowledgeSession> getSessions() {
        return this.ksessions.values();
    }

    @Override
    public Collection<String> getSessionsNames() {
        return this.ksessions.keySet();
    }

    @Override
    public int getAmountOfSessions() {
        return this.ksessions.size();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Override
    public Long getParentId() {
        return this.parentId;
    }

    @Override
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    @Override
    public Map<String, String> getAvailableProcesses() {
        return this.availableProcesses;
    }
}

