/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl.bpmn2;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.compiler.BPMN2ProcessFactory;
import org.drools.compiler.BPMN2ProcessProvider;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.io.impl.ByteArrayResource;
import org.drools.xml.SemanticModule;
import org.droolsjbpm.services.api.bpmn2.BPMN2DataService;
import org.droolsjbpm.services.impl.bpmn2.BPMN2DataServiceSemanticModule;
import org.droolsjbpm.services.impl.bpmn2.ProcessDescRepoHelper;
import org.droolsjbpm.services.impl.model.ProcessDesc;
import org.jbpm.task.TaskDef;
import org.jbpm.task.api.TaskServiceEntryPoint;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.builder.ResourceType;
import org.kie.io.Resource;

@ApplicationScoped
public class BPMN2DataServiceImpl
implements BPMN2DataService {
    @Inject
    private TaskServiceEntryPoint taskService;
    @Inject
    private BPMN2DataServiceSemanticModule module;
    private BPMN2ProcessProvider provider;
    @Inject
    private ProcessDescRepoHelper repo;

    @PostConstruct
    public void init() {
        this.module.setRepo(this.repo);
        this.provider = new BPMN2ProcessProvider(){

            public void configurePackageBuilder(PackageBuilder packageBuilder) {
                PackageBuilderConfiguration conf = packageBuilder.getPackageBuilderConfiguration();
                if (conf.getSemanticModules().getSemanticModule("http://www.jboss.org/bpmn2-data-services") == null) {
                    conf.addSemanticModule((SemanticModule)BPMN2DataServiceImpl.this.module);
                }
            }
        };
    }

    @Override
    public Map<String, String> getTaskInputMappings(String bpmn2Content, String taskName) {
        if (bpmn2Content == null || "".equals(bpmn2Content)) {
            throw new IllegalStateException("The Process Content cannot be Empty!");
        }
        this.repo.clear();
        BPMN2ProcessProvider originalProvider = BPMN2ProcessFactory.getBPMN2ProcessProvider();
        if (originalProvider != this.provider) {
            BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)this.provider);
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), ResourceType.BPMN2);
        if (kbuilder.hasErrors()) {
            throw new IllegalStateException("Process Cannot be Parsed!");
        }
        BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)originalProvider);
        return this.repo.getTaskInputMappings().get(taskName);
    }

    @Override
    public Map<String, String> getTaskOutputMappings(String bpmn2Content, String taskName) {
        if (bpmn2Content == null || "".equals(bpmn2Content)) {
            throw new IllegalStateException("The Process Content cannot be Empty!");
        }
        this.repo.clear();
        BPMN2ProcessProvider originalProvider = BPMN2ProcessFactory.getBPMN2ProcessProvider();
        if (originalProvider != this.provider) {
            BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)this.provider);
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), ResourceType.BPMN2);
        if (kbuilder.hasErrors()) {
            throw new IllegalStateException("Process Cannot be Parsed!");
        }
        BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)originalProvider);
        return this.repo.getTaskOutputMappings().get(taskName);
    }

    @Override
    public Collection<TaskDef> getAllTasksDef(String bpmn2Content) {
        if (bpmn2Content == null || "".equals(bpmn2Content)) {
            throw new IllegalStateException("The Process Content cannot be Empty!");
        }
        this.repo.clear();
        BPMN2ProcessProvider originalProvider = BPMN2ProcessFactory.getBPMN2ProcessProvider();
        if (originalProvider != this.provider) {
            BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)this.provider);
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), ResourceType.BPMN2);
        if (kbuilder.hasErrors()) {
            throw new IllegalStateException("Process Cannot be Parsed!");
        }
        BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)originalProvider);
        return this.repo.getTasks().values();
    }

    @Override
    public Map<String, String> getAssociatedEntities(String bpmn2Content) {
        if (bpmn2Content == null || "".equals(bpmn2Content)) {
            throw new IllegalStateException("The Process Content cannot be Empty!");
        }
        this.repo.clear();
        BPMN2ProcessProvider originalProvider = BPMN2ProcessFactory.getBPMN2ProcessProvider();
        if (originalProvider != this.provider) {
            BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)this.provider);
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), ResourceType.BPMN2);
        if (kbuilder.hasErrors()) {
            throw new IllegalStateException("Process Cannot be Parsed!");
        }
        BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)originalProvider);
        return this.repo.getTaskAssignments();
    }

    @Override
    public List<String> getAssociatedDomainObjects(String bpmn2Content) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, String> getProcessData(String bpmn2Content) {
        if (bpmn2Content == null || "".equals(bpmn2Content)) {
            throw new IllegalStateException("The Process Content cannot be Empty!");
        }
        this.repo.clear();
        BPMN2ProcessProvider originalProvider = BPMN2ProcessFactory.getBPMN2ProcessProvider();
        if (originalProvider != this.provider) {
            BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)this.provider);
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), ResourceType.BPMN2);
        if (kbuilder.hasErrors()) {
            throw new IllegalStateException("Process Cannot be Parsed!");
        }
        BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)originalProvider);
        return this.repo.getInputs();
    }

    @Override
    public List<String> getAssociatedForms(String processId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ProcessDesc getProcessDesc(String bpmn2Content) {
        if (bpmn2Content == null || "".equals(bpmn2Content)) {
            throw new IllegalStateException("The Process Content cannot be Empty!");
        }
        this.repo.clear();
        BPMN2ProcessProvider originalProvider = BPMN2ProcessFactory.getBPMN2ProcessProvider();
        if (originalProvider != this.provider) {
            BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)this.provider);
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), ResourceType.BPMN2);
        if (kbuilder.hasErrors()) {
            throw new IllegalStateException("Process Cannot be Parsed!");
        }
        BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)originalProvider);
        return this.repo.getProcess();
    }
}

