/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl.form;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.droolsjbpm.services.api.FormProviderService;
import org.droolsjbpm.services.api.KnowledgeDomainService;
import org.droolsjbpm.services.api.bpmn2.BPMN2DataService;
import org.droolsjbpm.services.impl.model.ProcessDesc;
import org.jbpm.form.builder.services.api.FormDefinitionService;
import org.jbpm.form.builder.services.model.FormItemRepresentation;
import org.jbpm.form.builder.services.model.FormRepresentation;
import org.jbpm.form.builder.services.model.Formatter;
import org.jbpm.form.builder.services.model.InputData;
import org.jbpm.form.builder.services.model.OutputData;
import org.jbpm.form.builder.services.model.items.CompleteButtonRepresentation;
import org.jbpm.form.builder.services.model.items.HeaderRepresentation;
import org.jbpm.form.builder.services.model.items.LabelRepresentation;
import org.jbpm.form.builder.services.model.items.TableRepresentation;
import org.jbpm.form.builder.services.model.items.TextFieldRepresentation;
import org.jbpm.task.Content;
import org.jbpm.task.I18NText;
import org.jbpm.task.Task;
import org.jbpm.task.TaskDef;
import org.jbpm.task.api.TaskContentService;
import org.jbpm.task.api.TaskInstanceService;
import org.jbpm.task.api.TaskQueryService;
import org.jbpm.task.utils.ContentMarshallerHelper;

@ApplicationScoped
public class FormProviderServiceImpl
implements FormProviderService {
    @Inject
    private TaskQueryService queryService;
    @Inject
    private TaskContentService contentService;
    @Inject
    private TaskInstanceService instanceService;
    @Inject
    private BPMN2DataService bpmn2Service;
    @Inject
    private KnowledgeDomainService domainService;
    @Inject
    private FormDefinitionService formService;
    private Map<String, List<String>> effectsForItem = new HashMap<String, List<String>>();
    private Map<String, List<String>> actionsForItem = new HashMap<String, List<String>>();

    public void putEffectsForItem(String className, List<String> effectClassNames) {
        this.effectsForItem.put(className, effectClassNames);
    }

    public void putActionsForItem(String className, List<String> actionClassNames) {
        this.actionsForItem.put(className, actionClassNames);
    }

    @Override
    public String getFormDisplayProcess(String processId) {
        InputStream template = this.getClass().getResourceAsStream("/ftl/DefaultProcess.ftl");
        String processString = this.domainService.getAvailableProcesses().get(processId);
        Map<String, String> processData = this.bpmn2Service.getProcessData(processString);
        if (processData == null) {
            processData = new HashMap<String, String>();
        }
        ProcessDesc processDesc = this.bpmn2Service.getProcessDesc(processString);
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("process", processDesc);
        renderContext.put("outputs", processData);
        return this.render(processDesc.getName(), template, renderContext);
    }

    @Override
    public String getFormDisplayTask(long taskId) {
        String processDef;
        Task task = this.queryService.getTaskInstanceById(taskId);
        Object input = null;
        long inputContentId = task.getTaskData().getDocumentContentId();
        if (inputContentId != -1L) {
            Content content = this.contentService.getContentById(inputContentId);
            input = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        }
        if (input == null) {
            input = new HashMap();
        }
        Object output = null;
        long outputContentId = task.getTaskData().getOutputContentId();
        if (outputContentId != -1L) {
            Content content = this.contentService.getContentById(outputContentId);
            output = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        }
        if (output == null) {
            output = new HashMap();
        }
        String name = null;
        List names = task.getNames();
        for (I18NText text : names) {
            if (!"en-UK".equals(text.getLanguage())) continue;
            name = text.getText();
        }
        InputStream template = this.getClass().getResourceAsStream("/ftl/DefaultTask.ftl");
        String processId = task.getTaskData().getProcessId();
        Map<Object, Object> taskOutputMappings = null;
        if (processId != null && !processId.equals("") && (processDef = this.domainService.getAvailableProcesses().get(processId)) != null && !processDef.equals("")) {
            taskOutputMappings = this.bpmn2Service.getTaskOutputMappings(processDef, ((I18NText)task.getNames().iterator().next()).getText());
        }
        if (taskOutputMappings == null) {
            taskOutputMappings = new HashMap();
        }
        HashMap<String, String> finalOutput = new HashMap<String, String>();
        for (String key : taskOutputMappings.values()) {
            String value = (String)((Map)output).get(key);
            if (value == null) {
                value = "";
            }
            finalOutput.put(key, value);
        }
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("task", task);
        renderContext.put("inputs", input);
        renderContext.put("outputs", finalOutput);
        return this.render(name, template, renderContext);
    }

    public String render(String name, InputStream src, Map<String, Object> renderContext) {
        String str = null;
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateUpdateDelay(0);
            Template temp = new Template(name, (Reader)new InputStreamReader(src), cfg);
            StringWriter out = new StringWriter();
            temp.process(renderContext, (Writer)out);
            out.flush();
            str = out.getBuffer().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process form template", e);
        }
        return str;
    }

    @Override
    public FormRepresentation getAssociatedForm(String bpmn2, String taskName) {
        try {
            ProcessDesc desc = this.bpmn2Service.getProcessDesc(bpmn2);
            String processName = desc.getId();
            Object actualTask = null;
            List forms = this.formService.getForms();
            FormRepresentation retval = null;
            for (FormRepresentation form : forms) {
                boolean sameProcess;
                boolean sameTask = taskName == null && form.getTaskId() == null && form.getTaskId() != null && form.getTaskId().equals(taskName);
                boolean bl = sameProcess = form.getProcessName() != null && form.getProcessName().equals(processName);
                if (!sameTask || !sameProcess) continue;
                retval = form;
                break;
            }
            return retval;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get associated form for taskName " + taskName, e);
        }
    }

    @Override
    public FormRepresentation createFormFromTask(Map<String, String> inputs, Map<String, String> outputs, TaskDef task) {
        InputData data;
        LabelRepresentation labelName;
        String key;
        FormRepresentation form = new FormRepresentation();
        form.setInputs(this.toInputDataMap(inputs));
        form.setOutputs(this.toOutputDataMap(outputs));
        if (task.getName() != null) {
            HeaderRepresentation header = new HeaderRepresentation();
            header.setValue("Task: " + task.getName());
            form.addFormItem((FormItemRepresentation)header);
        }
        if (inputs != null && !inputs.isEmpty()) {
            TableRepresentation tableOfInputs = new TableRepresentation();
            tableOfInputs.setRows(Integer.valueOf(inputs.size()));
            tableOfInputs.setColumns(Integer.valueOf(2));
            tableOfInputs.setHeight("" + inputs.size() * 30 + "px");
            ArrayList<String> keys = new ArrayList<String>(inputs.keySet());
            for (int index = 0; index < inputs.size(); ++index) {
                key = (String)keys.get(index);
                labelName = new LabelRepresentation();
                labelName.setWidth("100px");
                tableOfInputs.setElement(index, 0, (FormItemRepresentation)labelName);
                LabelRepresentation labelValue = new LabelRepresentation();
                labelValue.setWidth("200px");
                data = new InputData();
                data.setName(key);
                data.setValue(inputs.get(key));
                data.setMimeType("multipart/form-data");
                data.setFormatter(new Formatter(){

                    public Object format(Object object) {
                        return object;
                    }

                    public Map<String, Object> getDataMap() {
                        return new HashMap<String, Object>();
                    }
                });
                labelValue.setInput(data);
                labelValue.setValue("{variable}");
                tableOfInputs.setElement(index, 1, (FormItemRepresentation)labelValue);
            }
            LabelRepresentation labelInputs = new LabelRepresentation();
            labelInputs.setValue("Inputs:");
            form.addFormItem((FormItemRepresentation)labelInputs);
            form.addFormItem((FormItemRepresentation)tableOfInputs);
        }
        if (outputs != null && !outputs.isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>(outputs.keySet());
            TableRepresentation tableOfOutputs = new TableRepresentation();
            tableOfOutputs.setRows(Integer.valueOf(outputs.size()));
            tableOfOutputs.setColumns(Integer.valueOf(2));
            tableOfOutputs.setHeight("" + outputs.size() * 30 + "px");
            for (int index = 0; index < outputs.size(); ++index) {
                key = (String)keys.get(index);
                labelName = new LabelRepresentation();
                labelName.setValue(key);
                labelName.setWidth("100px");
                tableOfOutputs.setElement(index, 0, (FormItemRepresentation)labelName);
                TextFieldRepresentation textField = new TextFieldRepresentation();
                textField.setWidth("200px");
                data = new OutputData();
                data.setName(key);
                data.setValue(outputs.get(key));
                data.setMimeType("multipart/form-data");
                data.setFormatter(new Formatter(){

                    public Object format(Object object) {
                        return object;
                    }

                    public Map<String, Object> getDataMap() {
                        return new HashMap<String, Object>();
                    }
                });
                textField.setOutput((OutputData)data);
                tableOfOutputs.setElement(index, 1, (FormItemRepresentation)textField);
            }
            LabelRepresentation labelOutputs = new LabelRepresentation();
            labelOutputs.setValue("Outputs:");
            form.addFormItem((FormItemRepresentation)labelOutputs);
            form.addFormItem((FormItemRepresentation)tableOfOutputs);
        }
        CompleteButtonRepresentation completeButton = new CompleteButtonRepresentation();
        completeButton.setText("Complete");
        form.addFormItem((FormItemRepresentation)completeButton);
        form.setAction("complete");
        form.setEnctype("multipart/form-data");
        form.setMethod("POST");
        form.setName(task.getName() + "AutoForm");
        form.setTaskId(task.getName());
        return form;
    }

    protected <T> Map<String, T> asMapOfNull(List<String> keys, Class<T> type) {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        if (keys != null) {
            for (String key : keys) {
                retval.put(key, null);
            }
        }
        return retval;
    }

    public List<String> get(Map<String, List<String>> map, String keyPart) {
        for (String key : map.keySet()) {
            if (!key.contains(keyPart)) continue;
            return map.get(key);
        }
        return null;
    }

    protected Map<String, InputData> toInputDataMap(Map<String, String> inputs) {
        HashMap<String, InputData> retval = new HashMap<String, InputData>();
        if (inputs != null) {
            for (String key : inputs.keySet()) {
                InputData in = new InputData();
                in.setName(key);
                retval.put(key, in);
            }
        }
        return retval;
    }

    protected Map<String, OutputData> toOutputDataMap(Map<String, String> outputs) {
        HashMap<String, OutputData> retval = new HashMap<String, OutputData>();
        if (outputs != null) {
            for (String key : outputs.keySet()) {
                OutputData out = new OutputData();
                out.setName(key);
                retval.put(key, out);
            }
        }
        return retval;
    }
}

