/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
public class NodeInstanceDesc
implements Serializable {
    @Id
    @GeneratedValue
    private long pk;
    private long id;
    private long nodeId;
    private String name;
    private String domainName;
    private int sessionId;
    private long processInstanceId;
    private String type;
    private boolean completed;
    @Temporal(value=TemporalType.DATE)
    private Date dataTimeStamp;

    public NodeInstanceDesc() {
        this.dataTimeStamp = new Date();
    }

    public NodeInstanceDesc(long id, long nodeId, String name, String type, String domainName, int sessionId, long processInstanceId) {
        this(id, nodeId, name, type, domainName, sessionId, processInstanceId, false);
    }

    public NodeInstanceDesc(long id, long nodeId, String name, String type, String domainName, int sessionId, long processInstanceId, boolean completed) {
        this.id = id;
        this.nodeId = nodeId;
        this.name = name;
        this.type = type;
        this.sessionId = sessionId;
        this.processInstanceId = processInstanceId;
        this.domainName = domainName;
        this.completed = completed;
        this.dataTimeStamp = new Date();
    }

    public long getId() {
        return this.id;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public String getName() {
        return this.name;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Date getDataTimeStamp() {
        return this.dataTimeStamp;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "NodeInstanceDesc[" + this.dataTimeStamp.toString() + "]{" + "pk=" + this.pk + ", id=" + this.id + ", nodeId=" + this.nodeId + ", name=" + this.name + ", domainName=" + this.domainName + ", sessionId=" + this.sessionId + ", processInstanceId=" + this.processInstanceId + ", type=" + this.type + '}';
    }
}

