/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
public class ProcessInstanceDesc
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long pk;
    private long id;
    private String processId;
    private String processName;
    private String processVersion;
    private int state;
    private String[] eventTypes;
    private String processDefId;
    private int sessionId;
    private String domainName;
    private String initiator;
    @Temporal(value=TemporalType.DATE)
    private Date dataTimeStamp;

    public ProcessInstanceDesc() {
        this.dataTimeStamp = new Date();
    }

    public ProcessInstanceDesc(long id, String processId, String processName, String processVersion, int state, String[] eventTypes, String processDefId, String domainName, int sessionId, String initiator) {
        this.id = id;
        this.processId = processId;
        this.processName = processName;
        this.processVersion = processVersion == null ? "" : processVersion;
        this.state = state;
        this.eventTypes = eventTypes;
        this.processDefId = processDefId;
        this.sessionId = sessionId;
        this.domainName = domainName;
        this.dataTimeStamp = new Date();
        this.initiator = initiator;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public long getId() {
        return this.id;
    }

    public String getProcessName() {
        return this.processName;
    }

    public int getState() {
        return this.state;
    }

    public String[] getEventTypes() {
        return this.eventTypes;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public Date getDataTimeStamp() {
        return this.dataTimeStamp;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String toString() {
        return "ProcessInstanceDesc[" + this.dataTimeStamp.toString() + "]{" + "pk=" + this.pk + ", id=" + this.id + ", processId=" + this.processId + ", processName=" + this.processName + ", state=" + this.state + ", eventTypes=" + this.eventTypes + ", processDefId=" + this.processDefId + ", sessionId=" + this.sessionId + ", domainName=" + this.domainName + '}';
    }

    public String getProcessVersion() {
        return this.processVersion;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }
}

