/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl.vfs;

import java.net.URI;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.droolsjbpm.services.api.FileException;
import org.droolsjbpm.services.api.FileService;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.FileSystemNotFoundException;
import org.kie.commons.java.nio.file.FileSystems;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.Paths;
import org.kie.commons.validation.PortablePreconditions;

@ApplicationScoped
public class VFSFileServiceImpl
implements FileService {
    private static final String REPO_PLAYGROUND = "git://jbpm-playground";
    private static final String ORIGIN_URL = "https://github.com/guvnorngtestuser1/jbpm-console-ng-playground.git";

    @Override
    @PostConstruct
    public void init() {
        try {
            FileSystems.getFileSystem((URI)URI.create(REPO_PLAYGROUND));
            this.fetchChanges();
        }
        catch (FileSystemNotFoundException e) {
            String userName = "guvnorngtestuser1";
            String password = "test1234";
            URI fsURI = URI.create(REPO_PLAYGROUND);
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("username", "guvnorngtestuser1");
            env.put("password", "test1234");
            env.put("origin", ORIGIN_URL);
            FileSystems.newFileSystem((URI)fsURI, env);
        }
        catch (Exception e) {
            System.out.println(">>>>>>>>>>>>>>>>>>> E " + e.getMessage());
        }
    }

    @Override
    public void fetchChanges() {
        FileSystems.getFileSystem((URI)URI.create("git://jbpm-playground?fetch"));
    }

    @Override
    public byte[] loadFile(Path file) throws FileException {
        PortablePreconditions.checkNotNull((String)"file", (Object)file);
        try {
            return Files.readAllBytes((Path)file);
        }
        catch (IOException ex) {
            throw new FileException(ex.getMessage(), ex);
        }
    }

    @Override
    public Iterable<Path> loadFilesByType(String path, final String fileType) {
        return Files.newDirectoryStream((Path)Paths.get((String)("git://jbpm-playground/" + path), (String[])new String[0]), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return entry.getFileName().toString().endsWith(fileType);
            }
        });
    }
}

