/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.droolsjbpm.services.api.Domain;
import org.droolsjbpm.services.api.SessionManager;
import org.droolsjbpm.services.api.bpmn2.BPMN2DataService;
import org.droolsjbpm.services.impl.event.listeners.CDIKbaseEventListener;
import org.droolsjbpm.services.impl.event.listeners.CDIProcessEventListener;
import org.droolsjbpm.services.impl.event.listeners.CDIRuleAwareProcessEventListener;
import org.droolsjbpm.services.impl.helpers.StatefulKnowledgeSessionDelegate;
import org.jbpm.task.api.TaskServiceEntryPoint;
import org.jbpm.task.wih.CDIHTWorkItemHandler;
import org.kie.KieBaseConfiguration;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderError;
import org.kie.builder.KnowledgeBuilderErrors;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.Path;
import org.kie.conf.EventProcessingOption;
import org.kie.conf.KieBaseOption;
import org.kie.event.KnowledgeRuntimeEventManager;
import org.kie.event.kiebase.KieBaseEventListener;
import org.kie.event.process.ProcessEventListener;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;
import org.kie.logger.KnowledgeRuntimeLoggerFactory;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.WorkItemHandler;

public class CDISessionManager
implements SessionManager {
    @Inject
    private TaskServiceEntryPoint taskService;
    @Inject
    private CDIHTWorkItemHandler handler;
    @Inject
    private CDIProcessEventListener processListener;
    @Inject
    private CDIRuleAwareProcessEventListener processFactsListener;
    @Inject
    private CDIKbaseEventListener kbaseEventListener;
    @Inject
    private BPMN2DataService bpmn2Service;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    private Domain domain;
    private Map<String, StatefulKnowledgeSession> ksessions = new HashMap<String, StatefulKnowledgeSession>();
    private Map<String, Integer> ksessionIds = new HashMap<String, Integer>();
    private Map<String, Long> processInstanceIdKsession = new HashMap<String, Long>();
    private Map<String, List<String>> processDefinitionNamesBySession = new HashMap<String, List<String>>();
    private Map<String, Map<String, WorkItemHandler>> ksessionHandlers = new HashMap<String, Map<String, WorkItemHandler>>();

    public CDISessionManager() {
    }

    public CDISessionManager(Domain domain) {
        this.domain = domain;
    }

    @Override
    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public void addKsessionHandler(String ksessionName, String handlerName, WorkItemHandler handler) {
        if (this.ksessionHandlers.get(ksessionName) == null) {
            this.ksessionHandlers.put(ksessionName, new HashMap());
        }
        this.ksessionHandlers.get(ksessionName).put(handlerName, handler);
    }

    @Override
    public void registerHandlersForSession(String ksessionName) {
        Map<String, WorkItemHandler> handlers = this.ksessionHandlers.get(ksessionName);
        if (handlers != null) {
            for (String key : handlers.keySet()) {
                this.ksessions.get(ksessionName).getWorkItemManager().registerWorkItemHandler(key, handlers.get(key));
            }
        }
    }

    @Override
    public void registerRuleListenerForSession(String ksessionName) {
        this.ksessions.get(ksessionName).addEventListener((ProcessEventListener)this.processFactsListener);
    }

    @Override
    public void buildSessions(boolean streamMode) {
        this.processListener.setDomainName(this.domain.getName());
        this.kbaseEventListener.setDomainName(this.domain.getName());
        this.processListener.setSessionManager(this);
        Map<String, List<Path>> ksessionProcessDefinitions = this.domain.getProcessDefinitionFromKsession();
        Map<String, List<Path>> ksessionRulesDefinitions = this.domain.getRulesDefinitionFromKsession();
        for (String session : ksessionProcessDefinitions.keySet()) {
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            if (ksessionProcessDefinitions.get(session) != null) {
                for (Path path : ksessionProcessDefinitions.get(session)) {
                    String processString = new String(this.ioService.readAllBytes(path));
                    this.addProcessDefinitionToSession(session, this.bpmn2Service.findProcessId(processString));
                    System.out.println(">>>>>>>>>> Adding Process to KBase - > " + path.toString());
                    kbuilder.add(ResourceFactory.newByteArrayResource((byte[])processString.getBytes()), ResourceType.BPMN2);
                }
            }
            if (ksessionRulesDefinitions.get(session) != null) {
                for (Path path : ksessionRulesDefinitions.get(session)) {
                    String rules = new String(this.ioService.readAllBytes(path));
                    System.out.println(">>>>>>>>>> Adding Rules to KBase - > " + path.toString());
                    kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rules.getBytes()), ResourceType.DRL);
                }
            }
            if (!kbuilder.getErrors().isEmpty()) {
                KnowledgeBuilderErrors errors = kbuilder.getErrors();
                Iterator iterator = errors.iterator();
                while (iterator.hasNext()) {
                    System.out.println("Error: " + ((KnowledgeBuilderError)iterator.next()).getMessage());
                }
                continue;
            }
            KnowledgeBase kbase = null;
            if (streamMode) {
                KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
                config.setOption((KieBaseOption)EventProcessingOption.STREAM);
                kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)config);
            } else {
                kbase = KnowledgeBaseFactory.newKnowledgeBase();
            }
            kbase.addEventListener((KieBaseEventListener)this.kbaseEventListener);
            kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
            StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
            ksession.addEventListener((ProcessEventListener)this.processListener);
            KnowledgeRuntimeLoggerFactory.newConsoleLogger((KnowledgeRuntimeEventManager)ksession);
            this.handler.setSession((KnowledgeRuntime)ksession);
            this.handler.init();
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)this.handler);
            StatefulKnowledgeSessionDelegate statefulKnowledgeSessionDelegate = new StatefulKnowledgeSessionDelegate(session, ksession, this);
            this.ksessions.put(session, statefulKnowledgeSessionDelegate);
            this.ksessionIds.put(session, ksession.getId());
        }
    }

    @Override
    public Map<String, StatefulKnowledgeSession> getKsessions() {
        return this.ksessions;
    }

    @Override
    public void setKsessions(Map<String, StatefulKnowledgeSession> ksessions) {
        this.ksessions = ksessions;
    }

    @Override
    public void addKsession(String name, StatefulKnowledgeSession ksession) {
        this.ksessions.put(name, ksession);
    }

    @Override
    public Map<String, Long> getProcessInstanceIdKsession() {
        return this.processInstanceIdKsession;
    }

    @Override
    public void setProcessInstanceIdKsession(Map<String, Long> processInstanceIdKsession) {
        this.processInstanceIdKsession = processInstanceIdKsession;
    }

    @Override
    public void addProcessInstanceIdKsession(String ksessionName, Long processInstanceId) {
        this.processInstanceIdKsession.put(ksessionName, processInstanceId);
    }

    @Override
    public StatefulKnowledgeSession getKsessionByName(String ksessionName) {
        return this.ksessions.get(ksessionName);
    }

    @Override
    public String getSessionForProcessInstanceId(Long processInstanceId) {
        for (String sessionName : this.processInstanceIdKsession.keySet()) {
            if (this.processInstanceIdKsession.get(sessionName) != processInstanceId) continue;
            return sessionName;
        }
        return null;
    }

    @Override
    public int getSessionIdByName(String ksessionName) {
        return this.ksessionIds.get(ksessionName);
    }

    @Override
    public Collection<String> getAllSessionsNames() {
        return this.ksessions.keySet();
    }

    public Map<String, List<String>> getProcessDefinitionNamesBySession() {
        return this.processDefinitionNamesBySession;
    }

    @Override
    public void addProcessDefinitionToSession(String sessionName, String processId) {
        if (this.processDefinitionNamesBySession.get(sessionName) == null) {
            this.processDefinitionNamesBySession.put(sessionName, new ArrayList());
        }
        this.processDefinitionNamesBySession.get(sessionName).add(processId);
    }

    @Override
    public void removeProcessDefinitionFromSession(String sessionName, String processId) {
        if (this.processDefinitionNamesBySession.get(sessionName) != null) {
            this.processDefinitionNamesBySession.get(sessionName).remove(processId);
        }
    }

    @Override
    public Collection<String> getProcessesInSession(String sessionName) {
        return this.processDefinitionNamesBySession.get(sessionName);
    }

    @Override
    public String getProcessInSessionByName(String processDefId) {
        for (String sessionName : this.processDefinitionNamesBySession.keySet()) {
            for (String processDef : this.processDefinitionNamesBySession.get(sessionName)) {
                if (!processDef.equals(processDefId)) continue;
                return sessionName;
            }
        }
        return "";
    }
}

