/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.droolsjbpm.services.api.KnowledgeDataService;
import org.droolsjbpm.services.api.SessionLocator;
import org.droolsjbpm.services.impl.model.NodeInstanceDesc;
import org.droolsjbpm.services.impl.model.ProcessDesc;
import org.droolsjbpm.services.impl.model.ProcessInstanceDesc;
import org.droolsjbpm.services.impl.model.VariableStateDesc;

@ApplicationScoped
public class KnowledgeDataServiceImpl
implements KnowledgeDataService {
    Map<String, SessionLocator> ksessionLocators = new HashMap<String, SessionLocator>();
    @Inject
    private EntityManager em;

    @PostConstruct
    public void init() {
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstances() {
        List processInstances = this.em.createQuery("select pi FROM ProcessInstanceDesc pi where pi.pk = (select max(pid.pk) FROM ProcessInstanceDesc pid WHERE pid.id = pi.id ) ").getResultList();
        return processInstances;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstances(List<Integer> states, String initiator) {
        List processInstances = null;
        Query query = null;
        if (initiator == null) {
            query = this.em.createQuery("select pi FROM ProcessInstanceDesc pi where pi.pk = (select max(pid.pk) FROM ProcessInstanceDesc pid WHERE pid.id = pi.id ) and pi.state in (:states)");
            query = query.setParameter("states", states);
        } else {
            query = this.em.createQuery("select pi FROM ProcessInstanceDesc pi where pi.pk = (select max(pid.pk) FROM ProcessInstanceDesc pid WHERE pid.id = pi.id and pi.initiator =:initiator) and pi.state in (:states)");
            query = query.setParameter("states", states);
            query = query.setParameter("initiator", (Object)initiator);
        }
        processInstances = query.getResultList();
        return processInstances;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesBySessionId(String sessionId) {
        List processInstances = this.em.createQuery("select pi FROM ProcessInstanceDesc pi where pi.sessionId=:sessionId, pi.pk = (select max(pid.pk) FROM ProcessInstanceDesc pid WHERE pid.id = pi.id )").setParameter("sessionId", (Object)sessionId).getResultList();
        return processInstances;
    }

    @Override
    public Collection<ProcessDesc> getProcessesByDomainName(String domainName) {
        List processes = this.em.createQuery("select pd from ProcessDesc pd where pd.domainName=:domainName GROUP BY pd.id ORDER BY pd.dataTimeStamp DESC").setParameter("domainName", (Object)domainName).getResultList();
        return processes;
    }

    @Override
    public Collection<ProcessDesc> getProcesses() {
        List processes = this.em.createQuery("select pd from ProcessDesc pd where pd.pki = (select max(pdd.pki) FROM ProcessDesc pdd WHERE pdd.id = pd.id ) GROUP BY pd.id ORDER BY pd.dataTimeStamp DESC)").getResultList();
        return processes;
    }

    @Override
    public ProcessInstanceDesc getProcessInstanceById(int sessionId, long processId) {
        List processInstances = this.em.createQuery("select pid from ProcessInstanceDesc pid where pid.id=:processId AND pid.sessionId=:sessionId ORDER BY pid.pk DESC").setParameter("processId", (Object)processId).setParameter("sessionId", (Object)sessionId).setMaxResults(1).getResultList();
        return (ProcessInstanceDesc)processInstances.get(0);
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceHistory(int sessionId, long processId) {
        return this.getProcessInstanceHistory(sessionId, processId, false);
    }

    @Override
    public Collection<VariableStateDesc> getVariablesCurrentState(long processInstanceId) {
        List variablesState = this.em.createQuery("select vs FROM VariableStateDesc vs where vs.processInstanceId =:processInstanceId AND vs.pk in (select max(vss.pk) FROM VariableStateDesc vss WHERE vss.processInstanceId =:processInstanceId group by vss.variableId ) order by vs.pk").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        return variablesState;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceHistory(int sessionId, long processId, boolean completed) {
        List nodeInstances = this.em.createQuery("select nid from NodeInstanceDesc nid where nid.processInstanceId=:processId AND nid.sessionId=:sessionId AND nid.completed =:completed ORDER BY nid.dataTimeStamp DESC").setParameter("processId", (Object)processId).setParameter("sessionId", (Object)sessionId).setParameter("completed", (Object)completed).getResultList();
        return nodeInstances;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceFullHistory(int sessionId, long processId) {
        List nodeInstances = this.em.createQuery("select nid from NodeInstanceDesc nid where nid.processInstanceId=:processId AND nid.sessionId=:sessionId ORDER BY nid.dataTimeStamp DESC").setParameter("processId", (Object)processId).setParameter("sessionId", (Object)sessionId).getResultList();
        return nodeInstances;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceActiveNodes(int sessionId, long processId) {
        List completedNodeInstances = this.em.createQuery("select nid from NodeInstanceDesc nid where nid.processInstanceId=:processId AND nid.sessionId=:sessionId AND nid.completed =:completed ORDER BY nid.dataTimeStamp DESC").setParameter("processId", (Object)processId).setParameter("sessionId", (Object)sessionId).setParameter("completed", (Object)true).getResultList();
        List activeNodeInstances = this.em.createQuery("select nid from NodeInstanceDesc nid where nid.processInstanceId=:processId AND nid.sessionId=:sessionId AND nid.completed =:completed ORDER BY nid.dataTimeStamp DESC").setParameter("processId", (Object)processId).setParameter("sessionId", (Object)sessionId).setParameter("completed", (Object)false).getResultList();
        ArrayList<NodeInstanceDesc> uncompletedNodeInstances = new ArrayList<NodeInstanceDesc>(activeNodeInstances.size() - completedNodeInstances.size());
        for (NodeInstanceDesc nid : activeNodeInstances) {
            boolean completed = false;
            for (NodeInstanceDesc cnid : completedNodeInstances) {
                if (nid.getNodeId() != cnid.getNodeId()) continue;
                completed = true;
            }
            if (completed) continue;
            uncompletedNodeInstances.add(nid);
        }
        return uncompletedNodeInstances;
    }

    @Override
    public Collection<VariableStateDesc> getVariableHistory(long processInstanceId, String variableId) {
        List variablesState = this.em.createQuery("select vs FROM VariableStateDesc vs where vs.processInstanceId =:processInstanceId AND vs.variableId =:variableId order by vs.pk DESC").setParameter("processInstanceId", (Object)processInstanceId).setParameter("variableId", (Object)variableId).getResultList();
        return variablesState;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessId(List<Integer> states, String processId, String initiator) {
        List processInstances = null;
        Query query = null;
        if (initiator == null) {
            query = this.em.createQuery("select pi FROM ProcessInstanceDesc pi where pi.pk = (select max(pid.pk) FROM ProcessInstanceDesc pid WHERE pid.id = pi.id ) and pi.state in (:states) and pi.processId =:processId");
            query = query.setParameter("states", states);
            query = query.setParameter("processId", (Object)processId);
        } else {
            query = this.em.createQuery("select pi FROM ProcessInstanceDesc pi where pi.pk = (select max(pid.pk) FROM ProcessInstanceDesc pid WHERE pid.id = pi.id  and pi.initiator =:initiator) and pi.state in (:states) and pi.processId =:processId");
            query = query.setParameter("states", states);
            query = query.setParameter("initiator", (Object)initiator);
            query = query.setParameter("processId", (Object)processId);
        }
        processInstances = query.getResultList();
        return processInstances;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessName(List<Integer> states, String processName, String initiator) {
        List processInstances = null;
        Query query = null;
        if (initiator == null) {
            query = this.em.createQuery("select pi FROM ProcessInstanceDesc pi where pi.pk = (select max(pid.pk) FROM ProcessInstanceDesc pid WHERE pid.id = pi.id ) and pi.state in (:states) and pi.processName =:processName");
            query = query.setParameter("states", states);
            query = query.setParameter("processName", (Object)processName);
        } else {
            query = this.em.createQuery("select pi FROM ProcessInstanceDesc pi where pi.pk = (select max(pid.pk) FROM ProcessInstanceDesc pid WHERE pid.id = pi.id  and pi.initiator =:initiator) and pi.state in (:states) and pi.processName =:processName");
            query = query.setParameter("states", states);
            query = query.setParameter("initiator", (Object)initiator);
            query = query.setParameter("processName", (Object)processName);
        }
        processInstances = query.getResultList();
        return processInstances;
    }
}

