/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.droolsjbpm.services.api.Domain;
import org.kie.commons.java.nio.file.Path;

public class SimpleDomainImpl
implements Domain {
    private Long id;
    private String name;
    private Map<String, String> assetsDefs = new HashMap<String, String>();
    private Map<String, List<Path>> ksessionProcessDefinitions = new HashMap<String, List<Path>>();
    private Map<String, List<Path>> ksessionRulesDefinitions = new HashMap<String, List<Path>>();
    private Map<String, Map<String, String>> processes = new HashMap<String, Map<String, String>>();
    private Long parentId;

    public SimpleDomainImpl() {
    }

    public SimpleDomainImpl(String name) {
        this.name = name;
    }

    public SimpleDomainImpl(String name, long parentId) {
        this.name = name;
        this.parentId = parentId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getAssetsDefs() {
        return this.assetsDefs;
    }

    @Override
    public void setAssetsDefs(Map<String, String> assetsDefs) {
        this.assetsDefs = assetsDefs;
    }

    @Override
    public void addAsset(String name, String path) {
        this.assetsDefs.put(name, path);
    }

    @Override
    public Map<String, List<Path>> getProcessDefinitionFromKsession() {
        return this.ksessionProcessDefinitions;
    }

    @Override
    public void setProcessDefinitionToKsessions(Map<String, List<Path>> ksessionProcessDefinitions) {
        this.ksessionProcessDefinitions = ksessionProcessDefinitions;
    }

    @Override
    public void addProcessDefinitionToKsession(String ksession, Path path) {
        if (this.ksessionProcessDefinitions.get(ksession) == null) {
            this.ksessionProcessDefinitions.put(ksession, new ArrayList());
        }
        this.ksessionProcessDefinitions.get(ksession).add(path);
    }

    @Override
    public Map<String, List<Path>> getRulesDefinitionFromKsession() {
        return this.ksessionRulesDefinitions;
    }

    @Override
    public void setRulesDefinitionToKsessions(Map<String, List<Path>> ksessionRulesDefinitions) {
        this.ksessionRulesDefinitions = ksessionRulesDefinitions;
    }

    @Override
    public void addRulesDefinitionToKsession(String ksession, Path path) {
        if (this.ksessionRulesDefinitions.get(ksession) == null) {
            this.ksessionRulesDefinitions.put(ksession, new ArrayList());
        }
        this.ksessionRulesDefinitions.get(ksession).add(path);
    }

    @Override
    public void addProcessBPMN2ContentToKsession(String sessionName, String processId, String bpmn2Content) {
        if (this.processes.get(sessionName) == null) {
            this.processes.put(sessionName, new HashMap());
        }
        this.processes.get(sessionName).put(processId, bpmn2Content);
    }

    @Override
    public Map<String, String> getAllProcesses() {
        HashMap<String, String> allProcesses = new HashMap<String, String>();
        for (String sessionName : this.processes.keySet()) {
            allProcesses.putAll(this.processes.get(sessionName));
        }
        return allProcesses;
    }

    @Override
    public Map<String, String> getProcessesBySession(String ksessionName) {
        return this.processes.get(ksessionName);
    }

    @Override
    public String getProcessDefinitionBPMN2(String ksessionName, String processId) {
        return this.processes.get(ksessionName).get(processId);
    }
}

