/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl.event.listeners;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.droolsjbpm.services.api.IdentityProvider;
import org.droolsjbpm.services.api.SessionManager;
import org.droolsjbpm.services.impl.helpers.NodeInstanceDescFactory;
import org.droolsjbpm.services.impl.helpers.ProcessInstanceDescFactory;
import org.droolsjbpm.services.impl.model.VariableStateDesc;
import org.jboss.seam.transaction.Transactional;
import org.kie.event.process.ProcessCompletedEvent;
import org.kie.event.process.ProcessEventListener;
import org.kie.event.process.ProcessNodeLeftEvent;
import org.kie.event.process.ProcessNodeTriggeredEvent;
import org.kie.event.process.ProcessStartedEvent;
import org.kie.event.process.ProcessVariableChangedEvent;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.NodeInstance;
import org.kie.runtime.process.ProcessInstance;

@ApplicationScoped
@Transactional
public class CDIProcessEventListener
implements ProcessEventListener {
    @Inject
    private EntityManager em;
    @Inject
    private IdentityProvider identity;
    private String domainName;
    private SessionManager sessionManager;

    public void beforeProcessStarted(ProcessStartedEvent pse) {
        ProcessInstance processInstance = pse.getProcessInstance();
        int sessionId = ((StatefulKnowledgeSession)pse.getKieRuntime()).getId();
        this.em.persist((Object)ProcessInstanceDescFactory.newProcessInstanceDesc(this.domainName, sessionId, processInstance, this.identity.getName()));
    }

    public void afterProcessStarted(ProcessStartedEvent pse) {
        int currentState = pse.getProcessInstance().getState();
        if (currentState == 1) {
            ProcessInstance processInstance = pse.getProcessInstance();
            int sessionId = ((StatefulKnowledgeSession)pse.getKieRuntime()).getId();
            this.em.persist((Object)ProcessInstanceDescFactory.newProcessInstanceDesc(this.domainName, sessionId, processInstance, this.identity.getName()));
        }
    }

    public void beforeProcessCompleted(ProcessCompletedEvent pce) {
        ProcessInstance processInstance = pce.getProcessInstance();
        int sessionId = ((StatefulKnowledgeSession)pce.getKieRuntime()).getId();
        this.em.persist((Object)ProcessInstanceDescFactory.newProcessInstanceDesc(this.domainName, sessionId, processInstance, this.identity.getName()));
        if (this.sessionManager != null) {
            this.sessionManager.getProcessInstanceIdKsession().remove(processInstance.getId());
        }
    }

    public void afterProcessCompleted(ProcessCompletedEvent pce) {
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent pnte) {
        int sessionId = ((StatefulKnowledgeSession)pnte.getKieRuntime()).getId();
        long processInstanceId = pnte.getProcessInstance().getId();
        NodeInstance nodeInstance = pnte.getNodeInstance();
        this.em.persist((Object)NodeInstanceDescFactory.newNodeInstanceDesc(this.domainName, sessionId, processInstanceId, nodeInstance, false));
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent pnte) {
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent pnle) {
    }

    public void afterNodeLeft(ProcessNodeLeftEvent pnle) {
        int sessionId = ((StatefulKnowledgeSession)pnle.getKieRuntime()).getId();
        long processInstanceId = pnle.getProcessInstance().getId();
        NodeInstance nodeInstance = pnle.getNodeInstance();
        this.em.persist((Object)NodeInstanceDescFactory.newNodeInstanceDesc(this.domainName, sessionId, processInstanceId, nodeInstance, true));
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent pvce) {
        int sessionId = ((StatefulKnowledgeSession)pvce.getKieRuntime()).getId();
        long processInstanceId = pvce.getProcessInstance().getId();
        String variableId = pvce.getVariableId();
        String variableInstanceId = pvce.getVariableInstanceId();
        String oldValue = pvce.getOldValue() != null ? pvce.getOldValue().toString() : "";
        String newValue = pvce.getNewValue() != null ? pvce.getNewValue().toString() : "";
        this.em.persist((Object)new VariableStateDesc(variableId, variableInstanceId, oldValue, newValue, this.domainName, sessionId, processInstanceId));
    }

    public void afterVariableChanged(ProcessVariableChangedEvent pvce) {
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }
}

