/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl.event.listeners;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.seam.transaction.Transactional;
import org.kie.event.process.ProcessCompletedEvent;
import org.kie.event.process.ProcessEventListener;
import org.kie.event.process.ProcessNodeLeftEvent;
import org.kie.event.process.ProcessNodeTriggeredEvent;
import org.kie.event.process.ProcessStartedEvent;
import org.kie.event.process.ProcessVariableChangedEvent;
import org.kie.runtime.KieRuntime;
import org.kie.runtime.ObjectFilter;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.WorkflowProcessInstance;
import org.kie.runtime.rule.FactHandle;

@ApplicationScoped
@Transactional
public class CDIRuleAwareProcessEventListener
implements ProcessEventListener {
    private ConcurrentHashMap<Long, FactHandle> store = new ConcurrentHashMap();

    public void beforeProcessStarted(ProcessStartedEvent event) {
        FactHandle handle = event.getKieRuntime().insert((Object)event.getProcessInstance());
        this.store.put(event.getProcessInstance().getId(), handle);
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
        event.getKieRuntime().getEntryPoint("process-events").insert((Object)event);
        ((StatefulKnowledgeSession)event.getKieRuntime()).fireAllRules();
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
        event.getKieRuntime().getEntryPoint("process-events").insert((Object)event);
        ((StatefulKnowledgeSession)event.getKieRuntime()).fireAllRules();
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        FactHandle handle = this.getProcessInstanceFactHandle(event.getProcessInstance().getId(), event.getKieRuntime());
        if (handle != null) {
            event.getKieRuntime().retract(handle);
        }
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        event.getKieRuntime().getEntryPoint("process-events").insert((Object)event);
        ((StatefulKnowledgeSession)event.getKieRuntime()).fireAllRules();
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        event.getKieRuntime().getEntryPoint("process-events").insert((Object)event);
        ((StatefulKnowledgeSession)event.getKieRuntime()).fireAllRules();
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        FactHandle handle = this.getProcessInstanceFactHandle(event.getProcessInstance().getId(), event.getKieRuntime());
        if (handle != null) {
            event.getKieRuntime().update(handle, (Object)event.getProcessInstance());
        } else {
            handle = event.getKieRuntime().insert((Object)event.getProcessInstance());
            this.store.put(event.getProcessInstance().getId(), handle);
        }
    }

    protected FactHandle getProcessInstanceFactHandle(final Long processInstanceId, KieRuntime kruntime) {
        if (this.store.containsKey(processInstanceId)) {
            return this.store.get(processInstanceId);
        }
        Collection factHandles = kruntime.getFactHandles(new ObjectFilter(){

            public boolean accept(Object object) {
                return WorkflowProcessInstance.class.isAssignableFrom(object.getClass()) && ((WorkflowProcessInstance)object).getId() == processInstanceId.longValue();
            }
        });
        if (factHandles != null && factHandles.size() > 0) {
            FactHandle handle = (FactHandle)factHandles.iterator().next();
            this.store.put(processInstanceId, handle);
            return handle;
        }
        return null;
    }
}

