/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl.form;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.droolsjbpm.services.api.FormProviderService;
import org.droolsjbpm.services.api.KnowledgeDomainService;
import org.droolsjbpm.services.api.bpmn2.BPMN2DataService;
import org.droolsjbpm.services.impl.model.ProcessDesc;
import org.jbpm.form.builder.services.model.InputData;
import org.jbpm.form.builder.services.model.OutputData;
import org.jbpm.shared.services.api.FileException;
import org.jbpm.shared.services.api.FileService;
import org.jbpm.task.Content;
import org.jbpm.task.I18NText;
import org.jbpm.task.Task;
import org.jbpm.task.api.TaskContentService;
import org.jbpm.task.api.TaskInstanceService;
import org.jbpm.task.api.TaskQueryService;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.kie.commons.java.nio.file.Path;

@ApplicationScoped
public class FormProviderServiceImpl
implements FormProviderService {
    @Inject
    private TaskQueryService queryService;
    @Inject
    private TaskContentService contentService;
    @Inject
    private TaskInstanceService instanceService;
    @Inject
    private BPMN2DataService bpmn2Service;
    @Inject
    private KnowledgeDomainService domainService;
    @Inject
    private FileService fileService;
    private Map<String, List<String>> effectsForItem = new HashMap<String, List<String>>();
    private Map<String, List<String>> actionsForItem = new HashMap<String, List<String>>();

    public void putEffectsForItem(String className, List<String> effectClassNames) {
        this.effectsForItem.put(className, effectClassNames);
    }

    public void putActionsForItem(String className, List<String> actionClassNames) {
        this.actionsForItem.put(className, actionClassNames);
    }

    @Override
    public String getFormDisplayProcess(String processId) {
        Iterable availableForms = null;
        try {
            availableForms = this.fileService.loadFilesByType("forms/", "ftl");
        }
        catch (FileException ex) {
            Logger.getLogger(FormProviderServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        Path selectedForm = null;
        for (Path p : availableForms) {
            if (!p.getFileName().toString().contains(processId)) continue;
            selectedForm = p;
        }
        ByteArrayInputStream template = null;
        try {
            template = selectedForm == null ? new ByteArrayInputStream(this.fileService.loadFile("forms/DefaultProcess.ftl")) : new ByteArrayInputStream(this.fileService.loadFile(selectedForm));
        }
        catch (FileException ex) {
            Logger.getLogger(FormProviderServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        String processString = this.domainService.getAvailableProcesses().get(processId);
        Map<String, String> processData = this.bpmn2Service.getProcessData(processId);
        if (processData == null) {
            processData = new HashMap<String, String>();
        }
        ProcessDesc processDesc = this.bpmn2Service.getProcessDesc(processId);
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("process", processDesc);
        renderContext.put("outputs", processData);
        return this.render(processDesc.getName(), template, renderContext);
    }

    @Override
    public String getFormDisplayTask(long taskId) {
        Task task = this.queryService.getTaskInstanceById(taskId);
        Object input = null;
        long inputContentId = task.getTaskData().getDocumentContentId();
        if (inputContentId != -1L) {
            Content content = this.contentService.getContentById(inputContentId);
            input = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        }
        if (input == null) {
            input = new HashMap();
        }
        Object output = null;
        long outputContentId = task.getTaskData().getOutputContentId();
        if (outputContentId != -1L) {
            Content content = this.contentService.getContentById(outputContentId);
            output = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        }
        if (output == null) {
            output = new HashMap();
        }
        String name = null;
        List names = task.getNames();
        for (I18NText text : names) {
            if (!"en-UK".equals(text.getLanguage())) continue;
            name = text.getText();
        }
        Iterable availableForms = null;
        try {
            availableForms = this.fileService.loadFilesByType("forms/", "ftl");
        }
        catch (FileException ex) {
            Logger.getLogger(FormProviderServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        Path selectedForm = null;
        for (Path p : availableForms) {
            if (!p.getFileName().toString().contains(((I18NText)task.getNames().get(0)).getText())) continue;
            selectedForm = p;
        }
        ByteArrayInputStream template = null;
        try {
            template = selectedForm == null ? new ByteArrayInputStream(this.fileService.loadFile("forms/DefaultTask.ftl")) : new ByteArrayInputStream(this.fileService.loadFile(selectedForm));
        }
        catch (FileException ex) {
            Logger.getLogger(FormProviderServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        String processId = task.getTaskData().getProcessId();
        Map<Object, Object> taskOutputMappings = null;
        if (processId != null && !processId.equals("")) {
            taskOutputMappings = this.bpmn2Service.getTaskOutputMappings(processId, ((I18NText)task.getNames().iterator().next()).getText());
        }
        if (taskOutputMappings == null) {
            taskOutputMappings = new HashMap();
        }
        HashMap<String, String> finalOutput = new HashMap<String, String>();
        for (String key : taskOutputMappings.values()) {
            String value = (String)((Map)output).get(key);
            if (value == null) {
                value = "";
            }
            finalOutput.put(key, value);
        }
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("task", task);
        renderContext.put("inputs", input);
        renderContext.put("outputs", finalOutput);
        return this.render(name, template, renderContext);
    }

    public String render(String name, InputStream src, Map<String, Object> renderContext) {
        String str = null;
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateUpdateDelay(0);
            Template temp = new Template(name, (Reader)new InputStreamReader(src), cfg);
            StringWriter out = new StringWriter();
            temp.process(renderContext, (Writer)out);
            out.flush();
            str = out.getBuffer().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process form template", e);
        }
        return str;
    }

    protected Map<String, InputData> toInputDataMap(Map<String, String> inputs) {
        HashMap<String, InputData> retval = new HashMap<String, InputData>();
        if (inputs != null) {
            for (String key : inputs.keySet()) {
                InputData in = new InputData();
                in.setName(key);
                retval.put(key, in);
            }
        }
        return retval;
    }

    protected Map<String, OutputData> toOutputDataMap(Map<String, String> outputs) {
        HashMap<String, OutputData> retval = new HashMap<String, OutputData>();
        if (outputs != null) {
            for (String key : outputs.keySet()) {
                OutputData out = new OutputData();
                out.setName(key);
                retval.put(key, out);
            }
        }
        return retval;
    }
}

