/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.droolsjbpm.services.api.DeployedUnit;
import org.droolsjbpm.services.api.DeploymentService;
import org.droolsjbpm.services.api.DeploymentUnit;
import org.droolsjbpm.services.api.IdentityProvider;
import org.droolsjbpm.services.api.bpmn2.BPMN2DataService;
import org.droolsjbpm.services.impl.DeployedUnitImpl;
import org.droolsjbpm.services.impl.VFSDeploymentUnit;
import org.droolsjbpm.services.impl.audit.ServicesAwareAuditEventBuilder;
import org.droolsjbpm.services.impl.event.Deploy;
import org.droolsjbpm.services.impl.event.DeploymentEvent;
import org.droolsjbpm.services.impl.event.Undeploy;
import org.droolsjbpm.services.impl.model.ProcessDesc;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.impl.RuntimeEnvironmentBuilder;
import org.jbpm.runtime.manager.impl.cdi.InjectableRegisterableItemsFactory;
import org.jbpm.shared.services.api.FileException;
import org.jbpm.shared.services.api.FileService;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.commons.java.nio.file.Path;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.RuntimeManagerFactory;

@ApplicationScoped
public class VFSDeploymentService
implements DeploymentService {
    @Inject
    private BeanManager beanManager;
    @Inject
    private JbpmServicesPersistenceManager pm;
    @Inject
    private FileService fs;
    @Inject
    private RuntimeManagerFactory managerFactory;
    @Inject
    private EntityManagerFactory emf;
    @Inject
    private IdentityProvider identityProvider;
    @Inject
    private BPMN2DataService bpmn2Service;
    @Inject
    @Deploy
    private Event<DeploymentEvent> deploymentEvent;
    @Inject
    @Undeploy
    private Event<DeploymentEvent> undeploymentEvent;
    private Map<String, DeployedUnit> deploymentsMap = new ConcurrentHashMap<String, DeployedUnit>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(DeploymentUnit unit) {
        if (!(unit instanceof VFSDeploymentUnit)) {
            throw new IllegalArgumentException("Invalid deployment unit provided - " + unit.getClass().getName());
        }
        if (this.deploymentsMap.containsKey(unit.getIdentifier())) {
            throw new IllegalStateException("Unit with id " + unit.getIdentifier() + " is already deployed");
        }
        DeployedUnitImpl deployedUnit = new DeployedUnitImpl(unit);
        VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)unit;
        RuntimeEnvironmentBuilder builder = RuntimeEnvironmentBuilder.getDefault().entityManagerFactory(this.emf);
        AbstractAuditLogger auditLogger = AuditLoggerFactory.newJPAInstance((EntityManagerFactory)this.emf);
        ServicesAwareAuditEventBuilder auditEventBuilder = new ServicesAwareAuditEventBuilder();
        auditEventBuilder.setIdentityProvider(this.identityProvider);
        auditEventBuilder.setDeploymentUnitId(vfsUnit.getIdentifier());
        auditLogger.setBuilder((AuditEventBuilder)auditEventBuilder);
        if (this.beanManager != null) {
            builder.registerableItemsFactory(InjectableRegisterableItemsFactory.getFactory((BeanManager)this.beanManager, (AbstractAuditLogger)auditLogger));
        }
        this.loadProcesses(vfsUnit, builder, deployedUnit);
        this.loadRules(vfsUnit, builder, deployedUnit);
        VFSDeploymentService vFSDeploymentService = this;
        synchronized (vFSDeploymentService) {
            if (this.deploymentsMap.containsKey(vfsUnit.getIdentifier())) {
                DeployedUnit deployed = this.deploymentsMap.remove(vfsUnit.getIdentifier());
                RuntimeManager manager = deployed.getRuntimeManager();
                manager.close();
            }
            RuntimeManager manager = null;
            this.deploymentsMap.put(vfsUnit.getIdentifier(), deployedUnit);
            try {
                switch (vfsUnit.getStrategy()) {
                    case SINGLETON: {
                        manager = this.managerFactory.newSingletonRuntimeManager(builder.get(), vfsUnit.getIdentifier());
                        break;
                    }
                    case PER_REQUEST: {
                        manager = this.managerFactory.newPerRequestRuntimeManager(builder.get(), vfsUnit.getIdentifier());
                        break;
                    }
                    case PER_PROCESS_INSTANCE: {
                        manager = this.managerFactory.newPerProcessInstanceRuntimeManager(builder.get(), vfsUnit.getIdentifier());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid strategy " + (Object)((Object)vfsUnit.getStrategy()));
                    }
                }
                deployedUnit.setRuntimeManager(manager);
            }
            catch (Exception e) {
                this.deploymentsMap.remove(vfsUnit.getIdentifier());
                throw new RuntimeException(e);
            }
        }
        if (this.deploymentEvent != null) {
            this.deploymentEvent.fire((Object)new DeploymentEvent(unit.getIdentifier()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(DeploymentUnit unit) {
        VFSDeploymentService vFSDeploymentService = this;
        synchronized (vFSDeploymentService) {
            DeployedUnit deployed = this.deploymentsMap.remove(unit.getIdentifier());
            if (deployed != null) {
                RuntimeManager manager = deployed.getRuntimeManager();
                manager.close();
            }
            if (this.undeploymentEvent != null) {
                this.undeploymentEvent.fire((Object)new DeploymentEvent(unit.getIdentifier()));
            }
        }
    }

    @Override
    public RuntimeManager getRuntimeManager(String deploymentUnitId) {
        if (this.deploymentsMap.containsKey(deploymentUnitId)) {
            return this.deploymentsMap.get(deploymentUnitId).getRuntimeManager();
        }
        return null;
    }

    @Override
    public DeployedUnit getDeployedUnit(String deploymentUnitId) {
        if (this.deploymentsMap.containsKey(deploymentUnitId)) {
            return this.deploymentsMap.get(deploymentUnitId);
        }
        return null;
    }

    protected void loadProcesses(VFSDeploymentUnit vfsUnit, RuntimeEnvironmentBuilder builder, DeployedUnitImpl deployedUnit) {
        Iterable loadProcessFiles = null;
        try {
            Path processFolder = this.fs.getPath(vfsUnit.getRepository() + vfsUnit.getRepositoryFolder());
            loadProcessFiles = this.fs.loadFilesByType(processFolder, ".+bpmn[2]?$");
        }
        catch (FileException ex) {
            Logger.getLogger(VFSDeploymentService.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (Path p : loadProcessFiles) {
            String processString = "";
            try {
                processString = new String(this.fs.loadFile(p));
                builder.addAsset(ResourceFactory.newByteArrayResource((byte[])processString.getBytes()), ResourceType.BPMN2);
                ProcessDesc process = this.bpmn2Service.findProcessId(processString);
                process.setOriginalPath(p.toUri().toString());
                process.setDeploymentId(vfsUnit.getIdentifier());
                deployedUnit.addAssetLocation(process.getId(), process);
            }
            catch (Exception ex) {
                Logger.getLogger(VFSDeploymentService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    protected void loadRules(VFSDeploymentUnit vfsUnit, RuntimeEnvironmentBuilder builder, DeployedUnitImpl deployedUnit) {
        Iterable loadRuleFiles = null;
        try {
            Path rulesFolder = this.fs.getPath(vfsUnit.getRepository() + vfsUnit.getRepositoryFolder());
            loadRuleFiles = this.fs.loadFilesByType(rulesFolder, ".+drl");
        }
        catch (FileException ex) {
            Logger.getLogger(VFSDeploymentService.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (Path p : loadRuleFiles) {
            String ruleString = "";
            try {
                ruleString = new String(this.fs.loadFile(p));
                builder.addAsset(ResourceFactory.newByteArrayResource((byte[])ruleString.getBytes()), ResourceType.DRL);
            }
            catch (Exception ex) {
                Logger.getLogger(VFSDeploymentService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public JbpmServicesPersistenceManager getPm() {
        return this.pm;
    }

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    public FileService getFs() {
        return this.fs;
    }

    public void setFs(FileService fs) {
        this.fs = fs;
    }

    public RuntimeManagerFactory getManagerFactory() {
        return this.managerFactory;
    }

    public void setManagerFactory(RuntimeManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public BPMN2DataService getBpmn2Service() {
        return this.bpmn2Service;
    }

    public void setBpmn2Service(BPMN2DataService bpmn2Service) {
        this.bpmn2Service = bpmn2Service;
    }

    public Map<String, DeployedUnit> getDeploymentsMap() {
        return this.deploymentsMap;
    }

    @Override
    public Collection<DeployedUnit> getDeployedUnits() {
        return Collections.unmodifiableCollection(this.deploymentsMap.values());
    }
}

