/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl.form;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.droolsjbpm.services.api.FormProviderService;
import org.droolsjbpm.services.api.RuntimeDataService;
import org.droolsjbpm.services.api.bpmn2.BPMN2DataService;
import org.droolsjbpm.services.impl.model.ProcessDesc;
import org.jbpm.form.builder.services.model.InputData;
import org.jbpm.form.builder.services.model.OutputData;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.shared.services.api.FileException;
import org.jbpm.shared.services.api.FileService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Task;
import org.kie.commons.java.nio.file.Path;
import org.kie.internal.task.api.TaskContentService;
import org.kie.internal.task.api.TaskInstanceService;
import org.kie.internal.task.api.TaskQueryService;

@ApplicationScoped
public class FormProviderServiceImpl
implements FormProviderService {
    @Inject
    private TaskQueryService queryService;
    @Inject
    private TaskContentService contentService;
    @Inject
    private TaskInstanceService instanceService;
    @Inject
    private BPMN2DataService bpmn2Service;
    @Inject
    private RuntimeDataService dataService;
    @Inject
    private FileService fileService;
    private Map<String, List<String>> effectsForItem = new HashMap<String, List<String>>();
    private Map<String, List<String>> actionsForItem = new HashMap<String, List<String>>();

    public void putEffectsForItem(String className, List<String> effectClassNames) {
        this.effectsForItem.put(className, effectClassNames);
    }

    public void putActionsForItem(String className, List<String> actionClassNames) {
        this.actionsForItem.put(className, actionClassNames);
    }

    @Override
    public String getFormDisplayProcess(String processId) {
        String processAssetPath = this.dataService.getProcessById(processId).getOriginalPath();
        Iterable availableForms = null;
        Path processPath = this.fileService.getPath(processAssetPath);
        Path formsPath = this.fileService.getPath(processPath.getParent().toUri().toString() + "/forms/");
        try {
            if (this.fileService.exists(formsPath)) {
                availableForms = this.fileService.loadFilesByType(formsPath, "ftl");
            }
        }
        catch (FileException ex) {
            Logger.getLogger(FormProviderServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        Path selectedForm = null;
        if (availableForms != null) {
            for (Path p : availableForms) {
                if (!p.getFileName().toString().contains(processId)) continue;
                selectedForm = p;
            }
        }
        InputStream template = null;
        try {
            if (selectedForm == null) {
                Path defaultFormPath;
                String rootPath = processPath.getRoot().toUri().toString();
                if (!rootPath.endsWith(processPath.getFileSystem().getSeparator())) {
                    rootPath = rootPath + processPath.getFileSystem().getSeparator();
                }
                template = this.fileService.exists(defaultFormPath = this.fileService.getPath(rootPath + "globals/forms/DefaultProcess.ftl")) ? new ByteArrayInputStream(this.fileService.loadFile(defaultFormPath)) : this.getClass().getResourceAsStream("/forms/DefaultProcess.ftl");
            } else {
                template = new ByteArrayInputStream(this.fileService.loadFile(selectedForm));
            }
        }
        catch (FileException ex) {
            Logger.getLogger(FormProviderServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        String processString = "";
        try {
            processString = new String(this.fileService.loadFile(processPath));
        }
        catch (Exception e) {
            // empty catch block
        }
        Map<String, String> processData = this.bpmn2Service.getProcessData(processId);
        if (processData == null) {
            processData = new HashMap<String, String>();
        }
        ProcessDesc processDesc = this.bpmn2Service.getProcessDesc(processId);
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("process", processDesc);
        renderContext.put("outputs", processData);
        return this.render(processDesc.getName(), template, renderContext);
    }

    @Override
    public String getFormDisplayTask(long taskId) {
        Task task = this.queryService.getTaskInstanceById(taskId);
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        String processAssetPath = "";
        Path processPath = null;
        if (task.getTaskData().getProcessId() != null && !task.getTaskData().getProcessId().equals("")) {
            processAssetPath = this.dataService.getProcessById(task.getTaskData().getProcessId()).getOriginalPath();
        }
        Object input = null;
        long inputContentId = task.getTaskData().getDocumentContentId();
        if (inputContentId != -1L) {
            Content content = this.contentService.getContentById(inputContentId);
            input = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        }
        if (input == null) {
            input = new HashMap();
        }
        Object output = null;
        long outputContentId = task.getTaskData().getOutputContentId();
        if (outputContentId != -1L) {
            Content content = this.contentService.getContentById(outputContentId);
            output = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        }
        if (output == null) {
            output = new HashMap();
        }
        String name = null;
        List names = task.getNames();
        for (I18NText text : names) {
            if (!"en-UK".equals(text.getLanguage())) continue;
            name = text.getText();
        }
        Iterable availableForms = null;
        try {
            Path formsPath;
            if (processAssetPath != null && !processAssetPath.equals("") && this.fileService.exists(formsPath = this.fileService.getPath((processPath = this.fileService.getPath(processAssetPath)).getParent().toUri().toString() + "/forms/"))) {
                availableForms = this.fileService.loadFilesByType(formsPath, "ftl");
            }
        }
        catch (FileException ex) {
            Logger.getLogger(FormProviderServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        Path selectedForm = null;
        if (availableForms != null) {
            for (Path p : availableForms) {
                if (!p.getFileName().toString().contains(((I18NText)task.getNames().get(0)).getText())) continue;
                selectedForm = p;
            }
        }
        InputStream template = null;
        try {
            if (selectedForm == null) {
                String rootPath = processPath.getRoot().toUri().toString();
                if (!rootPath.endsWith(processPath.getFileSystem().getSeparator())) {
                    rootPath = rootPath + processPath.getFileSystem().getSeparator();
                }
                renderContext.put("inputs", input);
                Path defaultFormPath = this.fileService.getPath(rootPath + "globals/forms/DefaultTask.ftl");
                template = this.fileService.exists(defaultFormPath) ? new ByteArrayInputStream(this.fileService.loadFile(defaultFormPath)) : this.getClass().getResourceAsStream("/forms/DefaultTask.ftl");
            } else {
                template = new ByteArrayInputStream(this.fileService.loadFile(selectedForm));
            }
        }
        catch (FileException ex) {
            Logger.getLogger(FormProviderServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        String processId = task.getTaskData().getProcessId();
        Map<Object, Object> taskOutputMappings = null;
        if (processId != null && !processId.equals("")) {
            taskOutputMappings = this.bpmn2Service.getTaskOutputMappings(processId, ((I18NText)task.getNames().iterator().next()).getText());
        }
        if (taskOutputMappings == null) {
            taskOutputMappings = new HashMap();
        }
        HashMap<String, String> finalOutput = new HashMap<String, String>();
        for (String string : taskOutputMappings.values()) {
            String value = (String)((Map)output).get(string);
            if (value == null) {
                value = "";
            }
            finalOutput.put(string, value);
        }
        renderContext.put("task", task);
        renderContext.put("outputs", finalOutput);
        if (input instanceof Map) {
            for (Map.Entry entry : ((Map)input).entrySet()) {
                renderContext.put((String)entry.getKey(), entry.getValue());
            }
        } else {
            renderContext.put("input", input);
        }
        return this.render(name, template, renderContext);
    }

    public String render(String name, InputStream src, Map<String, Object> renderContext) {
        String str = null;
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateUpdateDelay(0);
            Template temp = new Template(name, (Reader)new InputStreamReader(src), cfg);
            StringWriter out = new StringWriter();
            temp.process(renderContext, (Writer)out);
            out.flush();
            str = out.getBuffer().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process form template", e);
        }
        return str;
    }

    protected Map<String, InputData> toInputDataMap(Map<String, String> inputs) {
        HashMap<String, InputData> retval = new HashMap<String, InputData>();
        if (inputs != null) {
            for (String key : inputs.keySet()) {
                InputData in = new InputData();
                in.setName(key);
                retval.put(key, in);
            }
        }
        return retval;
    }

    protected Map<String, OutputData> toOutputDataMap(Map<String, String> outputs) {
        HashMap<String, OutputData> retval = new HashMap<String, OutputData>();
        if (outputs != null) {
            for (String key : outputs.keySet()) {
                OutputData out = new OutputData();
                out.setName(key);
                retval.put(key, out);
            }
        }
        return retval;
    }
}

