/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.services.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.services.model.FBValidation;
import org.jbpm.form.builder.services.model.FormBuilderDTOHelper;
import org.jbpm.form.builder.services.model.FormItemRepresentation;
import org.jbpm.form.builder.services.model.InputData;
import org.jbpm.form.builder.services.model.Mappable;
import org.jbpm.form.builder.services.model.OutputData;
import org.jbpm.form.builder.services.model.ScriptRepresentation;
import org.jbpm.form.builder.services.model.forms.FormEncodingException;

public class FormRepresentation
implements Mappable {
    private static final long serialVersionUID = 6207901499318773670L;
    private String name;
    private String taskId;
    private String processName;
    private String action;
    private String method;
    private String enctype;
    private List<FBValidation> formValidations = new ArrayList<FBValidation>();
    private List<FormItemRepresentation> formItems = new ArrayList<FormItemRepresentation>();
    private Map<String, OutputData> outputs = new HashMap<String, OutputData>();
    private Map<String, InputData> inputs = new HashMap<String, InputData>();
    private List<ScriptRepresentation> onLoadScripts = new ArrayList<ScriptRepresentation>();
    private List<ScriptRepresentation> onSubmitScripts = new ArrayList<ScriptRepresentation>();
    private long lastModified = System.currentTimeMillis();
    private String documentation;
    private boolean saved = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public List<FBValidation> getFormValidations() {
        return this.formValidations;
    }

    public void setFormValidations(List<FBValidation> formValidations) {
        this.formValidations = formValidations;
    }

    public void addFormValidation(FBValidation formValidation) {
        this.formValidations.add(formValidation);
    }

    public Map<String, InputData> getInputs() {
        return this.inputs;
    }

    public void setInputs(Map<String, InputData> inputs) {
        this.inputs = inputs;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        if (action == null) {
            action = "complete";
        }
        this.action = action;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        if (method == null) {
            method = "POST";
        }
        this.method = method;
    }

    public String getEnctype() {
        return this.enctype;
    }

    public void setEnctype(String enctype) {
        if (enctype == null) {
            enctype = "multipart/form-data";
        }
        this.enctype = enctype;
    }

    public Map<String, OutputData> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Map<String, OutputData> outputs) {
        this.outputs = outputs;
    }

    public List<FormItemRepresentation> getFormItems() {
        return this.formItems;
    }

    public void setFormItems(List<FormItemRepresentation> formItems) {
        this.formItems = formItems;
    }

    public void addFormItem(FormItemRepresentation formItem) {
        this.formItems.add(formItem);
    }

    public List<ScriptRepresentation> getOnLoadScripts() {
        return this.onLoadScripts;
    }

    public void setOnLoadScripts(List<ScriptRepresentation> onLoadScripts) {
        this.onLoadScripts = onLoadScripts;
    }

    public List<ScriptRepresentation> getOnSubmitScripts() {
        return this.onSubmitScripts;
    }

    public void setOnSubmitScripts(List<ScriptRepresentation> onSubmitScripts) {
        this.onSubmitScripts = onSubmitScripts;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public void populate(String name, String taskId, String processName, String action, String method, String enctype, String documentation) {
        this.name = name;
        this.taskId = taskId;
        this.processName = processName;
        this.action = action;
        this.method = method;
        this.enctype = enctype;
        this.documentation = documentation;
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormRepresentation)) {
            return false;
        }
        FormRepresentation other = (FormRepresentation)obj;
        boolean bl = equals = this.name == null && other.name == null || this.name != null && this.name.equals(other.name);
        if (!equals) {
            return equals;
        }
        boolean bl2 = equals = this.taskId == null && other.taskId == null || this.taskId != null && this.taskId.equals(other.taskId);
        if (!equals) {
            return equals;
        }
        boolean bl3 = equals = this.processName == null && other.processName == null || this.processName != null && this.processName.equals(other.processName);
        if (!equals) {
            return equals;
        }
        boolean bl4 = equals = this.action == null && other.action == null || this.action != null && this.action.equals(other.action);
        if (!equals) {
            return equals;
        }
        boolean bl5 = equals = this.method == null && other.method == null || this.method != null && this.method.equals(other.method);
        if (!equals) {
            return equals;
        }
        boolean bl6 = equals = this.enctype == null && other.enctype == null || this.enctype != null && this.enctype.equals(other.enctype);
        if (!equals) {
            return equals;
        }
        boolean bl7 = equals = this.documentation == null && other.documentation == null || this.documentation != null && this.documentation.equals(other.documentation);
        if (!equals) {
            return equals;
        }
        boolean bl8 = equals = this.formValidations == null && other.formValidations == null || this.formValidations != null && ((Object)this.formValidations).equals(other.formValidations);
        if (!equals) {
            return equals;
        }
        boolean bl9 = equals = this.formItems == null && other.formItems == null || this.formItems != null && ((Object)this.formItems).equals(other.formItems);
        if (!equals) {
            return equals;
        }
        boolean bl10 = equals = this.outputs == null && other.outputs == null || this.outputs != null && other.outputs != null && ((Object)this.outputs.entrySet()).equals(other.outputs.entrySet());
        if (!equals) {
            return equals;
        }
        boolean bl11 = equals = this.inputs == null && other.inputs == null || this.inputs != null && other.inputs != null && ((Object)this.inputs.entrySet()).equals(other.inputs.entrySet());
        if (!equals) {
            return equals;
        }
        boolean bl12 = equals = this.onLoadScripts == null && other.onLoadScripts == null || this.onLoadScripts != null && ((Object)this.onLoadScripts).equals(other.onLoadScripts);
        if (!equals) {
            return equals;
        }
        boolean bl13 = equals = this.onSubmitScripts == null && other.onSubmitScripts == null || this.onSubmitScripts != null && ((Object)this.onSubmitScripts).equals(other.onSubmitScripts);
        if (!equals) {
            return equals;
        }
        equals = this.saved == other.saved;
        return equals;
    }

    public int hashCode() {
        int result = super.hashCode();
        int aux = this.name == null ? 0 : this.name.hashCode();
        result = 37 * result + aux;
        aux = this.taskId == null ? 0 : this.taskId.hashCode();
        result = 37 * result + aux;
        aux = this.processName == null ? 0 : this.processName.hashCode();
        result = 37 * result + aux;
        aux = this.action == null ? 0 : this.action.hashCode();
        result = 37 * result + aux;
        aux = this.method == null ? 0 : this.method.hashCode();
        result = 37 * result + aux;
        aux = this.enctype == null ? 0 : this.enctype.hashCode();
        result = 37 * result + aux;
        aux = this.enctype == null ? 0 : this.enctype.hashCode();
        result = 37 * result + aux;
        aux = this.documentation == null ? 0 : this.documentation.hashCode();
        result = 37 * result + aux;
        aux = this.formValidations == null ? 0 : ((Object)this.formValidations).hashCode();
        result = 37 * result + aux;
        aux = this.formItems == null ? 0 : ((Object)this.formItems).hashCode();
        result = 37 * result + aux;
        aux = this.outputs == null ? 0 : ((Object)this.outputs).hashCode();
        result = 37 * result + aux;
        aux = this.inputs == null ? 0 : ((Object)this.inputs).hashCode();
        result = 37 * result + aux;
        aux = this.onLoadScripts == null ? 0 : ((Object)this.onLoadScripts).hashCode();
        result = 37 * result + aux;
        aux = this.onSubmitScripts == null ? 0 : ((Object)this.onSubmitScripts).hashCode();
        result = 37 * result + aux;
        aux = this.saved ? 1 : 0;
        result = 37 * result + aux;
        return result;
    }

    @Override
    public Map<String, Object> getDataMap() {
        FormBuilderDTOHelper helper = new FormBuilderDTOHelper();
        helper.setString("name", this.name);
        helper.setString("taskId", this.taskId);
        helper.setString("processName", this.processName);
        helper.setString("action", this.action);
        helper.setString("method", this.method);
        helper.setString("enctype", this.enctype);
        ArrayList<Object> formItems = new ArrayList<Object>();
        if (this.formItems != null) {
            for (FormItemRepresentation item : this.formItems) {
                formItems.add(item.getDataMap());
            }
            helper.setList("formItems", formItems);
        }
        if (this.formValidations != null) {
            ArrayList<Object> formValidations = new ArrayList<Object>();
            for (FBValidation fBValidation : this.formValidations) {
                formValidations.add(fBValidation.getDataMap());
            }
            helper.setList("formValidations", formValidations);
        }
        HashMap<String, Object> inputsMap = new HashMap<String, Object>();
        if (this.inputs != null) {
            for (Map.Entry entry : this.inputs.entrySet()) {
                InputData input = (InputData)entry.getValue();
                Map<String, Object> value = null;
                if (input != null) {
                    value = input.getDataMap();
                }
                inputsMap.put((String)entry.getKey(), value);
            }
        }
        helper.setMap("inputs", inputsMap);
        HashMap<String, Object> outputsMap = new HashMap<String, Object>();
        if (this.outputs != null) {
            for (Map.Entry<String, OutputData> entry : this.outputs.entrySet()) {
                OutputData output = entry.getValue();
                Map<String, Object> value = null;
                if (output != null) {
                    value = output.getDataMap();
                }
                outputsMap.put(entry.getKey(), value);
            }
        }
        helper.setMap("outputs", outputsMap);
        helper.setBoolean("saved", this.saved);
        helper.setLong("lastModified", this.lastModified);
        if (this.onLoadScripts != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (ScriptRepresentation script : this.onLoadScripts) {
                arrayList.add(script.getDataMap());
            }
            helper.setList("onLoadScripts", arrayList);
        }
        if (this.onSubmitScripts != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (ScriptRepresentation script : this.onSubmitScripts) {
                arrayList.add(script.getDataMap());
            }
            helper.setList("onSubmitScripts", arrayList);
        }
        return helper.getMap();
    }

    @Override
    public void setDataMap(Map<String, Object> dataMap) throws FormEncodingException {
        List<FormBuilderDTOHelper> validationsRep;
        FormBuilderDTOHelper helper = new FormBuilderDTOHelper(dataMap);
        this.setName(helper.getString("name"));
        this.setTaskId(helper.getString("taskId"));
        this.setProcessName(helper.getString("processName"));
        this.setAction(helper.getString("action"));
        this.setMethod(helper.getString("method"));
        this.setEnctype(helper.getString("enctype"));
        List<FormBuilderDTOHelper> itemReps = helper.getListOfDtoHelpers("formItems");
        this.formItems.clear();
        if (itemReps != null) {
            for (FormBuilderDTOHelper itemRep : itemReps) {
                FormItemRepresentation item = null;
                try {
                    item = (FormItemRepresentation)itemRep.createInstance();
                    item.setDataMap(itemRep.getMap());
                }
                catch (Exception ex) {
                    throw new FormEncodingException("invalid form item", ex);
                }
                this.formItems.add(item);
            }
        }
        if ((validationsRep = helper.getListOfDtoHelpers("formValidations")) != null) {
            for (FormBuilderDTOHelper subDto : validationsRep) {
                try {
                    FBValidation validation = (FBValidation)subDto.createInstance();
                    validation.setDataMap(subDto.getMap());
                    this.formValidations.add(validation);
                }
                catch (Exception ex) {
                    throw new FormEncodingException("invalid validation item", ex);
                }
            }
        }
        Map<String, Object> inputsMap = helper.getMap("inputs");
        this.inputs.clear();
        for (Map.Entry<String, Object> entry : inputsMap.entrySet()) {
            InputData input = new InputData();
            Map value = (Map)entry.getValue();
            input.setDataMap(value);
            this.inputs.put(entry.getKey(), input);
        }
        Map<String, Object> outputsMap = helper.getMap("outputs");
        this.outputs.clear();
        for (Map.Entry<String, Object> entry : outputsMap.entrySet()) {
            OutputData output = new OutputData();
            Map value = (Map)entry.getValue();
            output.setDataMap(value);
            this.outputs.put(entry.getKey(), output);
        }
        this.saved = helper.getBoolean("saved");
        this.lastModified = helper.getLong("lastModified");
        this.onLoadScripts.clear();
        List<FormBuilderDTOHelper> loadScriptsRep = helper.getListOfDtoHelpers("onLoadScripts");
        if (loadScriptsRep != null) {
            for (FormBuilderDTOHelper scriptRep : loadScriptsRep) {
                ScriptRepresentation script = new ScriptRepresentation();
                script.setDataMap(scriptRep.getMap());
                this.onLoadScripts.add(script);
            }
        }
        this.onSubmitScripts.clear();
        List<FormBuilderDTOHelper> submitScriptsRep = helper.getListOfDtoHelpers("onSubmitScripts");
        if (submitScriptsRep != null) {
            for (FormBuilderDTOHelper scriptRep : submitScriptsRep) {
                ScriptRepresentation script = new ScriptRepresentation();
                script.setDataMap(scriptRep.getMap());
                this.onSubmitScripts.add(script);
            }
        }
    }
}

