/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.services.model.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.services.model.FormItemRepresentation;
import org.jbpm.form.builder.services.model.forms.FormEncodingException;
import org.jbpm.form.builder.services.model.forms.FormEncodingFactory;
import org.jbpm.form.builder.services.model.forms.FormRepresentationDecoder;

public class AbsolutePanelRepresentation
extends FormItemRepresentation {
    private Map<Position, FormItemRepresentation> items = new HashMap<Position, FormItemRepresentation>();
    private String id;

    public AbsolutePanelRepresentation() {
        super("absolutePanel");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addItem(FormItemRepresentation rep, int x, int y) {
        this.items.put(new Position(x, y), rep);
    }

    public Map<Position, FormItemRepresentation> getItems() {
        return this.items;
    }

    @Override
    public Map<String, Object> getDataMap() {
        Map<String, Object> data = super.getDataMap();
        data.put("id", this.id);
        ArrayList<Map<String, Object>> mapItems = new ArrayList<Map<String, Object>>();
        if (this.items != null) {
            for (Map.Entry<Position, FormItemRepresentation> entry : this.items.entrySet()) {
                FormItemRepresentation item = entry.getValue();
                Position pos = entry.getKey();
                Map<String, Object> itemData = item == null ? null : item.getDataMap();
                itemData.put("x", pos.getX());
                itemData.put("y", pos.getY());
                mapItems.add(itemData);
            }
        }
        data.put("items", mapItems);
        return data;
    }

    @Override
    public void setDataMap(Map<String, Object> data) throws FormEncodingException {
        super.setDataMap(data);
        this.id = (String)data.get("id");
        this.items.clear();
        List mapItems = (List)data.get("items");
        FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
        if (mapItems != null) {
            for (Map entry : mapItems) {
                int x = entry.get("x") == null ? 0 : ((Number)entry.get("x")).intValue();
                int y = entry.get("y") == null ? 0 : ((Number)entry.get("y")).intValue();
                Position pos = new Position(x, y);
                FormItemRepresentation item = (FormItemRepresentation)decoder.decode(entry);
                this.items.put(pos, item);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals;
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbsolutePanelRepresentation)) {
            return false;
        }
        AbsolutePanelRepresentation other = (AbsolutePanelRepresentation)obj;
        boolean bl = equals = this.items == null && other.items == null || this.items != null && other.items != null && ((Object)this.items.entrySet()).equals(other.items.entrySet());
        if (!equals) {
            return equals;
        }
        equals = this.id == null && other.id == null || this.id != null && this.id.equals(other.id);
        return equals;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        int aux = this.items == null ? 0 : ((Object)this.items).hashCode();
        result = 37 * result + aux;
        aux = this.id == null ? 0 : this.id.hashCode();
        result = 37 * result + aux;
        return result;
    }

    public static class Position {
        private int x;
        private int y;

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Position() {
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

