/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.xml.JaxbNodeInstanceLog;
import org.jbpm.process.audit.xml.JaxbProcessInstanceLog;
import org.jbpm.process.audit.xml.JaxbVariableInstanceLog;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;

public class JaxbHistoryLogTest
extends AbstractBaseTest {
    private static Random random = new Random();
    private static Class[] jaxbClasses = new Class[]{JaxbProcessInstanceLog.class, JaxbNodeInstanceLog.class, JaxbVariableInstanceLog.class};

    @Test
    public void roundTripXmlAndTestEqualsProcessInstanceLog() throws Exception {
        ProcessInstanceLog origLog = new ProcessInstanceLog(54L, "org.hospital.patient.triage");
        origLog.setDuration(Long.valueOf(65L));
        origLog.setDuration(Long.valueOf(234L));
        origLog.setEnd(new Date(new Date().getTime() + 1000L));
        origLog.setExternalId("testDomainId");
        origLog.setIdentity("identityNotMemory");
        origLog.setStatus(2);
        origLog.setOutcome("descriptiveErrorCodeOfAnError");
        origLog.setParentProcessInstanceId(65L);
        origLog.setProcessName("org.process.not.technical");
        origLog.setProcessVersion("v3.14");
        JaxbProcessInstanceLog xmlLog = new JaxbProcessInstanceLog(origLog);
        String xmlStr = JaxbHistoryLogTest.convertJaxbObjectToString(xmlLog);
        JaxbProcessInstanceLog newXmlLog = (JaxbProcessInstanceLog)JaxbHistoryLogTest.convertStringToJaxbObject(xmlStr);
        this.compareOrig(xmlLog, newXmlLog, JaxbProcessInstanceLog.class);
        ProcessInstanceLog newLog = (ProcessInstanceLog)newXmlLog.createEntityInstance();
        this.compareOrig(origLog, newLog, ProcessInstanceLog.class);
    }

    @Test
    public void roundTripXmlAndTestEqualsProcessInstanceLogNillable() throws Exception {
        ProcessInstanceLog origLog = new ProcessInstanceLog(54L, "org.hospital.patient.triage");
        origLog.setDuration(Long.valueOf(65L));
        origLog.setEnd(new Date(new Date().getTime() + 1000L));
        origLog.setExternalId("testDomainId");
        origLog.setIdentity("identityNotMemory");
        origLog.setProcessName("org.process.not.technical");
        origLog.setProcessVersion("v3.14");
        JaxbProcessInstanceLog xmlLog = new JaxbProcessInstanceLog(origLog);
        String xmlStr = JaxbHistoryLogTest.convertJaxbObjectToString(xmlLog);
        JaxbProcessInstanceLog newXmlLog = (JaxbProcessInstanceLog)JaxbHistoryLogTest.convertStringToJaxbObject(xmlStr);
        Assert.assertEquals((Object)xmlLog.getProcessInstanceId(), (Object)newXmlLog.getProcessInstanceId());
        Assert.assertEquals((Object)xmlLog.getProcessId(), (Object)newXmlLog.getProcessId());
        Assert.assertEquals((Object)xmlLog.getDuration(), (Object)newXmlLog.getDuration());
        Assert.assertEquals((Object)xmlLog.getEnd(), (Object)newXmlLog.getEnd());
        Assert.assertEquals((Object)xmlLog.getExternalId(), (Object)newXmlLog.getExternalId());
        Assert.assertEquals((Object)xmlLog.getIdentity(), (Object)newXmlLog.getIdentity());
        Assert.assertEquals((Object)xmlLog.getStatus(), (Object)newXmlLog.getStatus());
        Assert.assertEquals((Object)xmlLog.getOutcome(), (Object)newXmlLog.getOutcome());
        Assert.assertEquals((Object)xmlLog.getParentProcessInstanceId(), (Object)newXmlLog.getParentProcessInstanceId());
        Assert.assertEquals((Object)xmlLog.getProcessName(), (Object)newXmlLog.getProcessName());
        Assert.assertEquals((Object)xmlLog.getProcessVersion(), (Object)newXmlLog.getProcessVersion());
    }

    @Test
    public void roundTripXmlAndTestEqualsNodeInstanceLog() throws Exception {
        int type = 0;
        long processInstanceId = 23L;
        String processId = "org.hospital.doctor.review";
        String nodeInstanceId = "1-1";
        String nodeId = "1";
        String nodeName = "notification";
        NodeInstanceLog origLog = new NodeInstanceLog(type, processInstanceId, processId, nodeInstanceId, nodeId, nodeName);
        origLog.setWorkItemId(Long.valueOf(78L));
        origLog.setConnection("link");
        origLog.setExternalId("not-internal-num");
        origLog.setNodeType("the-sort-of-point");
        JaxbNodeInstanceLog xmlLog = new JaxbNodeInstanceLog(origLog);
        String xmlStr = JaxbHistoryLogTest.convertJaxbObjectToString(xmlLog);
        JaxbNodeInstanceLog newXmlLog = (JaxbNodeInstanceLog)JaxbHistoryLogTest.convertStringToJaxbObject(xmlStr);
        this.compareOrig(xmlLog, newXmlLog, JaxbNodeInstanceLog.class);
        NodeInstanceLog newLog = (NodeInstanceLog)newXmlLog.createEntityInstance();
        this.compareOrig(origLog, newLog, NodeInstanceLog.class);
    }

    @Test
    public void roundTripXmlAndTestEqualsVariableInstanceLog() throws Exception {
        long processInstanceId = 23L;
        String processId = "org.hospital.intern.rounds";
        String variableInstanceId = "patientNum-1";
        String variableId = "patientNum";
        String value = "33";
        String oldValue = "32";
        VariableInstanceLog origLog = new VariableInstanceLog(processInstanceId, processId, variableInstanceId, variableId, value, oldValue);
        origLog.setExternalId("outside-identity-representation");
        origLog.setOldValue("previous-data-that-this-variable-contains");
        origLog.setValue("the-new-data-that-has-been-put-in-this-variable");
        origLog.setVariableId("shortend-representation-of-this-representation");
        origLog.setVariableInstanceId("id-instance-variable");
        JaxbVariableInstanceLog xmlLog = new JaxbVariableInstanceLog(origLog);
        String xmlStr = JaxbHistoryLogTest.convertJaxbObjectToString(xmlLog);
        JaxbVariableInstanceLog newXmlLog = (JaxbVariableInstanceLog)JaxbHistoryLogTest.convertStringToJaxbObject(xmlStr);
        this.compareOrig(xmlLog, newXmlLog, JaxbVariableInstanceLog.class);
        VariableInstanceLog newLog = (VariableInstanceLog)newXmlLog.createEntityInstance();
        this.compareOrig(origLog, newLog, VariableInstanceLog.class);
    }

    private void compareOrig(Object origObj, Object newObj, Class objClass) {
        ComparePair compare = new ComparePair(origObj, newObj, objClass);
        LinkedList<ComparePair> compares = new LinkedList<ComparePair>();
        compares.add(compare);
        while (!compares.isEmpty()) {
            compares.addAll(((ComparePair)compares.poll()).compare());
        }
    }

    private static String convertJaxbObjectToString(Object object) throws JAXBException {
        Marshaller marshaller = JAXBContext.newInstance((Class[])jaxbClasses).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal(object, (Writer)stringWriter);
        String output = stringWriter.toString();
        return output;
    }

    private static Object convertStringToJaxbObject(String xmlStr) throws JAXBException {
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])jaxbClasses).createUnmarshaller();
        ByteArrayInputStream xmlStrInputStream = new ByteArrayInputStream(xmlStr.getBytes());
        Object jaxbObj = unmarshaller.unmarshal((InputStream)xmlStrInputStream);
        return jaxbObj;
    }

    private static class ComparePair {
        private Object orig;
        private Object copy;
        private Class<?> objInterface;

        public ComparePair(Object a, Object b, Class<?> c) {
            this.orig = a;
            this.copy = b;
            this.objInterface = c;
        }

        public List<ComparePair> compare() {
            return this.compareObjects(this.orig, this.copy, this.objInterface);
        }

        private List<ComparePair> compareObjects(Object orig, Object copy, Class<?> objInterface) {
            ArrayList<ComparePair> cantCompare = new ArrayList<ComparePair>();
            for (Method getIsMethod : objInterface.getDeclaredMethods()) {
                String fieldName;
                String methodName = getIsMethod.getName();
                if (methodName.startsWith("get")) {
                    fieldName = methodName.substring(3);
                } else {
                    if (!methodName.startsWith("is")) continue;
                    fieldName = methodName.substring(2);
                }
                fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
                try {
                    Object origField = getIsMethod.invoke(orig, new Object[0]);
                    Object copyField = getIsMethod.invoke(copy, new Object[0]);
                    if (origField == null) {
                        Assert.fail((String)("Please fill in the " + fieldName + " field in the " + objInterface.getSimpleName() + "!"));
                    }
                    if (!(origField instanceof Enum) && origField.getClass().getPackage().getName().startsWith("org.")) {
                        cantCompare.add(new ComparePair(origField, copyField, this.getInterface(origField)));
                        continue;
                    }
                    if (origField instanceof List) {
                        List origList = (List)origField;
                        List copyList = (List)copyField;
                        for (int i = 0; i < origList.size(); ++i) {
                            Class<?> newInterface = origField.getClass();
                            while (newInterface.getInterfaces().length > 0) {
                                newInterface = newInterface.getInterfaces()[0];
                            }
                            cantCompare.add(new ComparePair(origList.get(i), copyList.get(i), this.getInterface(origList.get(i))));
                        }
                        continue;
                    }
                    Assert.assertEquals((String)fieldName, (Object)origField, (Object)copyField);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to compare " + fieldName, e);
                }
            }
            return cantCompare;
        }

        private Class<?> getInterface(Object obj) {
            Class<?> newInterface;
            Class<?> parent = newInterface = obj.getClass();
            while (parent != null) {
                Class<?> newParent;
                parent = null;
                if (newInterface.getInterfaces().length <= 0 || !(newParent = newInterface.getInterfaces()[0]).getPackage().getName().startsWith("org.")) continue;
                parent = newInterface = newParent;
            }
            return newInterface;
        }
    }
}

