/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.drools.core.io.impl.ClassPathResource;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuditLogServiceTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAuditLogServiceTest.class);

    public static KnowledgeBase createKnowledgeBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("ruleflow.rf"), ResourceType.DRF);
        kbuilder.add((Resource)new ClassPathResource("ruleflow2.rf"), ResourceType.DRF);
        kbuilder.add((Resource)new ClassPathResource("ruleflow3.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    public static StatefulKnowledgeSession createKieSession(KieBase kbase, Environment env) {
        Properties properties = new Properties();
        properties.put("drools.processInstanceManagerFactory", "org.jbpm.persistence.processinstance.JPAProcessInstanceManagerFactory");
        properties.put("drools.processSignalManagerFactory", "org.jbpm.persistence.processinstance.JPASignalManagerFactory");
        KieSessionConfiguration config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration((Properties)properties);
        StatefulKnowledgeSession session = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)config, (Environment)env);
        return session;
    }

    public static void runTestLogger1(KieSession session, AuditLogService auditLogService) throws Exception {
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        int initialProcessInstanceSize = processInstances.size();
        long processInstanceId = session.startProcess("com.sample.ruleflow").getId();
        logger.debug("Checking process instances for process 'com.sample.ruleflow'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        Assert.assertEquals((long)(initialProcessInstanceSize + 1), (long)processInstances.size());
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assert.assertNotNull((Object)processInstance.getStart());
        Assert.assertNotNull((String)"ProcessInstanceLog does not contain end date.", (Object)processInstance.getEnd());
        Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
        Assert.assertEquals((Object)"com.sample.ruleflow", (Object)processInstance.getProcessId());
        List nodeInstances = auditLogService.findNodeInstances(processInstanceId);
        Assert.assertEquals((long)6L, (long)nodeInstances.size());
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            logger.debug(nodeInstance.toString());
            Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
            Assert.assertEquals((Object)"com.sample.ruleflow", (Object)processInstance.getProcessId());
            Assert.assertNotNull((Object)nodeInstance.getDate());
        }
        auditLogService.clear();
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        Assert.assertTrue((boolean)processInstances.isEmpty());
    }

    public static void runTestLogger2(KieSession session, AuditLogService auditLogService) {
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        int initialProcessInstanceSize = processInstances.size();
        session.startProcess("com.sample.ruleflow");
        session.startProcess("com.sample.ruleflow");
        logger.debug("Checking process instances for process 'com.sample.ruleflow'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        Assert.assertEquals((long)(initialProcessInstanceSize + 2), (long)processInstances.size());
        for (ProcessInstanceLog processInstance : processInstances) {
            logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
            List nodeInstances = auditLogService.findNodeInstances(processInstance.getProcessInstanceId().longValue());
            for (NodeInstanceLog nodeInstance : nodeInstances) {
                logger.debug("{} -> {}", (Object)nodeInstance.toString(), (Object)nodeInstance.getDate());
            }
            Assert.assertEquals((long)6L, (long)nodeInstances.size());
        }
        auditLogService.clear();
    }

    public static void runTestLogger3(KieSession session, AuditLogService auditLogService) {
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        int initialProcessInstanceSize = processInstances.size();
        long processInstanceId = session.startProcess("com.sample.ruleflow2").getId();
        logger.debug("Checking process instances for process 'com.sample.ruleflow2'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow2");
        Assert.assertEquals((long)(initialProcessInstanceSize + 1), (long)processInstances.size());
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assert.assertNotNull((Object)processInstance.getStart());
        Assert.assertNotNull((String)"ProcessInstanceLog does not contain end date.", (Object)processInstance.getEnd());
        Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
        Assert.assertEquals((Object)"com.sample.ruleflow2", (Object)processInstance.getProcessId());
        List nodeInstances = auditLogService.findNodeInstances(processInstanceId);
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            logger.debug("{} -> {}", (Object)nodeInstance.toString(), (Object)nodeInstance.getDate());
            Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
            Assert.assertEquals((Object)"com.sample.ruleflow2", (Object)processInstance.getProcessId());
            Assert.assertNotNull((Object)nodeInstance.getDate());
        }
        Assert.assertEquals((long)14L, (long)nodeInstances.size());
        auditLogService.clear();
    }

    public static void runTestLogger4(KieSession session, AuditLogService auditLogService) throws Exception {
        final ArrayList workItemIds = new ArrayList();
        session.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                workItemIds.add(workItem.getId());
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            }
        });
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        int initialProcessInstanceSize = processInstances.size();
        HashMap params = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("One");
        list.add("Two");
        list.add("Three");
        params.put("list", list);
        long processInstanceId = session.startProcess("com.sample.ruleflow3", params).getId();
        List varLogs = auditLogService.findVariableInstancesByName("s", true);
        Assert.assertFalse((boolean)varLogs.isEmpty());
        Assert.assertEquals((long)1L, (long)varLogs.size());
        for (Long workItemId : workItemIds) {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("Result", "ResultValue");
            session.getWorkItemManager().completeWorkItem(workItemId.longValue(), results);
        }
        logger.debug("Checking process instances for process 'com.sample.ruleflow3'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        Assert.assertEquals((long)(initialProcessInstanceSize + 1), (long)processInstances.size());
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assert.assertNotNull((Object)processInstance.getStart());
        Assert.assertNotNull((String)"ProcessInstanceLog does not contain end date.", (Object)processInstance.getEnd());
        Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
        Assert.assertEquals((Object)"com.sample.ruleflow3", (Object)processInstance.getProcessId());
        List variableInstances = auditLogService.findVariableInstances(processInstanceId);
        Assert.assertEquals((long)9L, (long)variableInstances.size());
        for (VariableInstanceLog variableInstance : variableInstances) {
            logger.debug(variableInstance.toString());
            Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
            Assert.assertEquals((Object)"com.sample.ruleflow3", (Object)processInstance.getProcessId());
            Assert.assertNotNull((Object)variableInstance.getDate());
        }
        List emptyVarLogs = auditLogService.findVariableInstancesByName("s", true);
        Assert.assertTrue((boolean)emptyVarLogs.isEmpty());
        for (VariableInstanceLog origVarLog : variableInstances) {
            varLogs = auditLogService.findVariableInstancesByName(origVarLog.getVariableId(), false);
            for (VariableInstanceLog varLog : varLogs) {
                Assert.assertEquals((Object)origVarLog.getVariableId(), (Object)varLog.getVariableId());
            }
        }
        emptyVarLogs = auditLogService.findVariableInstancesByNameAndValue("s", "InitialValue", true);
        Assert.assertTrue((boolean)emptyVarLogs.isEmpty());
        String varId = "s";
        String varValue = "ResultValue";
        variableInstances = auditLogService.findVariableInstancesByNameAndValue(varId, varValue, false);
        Assert.assertEquals((long)1L, (long)variableInstances.size());
        VariableInstanceLog varLog = (VariableInstanceLog)variableInstances.get(0);
        Assert.assertEquals((Object)varId, (Object)varLog.getVariableId());
        Assert.assertEquals((Object)varValue, (Object)varLog.getValue());
        auditLogService.clear();
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        Assert.assertTrue((boolean)processInstances.isEmpty());
    }

    public static void runTestLogger4LargeVariable(KieSession session, AuditLogService auditLogService) throws Exception {
        session.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                HashMap<String, String> results = new HashMap<String, String>();
                results.put("Result", "ResultValue");
                manager.completeWorkItem(workItem.getId(), results);
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            }
        });
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        int initialProcessInstanceSize = processInstances.size();
        HashMap params = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("One");
        list.add("Two");
        String three = "";
        for (int i = 0; i < 1024; ++i) {
            three = three + "*";
        }
        list.add(three);
        params.put("list", list);
        long processInstanceId = session.startProcess("com.sample.ruleflow3", params).getId();
        logger.debug("Checking process instances for process 'com.sample.ruleflow3'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        int expected = initialProcessInstanceSize + 1;
        Assert.assertEquals((String)("[Expected " + expected + " ProcessInstanceLog instances, not " + processInstances.size() + "]"), (long)expected, (long)processInstances.size());
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assert.assertNotNull((Object)processInstance.getStart());
        Assert.assertNotNull((String)"ProcessInstanceLog does not contain end date.", (Object)processInstance.getEnd());
        Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
        Assert.assertEquals((Object)"com.sample.ruleflow3", (Object)processInstance.getProcessId());
        List variableInstances = auditLogService.findVariableInstances(processInstanceId);
        Assert.assertEquals((long)6L, (long)variableInstances.size());
        for (VariableInstanceLog variableInstance : variableInstances) {
            logger.debug(variableInstance.toString());
            Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
            Assert.assertEquals((Object)"com.sample.ruleflow3", (Object)processInstance.getProcessId());
            Assert.assertNotNull((Object)variableInstance.getDate());
        }
        auditLogService.clear();
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        Assert.assertTrue((boolean)processInstances.isEmpty());
    }

    public static void runTestLogger5(KieSession session, AuditLogService auditLogService) throws Exception {
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        int initialProcessInstanceSize = processInstances.size();
        long processInstanceId = session.startProcess("com.sample.ruleflow").getId();
        logger.debug("Checking process instances for process 'com.sample.ruleflow'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        Assert.assertEquals((long)(initialProcessInstanceSize + 1), (long)processInstances.size());
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assert.assertNotNull((Object)processInstance.getStart());
        Assert.assertNotNull((Object)processInstance.getEnd());
        Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
        Assert.assertEquals((Object)"com.sample.ruleflow", (Object)processInstance.getProcessId());
        Assert.assertEquals((long)2L, (long)processInstance.getStatus().intValue());
        List nodeInstances = auditLogService.findNodeInstances(processInstanceId);
        Assert.assertEquals((long)6L, (long)nodeInstances.size());
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            logger.debug(nodeInstance.toString());
            Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
            Assert.assertEquals((Object)"com.sample.ruleflow", (Object)processInstance.getProcessId());
            Assert.assertNotNull((Object)nodeInstance.getDate());
        }
        auditLogService.clear();
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        Assert.assertTrue((boolean)processInstances.isEmpty());
    }

    public static void runTestLoggerWithCustomVariableLogLength(KieSession session, AuditLogService auditLogService) throws Exception {
        System.setProperty("org.jbpm.var.log.length", "15");
        final ArrayList workItemIds = new ArrayList();
        session.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                workItemIds.add(workItem.getId());
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            }
        });
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        int initialProcessInstanceSize = processInstances.size();
        processInstances = auditLogService.findActiveProcessInstances();
        int initialActiveProcessInstanceSize = processInstances.size();
        String variableValue = "very short value that should be trimmed by custom variable log length";
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> list = new ArrayList<String>();
        list.add("One");
        list.add("Two");
        list.add("Three");
        params.put("list", list);
        params.put("s", variableValue);
        long processInstanceId = session.startProcess("com.sample.ruleflow3", params).getId();
        int numActiveProcesses = auditLogService.findActiveProcessInstances().size();
        Assert.assertEquals((String)"find active processes did not work", (long)(initialActiveProcessInstanceSize + 1), (long)numActiveProcesses);
        List varLogs = auditLogService.findVariableInstancesByName("s", true);
        Assert.assertFalse((boolean)varLogs.isEmpty());
        Assert.assertEquals((long)2L, (long)varLogs.size());
        VariableInstanceLog varLogS = (VariableInstanceLog)varLogs.get(1);
        Assert.assertEquals((Object)variableValue.substring(0, 15), (Object)varLogS.getValue());
        for (Long workItemId : workItemIds) {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("Result", "ResultValue");
            session.getWorkItemManager().completeWorkItem(workItemId.longValue(), results);
        }
        logger.debug("Checking process instances for process 'com.sample.ruleflow3'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        Assert.assertEquals((long)(initialProcessInstanceSize + 1), (long)processInstances.size());
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assert.assertNotNull((Object)processInstance.getStart());
        Assert.assertNotNull((String)"ProcessInstanceLog does not contain end date.", (Object)processInstance.getEnd());
        Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
        Assert.assertEquals((Object)"com.sample.ruleflow3", (Object)processInstance.getProcessId());
        List variableInstances = auditLogService.findVariableInstances(processInstanceId);
        Assert.assertEquals((long)10L, (long)variableInstances.size());
        for (VariableInstanceLog variableInstance : variableInstances) {
            logger.debug(variableInstance.toString());
            Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
            Assert.assertEquals((Object)"com.sample.ruleflow3", (Object)processInstance.getProcessId());
            Assert.assertNotNull((Object)variableInstance.getDate());
        }
        List emptyVarLogs = auditLogService.findVariableInstancesByName("s", true);
        Assert.assertTrue((boolean)emptyVarLogs.isEmpty());
        for (VariableInstanceLog origVarLog : variableInstances) {
            varLogs = auditLogService.findVariableInstancesByName(origVarLog.getVariableId(), false);
            for (VariableInstanceLog varLog : varLogs) {
                Assert.assertEquals((Object)origVarLog.getVariableId(), (Object)varLog.getVariableId());
            }
        }
        emptyVarLogs = auditLogService.findVariableInstancesByNameAndValue("s", "InitialValue", true);
        Assert.assertTrue((boolean)emptyVarLogs.isEmpty());
        String varId = "s";
        String varValue = "ResultValue";
        variableInstances = auditLogService.findVariableInstancesByNameAndValue(varId, varValue, false);
        Assert.assertEquals((long)1L, (long)variableInstances.size());
        VariableInstanceLog varLog = (VariableInstanceLog)variableInstances.get(0);
        Assert.assertEquals((Object)varId, (Object)varLog.getVariableId());
        Assert.assertEquals((Object)varValue, (Object)varLog.getValue());
        auditLogService.clear();
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        Assert.assertTrue((boolean)processInstances.isEmpty());
    }
}

