/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.query;

import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.audit.AuditLogServiceTest;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.strategy.StandaloneJtaStrategy;
import org.jbpm.process.instance.impl.util.LoggingPrintStream;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.query.ParametrizedQuery;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditQueryTest
extends JPAAuditLogService {
    private static HashMap<String, Object> context;
    private static EntityManagerFactory emf;
    private static final Logger logger;
    private ProcessInstanceLog[] pilTestData;
    private VariableInstanceLog[] vilTestData;
    private NodeInstanceLog[] nilTestData;
    private static Random random;
    private static int MAX;
    private static int MIN;
    private static int BOTH;

    @BeforeClass
    public static void configure() {
        LoggingPrintStream.interceptSysOutSysErr();
        context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        emf = (EntityManagerFactory)context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
    }

    @AfterClass
    public static void reset() {
        LoggingPrintStream.resetInterceptSysOutSysErr();
        PersistenceUtil.cleanUp(context);
    }

    @Before
    public void setUp() throws Exception {
        if (this.pilTestData == null) {
            this.pilTestData = this.createTestProcessInstanceLogData();
            this.vilTestData = this.createTestVariableInstanceLogData();
            this.nilTestData = this.createTestNodeInstanceLogData();
        }
        this.persistenceStrategy = new StandaloneJtaStrategy(emf);
    }

    private long randomLong() {
        long result = Math.abs(random.nextInt());
        while (result == 23L) {
            result = Math.abs(random.nextInt());
        }
        return result;
    }

    private String randomString() {
        return UUID.randomUUID().toString();
    }

    private Calendar randomCal() {
        Calendar cal = GregorianCalendar.getInstance();
        cal.roll(6, -1 * random.nextInt(3650));
        cal.set(14, 0);
        cal.set(13, 0);
        return cal;
    }

    private ProcessInstanceLog[] createTestProcessInstanceLogData() {
        int i;
        StandaloneJtaStrategy jtaHelper = new StandaloneJtaStrategy(emf);
        EntityManager em = jtaHelper.getEntityManager();
        int numEntities = 11;
        ProcessInstanceLog[] testData = new ProcessInstanceLog[numEntities];
        Calendar cal = this.randomCal();
        for (i = 0; i < numEntities; ++i) {
            ProcessInstanceLog pil = new ProcessInstanceLog(this.randomLong(), this.randomString());
            pil.setDuration(Long.valueOf(this.randomLong()));
            pil.setExternalId(this.randomString());
            pil.setIdentity(this.randomString());
            pil.setOutcome(this.randomString());
            pil.setParentProcessInstanceId(this.randomLong());
            pil.setProcessId(this.randomString());
            pil.setProcessName(this.randomString());
            pil.setProcessVersion(this.randomString());
            pil.setStatus(random.nextInt());
            pil.setCorrelationKey(this.randomString());
            cal.add(12, 1);
            pil.setStart(cal.getTime());
            cal.add(6, 1);
            pil.setEnd(cal.getTime());
            testData[i] = pil;
        }
        block13: for (i = 0; i < numEntities; ++i) {
            switch (i) {
                case 1: {
                    testData[i - 1].setDuration(testData[i].getDuration());
                    continue block13;
                }
                case 2: {
                    testData[i - 1].setEnd(testData[i].getEnd());
                    continue block13;
                }
                case 3: {
                    testData[i - 1].setIdentity(testData[i].getIdentity());
                    continue block13;
                }
                case 4: {
                    testData[i - 1].setProcessId(testData[i].getProcessId());
                    continue block13;
                }
                case 5: {
                    testData[i - 1].setProcessInstanceId(testData[i].getProcessInstanceId().longValue());
                    continue block13;
                }
                case 6: {
                    testData[i - 1].setProcessName(testData[i].getProcessName());
                    continue block13;
                }
                case 7: {
                    testData[i - 1].setProcessVersion(testData[i].getProcessVersion());
                    continue block13;
                }
                case 8: {
                    testData[i - 1].setStart(testData[i].getStart());
                    continue block13;
                }
                case 9: {
                    testData[i - 1].setStatus(testData[i].getStatus().intValue());
                    continue block13;
                }
                case 10: {
                    testData[i - 1].setOutcome(testData[i].getOutcome());
                }
            }
        }
        Object tx = jtaHelper.joinTransaction(em);
        for (int i2 = 0; i2 < numEntities; ++i2) {
            em.persist((Object)testData[i2]);
        }
        jtaHelper.leaveTransaction(em, tx);
        return testData;
    }

    @Test
    public void simpleProcessInstanceLogQueryBuilderTest() {
        int p = 0;
        long duration = this.pilTestData[p++].getDuration();
        ProcessInstanceLogQueryBuilder builder = this.processInstanceLogQuery().duration(new long[]{duration});
        List resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"duration query result", (long)2L, (long)resultList.size());
        Date end = this.pilTestData[p++].getEnd();
        builder = this.processInstanceLogQuery().endDate(new Date[]{end});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"end date query result", (long)2L, (long)resultList.size());
        String identity = this.pilTestData[p++].getIdentity();
        builder = this.processInstanceLogQuery().identity(new String[]{identity});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"identity query result", (long)2L, (long)resultList.size());
        String processId = this.pilTestData[p++].getProcessId();
        builder = (ProcessInstanceLogQueryBuilder)this.processInstanceLogQuery().processId(new String[]{processId});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"process id query result", (long)2L, (long)resultList.size());
        long processInstanceId = this.pilTestData[p++].getProcessInstanceId();
        builder = (ProcessInstanceLogQueryBuilder)this.processInstanceLogQuery().processInstanceId(new long[]{processInstanceId});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"process instance id query result", (long)2L, (long)resultList.size());
        String processName = this.pilTestData[p++].getProcessName();
        builder = this.processInstanceLogQuery().processName(new String[]{processName});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"process name query result", (long)2L, (long)resultList.size());
        String version = this.pilTestData[p++].getProcessVersion();
        builder = this.processInstanceLogQuery().processVersion(new String[]{version});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"process version query result", (long)2L, (long)resultList.size());
        Date start = this.pilTestData[p++].getStart();
        builder = this.processInstanceLogQuery().startDate(new Date[]{start});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"start date query result", (long)2L, (long)resultList.size());
        int status = this.pilTestData[p++].getStatus();
        builder = this.processInstanceLogQuery().status(new int[]{status});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"status query result", (long)2L, (long)resultList.size());
        String outcome = this.pilTestData[p++].getOutcome();
        builder = this.processInstanceLogQuery().outcome(new String[]{outcome});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"outcome query result", (long)2L, (long)resultList.size());
        String correlationKey = this.pilTestData[p++].getCorrelationKey();
        CorrelationKey ck = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey(correlationKey);
        builder = this.processInstanceLogQuery().correlationKey(new CorrelationKey[]{ck});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"identity query result", (long)1L, (long)resultList.size());
    }

    private VariableInstanceLog[] createTestVariableInstanceLogData() {
        int i;
        StandaloneJtaStrategy jtaHelper = new StandaloneJtaStrategy(emf);
        EntityManager em = jtaHelper.getEntityManager();
        int numEntities = 8;
        VariableInstanceLog[] testData = new VariableInstanceLog[numEntities];
        Calendar cal = this.randomCal();
        for (i = 0; i < numEntities; ++i) {
            VariableInstanceLog vil = new VariableInstanceLog();
            vil.setProcessInstanceId(this.randomLong());
            vil.setProcessId(this.randomString());
            cal.add(12, 1);
            vil.setDate(cal.getTime());
            vil.setVariableInstanceId(this.randomString());
            vil.setVariableId(this.randomString());
            vil.setValue(this.randomString());
            vil.setOldValue(this.randomString());
            vil.setExternalId(this.randomString());
            testData[i] = vil;
        }
        block10: for (i = 0; i < numEntities; ++i) {
            switch (i) {
                case 1: {
                    testData[i - 1].setDate(testData[i].getDate());
                    continue block10;
                }
                case 2: {
                    testData[i - 1].setOldValue(testData[i].getOldValue());
                    continue block10;
                }
                case 3: {
                    testData[i - 1].setProcessId(testData[i].getProcessId());
                    continue block10;
                }
                case 4: {
                    testData[i - 1].setProcessInstanceId(testData[i].getProcessInstanceId().longValue());
                    continue block10;
                }
                case 5: {
                    testData[i - 1].setValue(testData[i].getValue());
                    continue block10;
                }
                case 6: {
                    testData[i - 1].setVariableId(testData[i].getVariableId());
                    continue block10;
                }
                case 7: {
                    testData[i - 1].setVariableInstanceId(testData[i].getVariableInstanceId());
                }
            }
        }
        Object tx = jtaHelper.joinTransaction(em);
        for (int i2 = 0; i2 < numEntities; ++i2) {
            em.persist((Object)testData[i2]);
        }
        jtaHelper.leaveTransaction(em, tx);
        return testData;
    }

    @Test
    public void simpleVariableInstanceLogQueryBuilderTest() {
        int p = 0;
        Date date = this.vilTestData[p++].getDate();
        VariableInstanceLogQueryBuilder builder = this.variableInstanceLogQuery().date(new Date[]{date});
        List resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"date query result", (long)2L, (long)resultList.size());
        String oldValue = this.vilTestData[p++].getOldValue();
        builder = this.variableInstanceLogQuery().oldValue(new String[]{oldValue});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"old value query result", (long)2L, (long)resultList.size());
        String processId = this.vilTestData[p++].getProcessId();
        builder = (VariableInstanceLogQueryBuilder)this.variableInstanceLogQuery().processId(new String[]{processId});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"process id query result", (long)2L, (long)resultList.size());
        long processInstanceId = this.vilTestData[p++].getProcessInstanceId();
        builder = (VariableInstanceLogQueryBuilder)this.variableInstanceLogQuery().processInstanceId(new long[]{processInstanceId});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"process instance id query result", (long)2L, (long)resultList.size());
        String value = this.vilTestData[p++].getValue();
        builder = this.variableInstanceLogQuery().value(new String[]{value});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"value query result", (long)2L, (long)resultList.size());
        String variableId = this.vilTestData[p++].getVariableId();
        builder = this.variableInstanceLogQuery().variableId(new String[]{variableId});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"variable id query result", (long)2L, (long)resultList.size());
        String varInstId = this.vilTestData[p++].getVariableInstanceId();
        builder = this.variableInstanceLogQuery().variableInstanceId(new String[]{varInstId});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"variable instance id query result", (long)2L, (long)resultList.size());
    }

    private NodeInstanceLog[] createTestNodeInstanceLogData() {
        int i;
        StandaloneJtaStrategy jtaHelper = new StandaloneJtaStrategy(emf);
        EntityManager em = jtaHelper.getEntityManager();
        int numEntities = 9;
        NodeInstanceLog[] testData = new NodeInstanceLog[numEntities];
        Calendar cal = this.randomCal();
        for (i = 0; i < numEntities; ++i) {
            NodeInstanceLog nil = new NodeInstanceLog();
            nil.setProcessInstanceId(this.randomLong());
            nil.setProcessId(this.randomString());
            cal.add(13, 1);
            nil.setDate(cal.getTime());
            nil.setType(Math.abs(random.nextInt()));
            nil.setNodeInstanceId(this.randomString());
            nil.setNodeId(this.randomString());
            nil.setNodeName(this.randomString());
            nil.setNodeType(this.randomString());
            nil.setWorkItemId(Long.valueOf(this.randomLong()));
            nil.setConnection(this.randomString());
            nil.setExternalId(this.randomString());
            testData[i] = nil;
        }
        block11: for (i = 0; i < numEntities; ++i) {
            switch (i) {
                case 1: {
                    testData[i - 1].setDate(testData[i].getDate());
                    continue block11;
                }
                case 2: {
                    testData[i - 1].setNodeId(testData[i].getNodeId());
                    continue block11;
                }
                case 3: {
                    testData[i - 1].setNodeInstanceId(testData[i].getNodeInstanceId());
                    continue block11;
                }
                case 4: {
                    testData[i - 1].setNodeName(testData[i].getNodeName());
                    continue block11;
                }
                case 5: {
                    testData[i - 1].setNodeType(testData[i].getNodeType());
                    continue block11;
                }
                case 6: {
                    testData[i - 1].setProcessId(testData[i].getProcessId());
                    continue block11;
                }
                case 7: {
                    testData[i - 1].setProcessInstanceId(testData[i].getProcessInstanceId().longValue());
                    continue block11;
                }
                case 8: {
                    testData[i - 1].setWorkItemId(testData[i].getWorkItemId());
                }
            }
        }
        Object tx = jtaHelper.joinTransaction(em);
        for (int i2 = 0; i2 < numEntities; ++i2) {
            em.persist((Object)testData[i2]);
        }
        jtaHelper.leaveTransaction(em, tx);
        return testData;
    }

    @Test
    public void simpleNodeInstanceLogQueryBuilderTest() {
        int p = 0;
        Date date = this.nilTestData[p++].getDate();
        NodeInstanceLogQueryBuilder builder = this.nodeInstanceLogQuery().date(new Date[]{date});
        List resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"date query result", (long)2L, (long)resultList.size());
        String nodeId = this.nilTestData[p++].getNodeId();
        builder = this.nodeInstanceLogQuery().nodeId(new String[]{nodeId});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"node id query result", (long)2L, (long)resultList.size());
        String nodeInstId = this.nilTestData[p++].getNodeInstanceId();
        builder = this.nodeInstanceLogQuery().nodeInstanceId(new String[]{nodeInstId});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"node instance id query result", (long)2L, (long)resultList.size());
        String name = this.nilTestData[p++].getNodeName();
        builder = this.nodeInstanceLogQuery().nodeName(new String[]{name});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"node name query result", (long)2L, (long)resultList.size());
        String nodeType = this.nilTestData[p++].getNodeType();
        builder = this.nodeInstanceLogQuery().nodeType(new String[]{nodeType});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"node type query result", (long)2L, (long)resultList.size());
        String processId = this.nilTestData[p++].getProcessId();
        builder = (NodeInstanceLogQueryBuilder)this.nodeInstanceLogQuery().processId(new String[]{processId});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"process id query result", (long)2L, (long)resultList.size());
        long processInstanceId = this.nilTestData[p++].getProcessInstanceId();
        builder = (NodeInstanceLogQueryBuilder)this.nodeInstanceLogQuery().processInstanceId(new long[]{processInstanceId});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"process instance id query result", (long)2L, (long)resultList.size());
        long workItemId = this.nilTestData[p++].getWorkItemId();
        builder = this.nodeInstanceLogQuery().workItemId(new long[]{workItemId});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"work item id query result", (long)2L, (long)resultList.size());
        int maxResults = 5;
        resultList = this.nodeInstanceLogQuery().buildQuery().getResultList();
        Assert.assertTrue((String)"Not enough to do pagination test", (resultList.size() > maxResults ? 1 : 0) != 0);
        resultList = ((NodeInstanceLogQueryBuilder)this.nodeInstanceLogQuery().maxResults(maxResults)).orderBy(NodeInstanceLogQueryBuilder.OrderBy.processInstanceId).buildQuery().getResultList();
        Assert.assertTrue((String)("Only expected" + maxResults + " results, not " + resultList.size()), (resultList.size() <= 5 ? 1 : 0) != 0);
        int offset = 3;
        List newResultList = ((NodeInstanceLogQueryBuilder)((NodeInstanceLogQueryBuilder)this.nodeInstanceLogQuery().maxResults(maxResults)).offset(offset)).orderBy(NodeInstanceLogQueryBuilder.OrderBy.processInstanceId).buildQuery().getResultList();
        Assert.assertTrue((String)("Only expected" + maxResults + " results, not " + newResultList.size()), (newResultList.size() <= 5 ? 1 : 0) != 0);
        Assert.assertEquals((String)("Offset should have been " + offset + ": " + ((org.kie.api.runtime.manager.audit.NodeInstanceLog)resultList.get(offset)).getProcessInstanceId() + " != " + ((org.kie.api.runtime.manager.audit.NodeInstanceLog)newResultList.get(0)).getProcessInstanceId()), (Object)((org.kie.api.runtime.manager.audit.NodeInstanceLog)resultList.get(offset)).getProcessInstanceId(), (Object)((org.kie.api.runtime.manager.audit.NodeInstanceLog)newResultList.get(0)).getProcessInstanceId());
    }

    @Test
    public void unionQueryBuilderTest() {
        ProcessInstanceLogQueryBuilder builder = this.processInstanceLogQuery();
        builder.duration(new long[]{this.pilTestData[4].getDuration()});
        List resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"duration result", (long)1L, (long)resultList.size());
        builder.endDate(new Date[]{this.pilTestData[5].getEnd(), this.pilTestData[6].getEnd()});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"union: duration OR end result", (long)3L, (long)resultList.size());
        builder.identity(new String[]{this.pilTestData[7].getIdentity(), this.pilTestData[8].getIdentity()});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"union: duration OR end OR identity result", (long)5L, (long)resultList.size());
    }

    @Test
    public void intersectQueryBuilderTest() {
        ProcessInstanceLogQueryBuilder builder = this.processInstanceLogQuery();
        builder.intersect();
        builder.duration(new long[]{this.pilTestData[4].getDuration()});
        List resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"duration result", (long)1L, (long)resultList.size());
        builder.endDate(new Date[]{this.pilTestData[5].getEnd()});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"intersect: duration AND end result", (long)0L, (long)resultList.size());
        builder.identity(new String[]{this.pilTestData[6].getIdentity()});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"intersect: duration AND end AND identity result", (long)0L, (long)resultList.size());
    }

    @Test
    public void intersectUnionQueryBuilderTest() {
        ProcessInstanceLogQueryBuilder builder = this.processInstanceLogQuery();
        builder.duration(new long[]{this.pilTestData[0].getDuration(), this.pilTestData[2].getDuration()});
        builder.intersect();
        List resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"duration result", (long)3L, (long)resultList.size());
        builder.endDate(new Date[]{this.pilTestData[0].getEnd()});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"intersect: duration AND end result", (long)1L, (long)resultList.size());
        builder.union();
        builder.processId(new String[]{this.pilTestData[10].getProcessId()});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"intersect/union: duration AND end OR processId result", (long)2L, (long)resultList.size());
    }

    @Test
    public void likeRegexQueryBuilderTest() {
        ProcessInstanceLogQueryBuilder builder = this.processInstanceLogQuery();
        builder.like();
        boolean parameterFailed = false;
        try {
            builder.duration(new long[]{this.pilTestData[0].getDuration(), this.pilTestData[2].getDuration()});
        }
        catch (Exception e) {
            parameterFailed = true;
        }
        Assert.assertTrue((String)"adding critera should have failed because of like()", (boolean)parameterFailed);
        String regex = this.pilTestData[0].getIdentity();
        builder.identity(new String[]{regex});
        List resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"literal regex identity result", (long)1L, (long)resultList.size());
        String externalId = ((org.kie.api.runtime.manager.audit.ProcessInstanceLog)resultList.get(0)).getExternalId();
        builder = this.processInstanceLogQuery();
        regex = regex.substring(0, regex.length() - 1) + ".";
        ((ProcessInstanceLogQueryBuilder)builder.like()).identity(new String[]{regex});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"literal regex identity result", (long)1L, (long)resultList.size());
        Assert.assertEquals((Object)externalId, (Object)((org.kie.api.runtime.manager.audit.ProcessInstanceLog)resultList.get(0)).getExternalId());
        builder = this.processInstanceLogQuery();
        regex = regex.substring(0, 10) + "*";
        ((ProcessInstanceLogQueryBuilder)builder.like()).identity(new String[]{regex});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"literal regex identity result", (long)1L, (long)resultList.size());
        Assert.assertEquals((Object)externalId, (Object)((org.kie.api.runtime.manager.audit.ProcessInstanceLog)resultList.get(0)).getExternalId());
        builder = this.processInstanceLogQuery();
        String regex2 = "*" + this.pilTestData[0].getIdentity().substring(10);
        ((ProcessInstanceLogQueryBuilder)((ProcessInstanceLogQueryBuilder)builder.like()).intersect()).identity(new String[]{regex, regex2});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"literal regex identity result", (long)1L, (long)resultList.size());
        Assert.assertEquals((Object)externalId, (Object)((org.kie.api.runtime.manager.audit.ProcessInstanceLog)resultList.get(0)).getExternalId());
        builder = this.processInstanceLogQuery();
        regex2 = "*" + this.pilTestData[5].getIdentity().substring(10);
        ((ProcessInstanceLogQueryBuilder)((ProcessInstanceLogQueryBuilder)builder.like()).intersect()).identity(new String[]{regex, regex2});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"literal regex identity result", (long)0L, (long)resultList.size());
        builder = this.processInstanceLogQuery();
        ((ProcessInstanceLogQueryBuilder)((ProcessInstanceLogQueryBuilder)builder.like()).union()).identity(new String[]{regex, regex2});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"literal regex identity result", (long)2L, (long)resultList.size());
        builder = this.processInstanceLogQuery();
        ((ProcessInstanceLogQueryBuilder)((ProcessInstanceLogQueryBuilder)builder.like()).union()).identity(new String[]{"*"});
        resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"literal regex identity result", (long)this.processInstanceLogQuery().buildQuery().getResultList().size(), (long)resultList.size());
    }

    @Test
    public void rangeQueryBuilderTest() {
        ProcessInstanceLogQueryBuilder builder = this.processInstanceLogQuery();
        long duration = this.pilTestData[5].getDuration();
        ((ProcessInstanceLogQueryBuilder)builder.intersect()).durationMin(duration - 1L).durationMax(duration + 1L);
        List resultList = builder.buildQuery().getResultList();
        Assert.assertEquals((String)"duration min + max result", (long)1L, (long)resultList.size());
        List durationOrderedProcInstLogList = this.processInstanceLogQuery().buildQuery().getResultList();
        Collections.sort(durationOrderedProcInstLogList, new Comparator<org.kie.api.runtime.manager.audit.ProcessInstanceLog>(){

            @Override
            public int compare(org.kie.api.runtime.manager.audit.ProcessInstanceLog o1, org.kie.api.runtime.manager.audit.ProcessInstanceLog o2) {
                return o1.getDuration().compareTo(o2.getDuration());
            }
        });
        int lastElemIndex = durationOrderedProcInstLogList.size() - 1;
        builder = this.processInstanceLogQuery();
        long max = ((org.kie.api.runtime.manager.audit.ProcessInstanceLog)durationOrderedProcInstLogList.get(0)).getDuration();
        builder.durationMax(max);
        resultList = builder.buildQuery().getResultList();
        this.verifyMaxMinDuration(resultList, MAX, max);
        builder = this.processInstanceLogQuery();
        long min = ((org.kie.api.runtime.manager.audit.ProcessInstanceLog)durationOrderedProcInstLogList.get(lastElemIndex)).getDuration();
        builder.durationMin(min);
        resultList = builder.buildQuery().getResultList();
        duration = ((org.kie.api.runtime.manager.audit.ProcessInstanceLog)resultList.get(0)).getDuration();
        this.verifyMaxMinDuration(resultList, MIN, min);
        builder = this.processInstanceLogQuery();
        min = ((org.kie.api.runtime.manager.audit.ProcessInstanceLog)durationOrderedProcInstLogList.get(lastElemIndex)).getDuration();
        builder.durationMin(min);
        max = ((org.kie.api.runtime.manager.audit.ProcessInstanceLog)durationOrderedProcInstLogList.get(0)).getDuration();
        builder.durationMax(max);
        resultList = builder.buildQuery().getResultList();
        for (org.kie.api.runtime.manager.audit.ProcessInstanceLog log : resultList) {
            long dur = log.getDuration();
            Assert.assertTrue((String)("Duration " + dur + " is neither larger than min + " + min + " nor smaller than max" + max), (dur >= min || dur <= max ? 1 : 0) != 0);
        }
        builder = (ProcessInstanceLogQueryBuilder)this.processInstanceLogQuery().intersect();
        min = ((org.kie.api.runtime.manager.audit.ProcessInstanceLog)durationOrderedProcInstLogList.get(lastElemIndex)).getDuration();
        builder.durationMin(min);
        max = ((org.kie.api.runtime.manager.audit.ProcessInstanceLog)durationOrderedProcInstLogList.get(0)).getDuration();
        builder.durationMax(max);
        resultList = builder.buildQuery().getResultList();
        this.verifyMaxMinDuration(resultList, BOTH, min, max);
        builder = (ProcessInstanceLogQueryBuilder)this.processInstanceLogQuery().intersect();
        min = ((org.kie.api.runtime.manager.audit.ProcessInstanceLog)durationOrderedProcInstLogList.get(2)).getDuration();
        max = ((org.kie.api.runtime.manager.audit.ProcessInstanceLog)durationOrderedProcInstLogList.get(3)).getDuration();
        builder.durationMin(min);
        builder.durationMax(max);
        resultList = builder.buildQuery().getResultList();
        this.verifyMaxMinDuration(resultList, BOTH, min, max);
    }

    private void verifyMaxMinDuration(List<org.kie.api.runtime.manager.audit.ProcessInstanceLog> procInstLogs, int test, long ... maxOrMin) {
        for (org.kie.api.runtime.manager.audit.ProcessInstanceLog log : procInstLogs) {
            Assert.assertNotNull((String)"Duration is null", (Object)log.getDuration());
            long dur = log.getDuration();
            if (test == MAX) {
                Assert.assertTrue((String)("Duration " + dur + " is larger than max " + maxOrMin[0] + ": " + dur), (dur <= maxOrMin[0] ? 1 : 0) != 0);
                continue;
            }
            if (test == MIN) {
                Assert.assertTrue((String)("Duration " + dur + " is smaller than min " + maxOrMin[0]), (dur >= maxOrMin[0] ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)("Duration " + dur + " is smaller than min " + maxOrMin[0]), (dur >= maxOrMin[0] ? 1 : 0) != 0);
            Assert.assertTrue((String)("Duration " + dur + " is larger than max " + maxOrMin[1]), (dur <= maxOrMin[1] ? 1 : 0) != 0);
        }
    }

    @Test
    public void orderByQueryBuilderTest() {
        ProcessInstanceLog pilA;
        ProcessInstanceLog pilB;
        int i;
        ProcessInstanceLogQueryBuilder builder = this.processInstanceLogQuery();
        List resultList = builder.buildQuery().getResultList();
        for (i = 1; i < resultList.size(); ++i) {
            pilB = (ProcessInstanceLog)resultList.get(i);
            pilA = (ProcessInstanceLog)resultList.get(i - 1);
            Assert.assertTrue((pilA.getId() < pilB.getId() ? 1 : 0) != 0);
        }
        builder.orderBy(ProcessInstanceLogQueryBuilder.OrderBy.processInstanceId);
        resultList = builder.buildQuery().getResultList();
        for (i = 1; i < resultList.size(); ++i) {
            pilB = (ProcessInstanceLog)resultList.get(i);
            pilA = (ProcessInstanceLog)resultList.get(i - 1);
            Assert.assertTrue((String)("order by process instance id failed:  " + pilA.getProcessInstanceId() + " ? " + pilB.getProcessInstanceId()), (pilA.getProcessInstanceId() <= pilB.getProcessInstanceId() ? 1 : 0) != 0);
        }
        builder.descending();
        resultList = builder.buildQuery().getResultList();
        for (i = 1; i < resultList.size(); ++i) {
            pilB = (ProcessInstanceLog)resultList.get(i);
            pilA = (ProcessInstanceLog)resultList.get(i - 1);
            Assert.assertTrue((String)"order desc by process instance id failed", (pilA.getProcessInstanceId() >= pilB.getProcessInstanceId() ? 1 : 0) != 0);
        }
        builder.orderBy(ProcessInstanceLogQueryBuilder.OrderBy.processId).ascending();
        resultList = builder.buildQuery().getResultList();
        for (i = 1; i < resultList.size(); ++i) {
            ProcessInstanceLog pilA2 = (ProcessInstanceLog)resultList.get(i - 1);
            ProcessInstanceLog pilB2 = (ProcessInstanceLog)resultList.get(i);
            Assert.assertTrue((String)"order desc by process id failed", (pilA2.getProcessId().compareTo(pilB2.getProcessId()) <= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void lastVariableTest() throws Exception {
        StandaloneJtaStrategy jtaHelper = new StandaloneJtaStrategy(emf);
        EntityManager em = jtaHelper.getEntityManager();
        int numLogs = 10;
        VariableInstanceLog[] testData = new VariableInstanceLog[numLogs];
        Calendar cal = GregorianCalendar.getInstance();
        for (int i = 0; i < 5; ++i) {
            cal.roll(13, 1);
            testData[i] = new VariableInstanceLog(23L, "org.lots.of.vars", "inst", "first-var", "val-a", "oldVal-" + i);
            testData[i + 5] = new VariableInstanceLog(23L, "org.lots.of.vars", "inst", "second-var", "val-b", "oldVal-" + i);
            testData[i].setDate(cal.getTime());
            testData[i + 5].setDate(cal.getTime());
        }
        Object tx = jtaHelper.joinTransaction(em);
        for (int i = 0; i < numLogs; ++i) {
            em.persist((Object)testData[i]);
        }
        jtaHelper.leaveTransaction(em, tx);
        VariableInstanceLogQueryBuilder queryBuilder = this.variableInstanceLogQuery();
        ParametrizedQuery query = ((VariableInstanceLogQueryBuilder)queryBuilder.last().processInstanceId(new long[]{23L})).buildQuery();
        List logs = query.getResultList();
        Assert.assertEquals((String)"2 logs expected", (long)2L, (long)logs.size());
        queryBuilder = this.variableInstanceLogQuery();
        query = queryBuilder.value(new String[]{"val-a"}).last().buildQuery();
        logs = query.getResultList();
        Assert.assertEquals((String)"Only 1 log expected", (long)1L, (long)logs.size());
        Assert.assertEquals((String)"Incorrect variable val", (Object)"val-a", (Object)((org.kie.api.runtime.manager.audit.VariableInstanceLog)logs.get(0)).getValue());
        Assert.assertEquals((String)"Incorrect variable old val", (Object)"oldVal-4", (Object)((org.kie.api.runtime.manager.audit.VariableInstanceLog)logs.get(0)).getOldValue());
    }

    @Test
    public void variableValueTest() throws Exception {
        String id;
        StandaloneJtaStrategy jtaHelper = new StandaloneJtaStrategy(emf);
        EntityManager em = jtaHelper.getEntityManager();
        int numLogs = 9;
        VariableInstanceLog[] testData = new VariableInstanceLog[numLogs];
        Calendar cal = GregorianCalendar.getInstance();
        String processId = "org.variable.value";
        for (int i = 0; i < testData.length; ++i) {
            cal.roll(13, 1);
            testData[i] = new VariableInstanceLog(this.randomLong(), processId, "varInstId", "var-" + i, "val-" + i, "oldVal-" + i);
        }
        Object tx = jtaHelper.joinTransaction(em);
        for (int i = 0; i < numLogs; ++i) {
            em.persist((Object)testData[i]);
        }
        jtaHelper.leaveTransaction(em, tx);
        VariableInstanceLogQueryBuilder queryBuilder = this.variableInstanceLogQuery();
        ParametrizedQuery query = ((VariableInstanceLogQueryBuilder)queryBuilder.processId(new String[]{processId})).buildQuery();
        List logs = query.getResultList();
        Assert.assertEquals((String)(numLogs + " logs expected"), (long)numLogs, (long)logs.size());
        queryBuilder = (VariableInstanceLogQueryBuilder)((VariableInstanceLogQueryBuilder)this.variableInstanceLogQuery().intersect()).processId(new String[]{processId});
        query = queryBuilder.variableValue("var-1", "val-2").buildQuery();
        logs = query.getResultList();
        Assert.assertEquals((String)"No logs expected", (long)0L, (long)logs.size());
        queryBuilder = (VariableInstanceLogQueryBuilder)((VariableInstanceLogQueryBuilder)this.variableInstanceLogQuery().intersect()).processId(new String[]{processId});
        query = queryBuilder.variableValue("var-1", "val-1").variableValue("var-2", "val-2").buildQuery();
        logs = query.getResultList();
        Assert.assertEquals((String)"No logs expected", (long)0L, (long)logs.size());
        queryBuilder = this.variableInstanceLogQuery();
        query = ((VariableInstanceLogQueryBuilder)queryBuilder.union()).variableValue("var-1", "val-1").buildQuery();
        logs = query.getResultList();
        Assert.assertEquals((String)"1 log expected", (long)1L, (long)logs.size());
        Assert.assertEquals((String)"Incorrect variable val", (Object)"val-1", (Object)((org.kie.api.runtime.manager.audit.VariableInstanceLog)logs.get(0)).getValue());
        Assert.assertEquals((String)"Incorrect variable id", (Object)"var-1", (Object)((org.kie.api.runtime.manager.audit.VariableInstanceLog)logs.get(0)).getVariableId());
        queryBuilder = this.variableInstanceLogQuery();
        query = ((VariableInstanceLogQueryBuilder)queryBuilder.union()).variableValue("var-2", "val-2").variableValue("var-4", "val-4").buildQuery();
        logs = query.getResultList();
        Assert.assertEquals((String)"2 log expected", (long)2L, (long)logs.size());
        for (org.kie.api.runtime.manager.audit.VariableInstanceLog varLog : logs) {
            id = varLog.getVariableId().substring("var-".length());
            Assert.assertEquals((String)"variable value", (Object)("val-" + id), (Object)varLog.getValue());
        }
        queryBuilder = this.variableInstanceLogQuery();
        query = ((VariableInstanceLogQueryBuilder)queryBuilder.like()).variableValue("var-2", "val-*").buildQuery();
        logs = query.getResultList();
        Assert.assertEquals((String)"1 log expected", (long)1L, (long)logs.size());
        Assert.assertEquals((String)"Incorrect variable val", (Object)"val-2", (Object)((org.kie.api.runtime.manager.audit.VariableInstanceLog)logs.get(0)).getValue());
        Assert.assertEquals((String)"Incorrect variable id", (Object)"var-2", (Object)((org.kie.api.runtime.manager.audit.VariableInstanceLog)logs.get(0)).getVariableId());
        queryBuilder = this.variableInstanceLogQuery();
        query = ((VariableInstanceLogQueryBuilder)((VariableInstanceLogQueryBuilder)queryBuilder.like()).union()).variableValue("var-2", "val-*").variableValue("var-3", "val-*").buildQuery();
        logs = query.getResultList();
        Assert.assertEquals((String)"2 log expected", (long)2L, (long)logs.size());
        for (org.kie.api.runtime.manager.audit.VariableInstanceLog varLog : logs) {
            id = varLog.getVariableId().substring("var-".length());
            Assert.assertEquals((String)"variable value", (Object)("val-" + id), (Object)varLog.getValue());
        }
        queryBuilder = this.variableInstanceLogQuery();
        query = ((VariableInstanceLogQueryBuilder)((VariableInstanceLogQueryBuilder)((VariableInstanceLogQueryBuilder)queryBuilder.like()).union()).variableValue("var-2", "val-*").variableValue("var-3", "val-*").equals()).last().buildQuery();
        logs = query.getResultList();
        Assert.assertEquals((String)"2 log expected", (long)2L, (long)logs.size());
        for (org.kie.api.runtime.manager.audit.VariableInstanceLog varLog : logs) {
            id = varLog.getVariableId().substring("var-".length());
            Assert.assertEquals((String)"variable value", (Object)("val-" + id), (Object)varLog.getValue());
        }
    }

    static {
        logger = LoggerFactory.getLogger(AuditLogServiceTest.class);
        random = new Random();
        MAX = 2;
        MIN = 1;
        BOTH = 0;
    }
}

