/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.query;

import java.util.Date;
import java.util.List;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.query.AbstractAuditQueryBuilderImpl;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.query.ParametrizedQuery;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.query.data.QueryData;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogQueryBuilder;

public class ProcInstLogQueryBuilderImpl
extends AbstractAuditQueryBuilderImpl<ProcessInstanceLogQueryBuilder>
implements ProcessInstanceLogQueryBuilder {
    public ProcInstLogQueryBuilderImpl(CommandExecutor cmdExecutor) {
        super(cmdExecutor);
    }

    public ProcInstLogQueryBuilderImpl(JPAAuditLogService jpaAuditService) {
        super(jpaAuditService);
    }

    public ProcessInstanceLogQueryBuilder status(int ... status) {
        this.addIntParameter(QueryParameterIdentifiers.PROCESS_INSTANCE_STATUS_LIST, "status", status);
        return this;
    }

    public ProcessInstanceLogQueryBuilder duration(long ... duration) {
        this.addLongParameter(QueryParameterIdentifiers.DURATION_LIST, "duration", duration);
        return this;
    }

    public ProcessInstanceLogQueryBuilder durationMin(long durationMin) {
        this.addRangeParameter(QueryParameterIdentifiers.DURATION_LIST, "duration min", durationMin, true);
        return this;
    }

    public ProcessInstanceLogQueryBuilder durationMax(long durationMax) {
        this.addRangeParameter(QueryParameterIdentifiers.DURATION_LIST, "duration max", durationMax, false);
        return this;
    }

    public ProcessInstanceLogQueryBuilder identity(String ... identity) {
        this.addObjectParameter(QueryParameterIdentifiers.IDENTITY_LIST, "identity", identity);
        return this;
    }

    public ProcessInstanceLogQueryBuilder processVersion(String ... version) {
        this.addObjectParameter(QueryParameterIdentifiers.PROCESS_VERSION_LIST, "process version", version);
        return this;
    }

    public ProcessInstanceLogQueryBuilder processName(String ... processName) {
        this.addObjectParameter(QueryParameterIdentifiers.PROCESS_NAME_LIST, "process name", processName);
        return this;
    }

    public ProcessInstanceLogQueryBuilder startDate(Date ... date) {
        this.addObjectParameter(QueryParameterIdentifiers.START_DATE_LIST, "start date", date);
        return this;
    }

    public ProcessInstanceLogQueryBuilder startDateRangeStart(Date rangeStart) {
        this.addRangeParameter(QueryParameterIdentifiers.START_DATE_LIST, "start date range, start", rangeStart, true);
        return this;
    }

    public ProcessInstanceLogQueryBuilder startDateRangeEnd(Date rangeEnd) {
        this.addRangeParameter(QueryParameterIdentifiers.START_DATE_LIST, "start date range, end", rangeEnd, false);
        return this;
    }

    public ProcessInstanceLogQueryBuilder endDate(Date ... date) {
        this.addObjectParameter(QueryParameterIdentifiers.END_DATE_LIST, "end date", date);
        return this;
    }

    public ProcessInstanceLogQueryBuilder endDateRangeStart(Date rangeStart) {
        this.addRangeParameter(QueryParameterIdentifiers.END_DATE_LIST, "end date range, start", rangeStart, true);
        return this;
    }

    public ProcessInstanceLogQueryBuilder endDateRangeEnd(Date rangeEnd) {
        this.addRangeParameter(QueryParameterIdentifiers.END_DATE_LIST, "end date range, end", rangeEnd, false);
        return this;
    }

    public ProcessInstanceLogQueryBuilder outcome(String ... outcome) {
        this.addObjectParameter(QueryParameterIdentifiers.OUTCOME_LIST, "outcome", outcome);
        return this;
    }

    public ProcessInstanceLogQueryBuilder correlationKey(CorrelationKey ... correlationKeys) {
        Object[] correlationKeysExternal = new String[correlationKeys.length];
        for (int i = 0; i < correlationKeys.length; ++i) {
            correlationKeysExternal[i] = correlationKeys[i].toExternalForm();
        }
        this.addObjectParameter(QueryParameterIdentifiers.CORRELATION_KEY_LIST, "correlation key", correlationKeysExternal);
        return this;
    }

    public ProcessInstanceLogQueryBuilder orderBy(ProcessInstanceLogQueryBuilder.OrderBy field) {
        this.queryData.getQueryContext().setOrderBy(field.toString());
        return this;
    }

    public ParametrizedQuery<ProcessInstanceLog> buildQuery() {
        return new ParametrizedQuery<ProcessInstanceLog>(){
            private QueryData queryData;
            {
                this.queryData = new QueryData(ProcInstLogQueryBuilderImpl.this.getQueryData());
            }

            public List<ProcessInstanceLog> getResultList() {
                return ProcInstLogQueryBuilderImpl.this.getJpaAuditLogService().queryProcessInstanceLogs(this.queryData);
            }
        };
    }
}

