/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.HashMap;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.audit.AbstractAuditLogServiceTest;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.audit.CommandBasedAuditLogService;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.KnowledgeBase;

public class CommandBasedAuditLogServiceTest
extends AbstractAuditLogServiceTest {
    private HashMap<String, Object> context;
    private KieSession session;
    private AuditLogService auditLogService;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        KnowledgeBase kbase = CommandBasedAuditLogServiceTest.createKnowledgeBase();
        Environment env = PersistenceUtil.createEnvironment(this.context);
        this.session = CommandBasedAuditLogServiceTest.createKieSession((KieBase)kbase, env);
        AbstractAuditLogger dblogger = AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)this.session, null);
        Assert.assertNotNull((Object)dblogger);
        Assert.assertTrue((boolean)(dblogger instanceof JPAWorkingMemoryDbLogger));
        this.auditLogService = new CommandBasedAuditLogService((CommandExecutor)this.session);
    }

    @After
    public void tearDown() throws Exception {
        this.session.dispose();
        this.session = null;
        this.auditLogService = null;
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testLogger1() throws Exception {
        CommandBasedAuditLogServiceTest.runTestLogger1(this.session, this.auditLogService);
    }

    @Test
    public void testLogger2() {
        CommandBasedAuditLogServiceTest.runTestLogger2(this.session, this.auditLogService);
    }

    @Test
    public void testLogger3() {
        CommandBasedAuditLogServiceTest.runTestLogger3(this.session, this.auditLogService);
    }

    @Test
    public void testLogger4() throws Exception {
        CommandBasedAuditLogServiceTest.runTestLogger4(this.session, this.auditLogService);
    }

    @Test
    public void testLogger4LargeVariable() throws Exception {
        CommandBasedAuditLogServiceTest.runTestLogger4LargeVariable(this.session, this.auditLogService);
    }

    @Test
    public void testLogger5() throws Exception {
        CommandBasedAuditLogServiceTest.runTestLogger5(this.session, this.auditLogService);
    }

    @Test
    public void runTestLogger4WithCustomVariableIndexer() throws Exception {
        CommandBasedAuditLogServiceTest.runTestLogger4WithCustomVariableIndexer(this.session, this.auditLogService);
    }
}

