/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.HashMap;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.audit.AbstractAuditLogServiceTest;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogServiceTest
extends AbstractAuditLogServiceTest {
    private HashMap<String, Object> context;
    private static final Logger logger = LoggerFactory.getLogger(AuditLogServiceTest.class);
    private KieSession session;
    private AuditLogService auditLogService;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        KieBase kbase = AuditLogServiceTest.createKnowledgeBase();
        Environment env = PersistenceUtil.createEnvironment(this.context);
        try {
            this.session = AuditLogServiceTest.createKieSession(kbase, env);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)"Exception thrown while trying to create a session.");
        }
        AbstractAuditLogger dblogger = AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)this.session, null);
        Assert.assertNotNull((Object)dblogger);
        Assert.assertTrue((boolean)(dblogger instanceof JPAWorkingMemoryDbLogger));
        this.auditLogService = new JPAAuditLogService(env);
    }

    @After
    public void tearDown() throws Exception {
        if (this.session != null) {
            this.session.dispose();
        }
        this.session = null;
        this.auditLogService = null;
        PersistenceUtil.cleanUp(this.context);
        System.clearProperty("org.jbpm.var.log.length");
    }

    @Test
    public void testLogger1() throws Exception {
        AuditLogServiceTest.runTestLogger1(this.session, this.auditLogService);
    }

    @Test
    public void testLogger2() {
        AuditLogServiceTest.runTestLogger2(this.session, this.auditLogService);
    }

    @Test
    public void testLogger3() {
        AuditLogServiceTest.runTestLogger3(this.session, this.auditLogService);
    }

    @Test
    public void testLogger4() throws Exception {
        AuditLogServiceTest.runTestLogger4(this.session, this.auditLogService);
    }

    @Test
    public void testLogger4LargeVariable() throws Exception {
        AuditLogServiceTest.runTestLogger4LargeVariable(this.session, this.auditLogService);
    }

    @Test
    public void testLogger5() throws Exception {
        AuditLogServiceTest.runTestLogger5(this.session, this.auditLogService);
    }

    @Test
    public void testLoggerWithCustomVariableLogLength() throws Exception {
        AuditLogServiceTest.runTestLoggerWithCustomVariableLogLength(this.session, this.auditLogService);
    }

    @Test
    public void runTestLogger4WithCustomVariableIndexer() throws Exception {
        AuditLogServiceTest.runTestLogger4WithCustomVariableIndexer(this.session, this.auditLogService);
    }
}

