/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.Date;
import javax.persistence.EntityManager;
import org.jbpm.process.audit.ArchiveLoggerProvider;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArchiveLoggerProvider
implements ArchiveLoggerProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultArchiveLoggerProvider.class);

    @Override
    public void archive(EntityManager em, ProcessInstanceLog log) {
        long pid = log.getProcessInstanceId();
        Date endDate = log.getEnd();
        int count = em.createQuery("UPDATE NodeInstanceLog o SET o.end = :endDate WHERE o.processInstanceId = :pid").setParameter("pid", (Object)pid).setParameter("endDate", (Object)endDate).executeUpdate();
        logger.debug("Archived {} node instances log for process instance id {}", (Object)count, (Object)pid);
        count = em.createQuery("UPDATE VariableInstanceLog o SET o.end = :endDate WHERE o.processInstanceId = :pid").setParameter("pid", (Object)pid).setParameter("endDate", (Object)endDate).executeUpdate();
        logger.debug("Archived {} variable instances log for process instance id {}", (Object)count, (Object)pid);
    }
}

