/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.iterable.ThrowingExtractor;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.io.impl.ClassPathResource;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.util.AbstractBaseTest;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuditLogServiceTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAuditLogServiceTest.class);

    public static KieBase createKnowledgeBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("ruleflow.rf"), ResourceType.DRF);
        kbuilder.add((Resource)new ClassPathResource("ruleflow2.rf"), ResourceType.DRF);
        kbuilder.add((Resource)new ClassPathResource("ruleflow3.rf"), ResourceType.DRF);
        kbuilder.add((Resource)new ClassPathResource("ruleflow4.rf"), ResourceType.DRF);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    public static KieSession createKieSession(KieBase kbase, Environment env) {
        Properties properties = new Properties();
        properties.put("drools.processInstanceManagerFactory", "org.jbpm.persistence.processinstance.JPAProcessInstanceManagerFactory");
        properties.put("drools.processSignalManagerFactory", "org.jbpm.persistence.processinstance.JPASignalManagerFactory");
        KieSessionConfiguration config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration((Properties)properties);
        StatefulKnowledgeSession session = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)config, (Environment)env);
        return session;
    }

    public static void runTestLogger1(KieSession session, AuditLogService auditLogService) throws Exception {
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        int initialProcessInstanceSize = processInstances.size();
        long processInstanceId = session.startProcess("com.sample.ruleflow").getId();
        logger.debug("Checking process instances for process 'com.sample.ruleflow'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        Assertions.assertThat((int)processInstances.size()).isEqualTo(initialProcessInstanceSize + 1);
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assertions.assertThat((Date)processInstance.getStart()).isNotNull();
        ((AbstractDateAssert)Assertions.assertThat((Date)processInstance.getEnd()).isNotNull()).withFailMessage("ProcessInstanceLog does not contain end date.", new Object[0]);
        Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
        Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow");
        List nodeInstances = auditLogService.findNodeInstances(processInstanceId);
        Assertions.assertThat((int)nodeInstances.size()).isEqualTo(6);
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            logger.debug(nodeInstance.toString());
            Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
            Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow");
            Assertions.assertThat((Date)nodeInstance.getDate()).isNotNull();
        }
        auditLogService.clear();
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        Assertions.assertThat((List)processInstances).isEmpty();
    }

    public static void runTestLogger2(KieSession session, AuditLogService auditLogService) {
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        int initialProcessInstanceSize = processInstances.size();
        session.startProcess("com.sample.ruleflow");
        session.startProcess("com.sample.ruleflow");
        logger.debug("Checking process instances for process 'com.sample.ruleflow'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        Assertions.assertThat((int)processInstances.size()).isEqualTo(initialProcessInstanceSize + 2);
        for (ProcessInstanceLog processInstance : processInstances) {
            logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
            List nodeInstances = auditLogService.findNodeInstances(processInstance.getProcessInstanceId().longValue());
            for (NodeInstanceLog nodeInstance : nodeInstances) {
                logger.debug("{} -> {}", (Object)nodeInstance.toString(), (Object)nodeInstance.getDate());
            }
            Assertions.assertThat((int)nodeInstances.size()).isEqualTo(6);
        }
        auditLogService.clear();
    }

    public static void runTestLogger3(KieSession session, AuditLogService auditLogService) {
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        int initialProcessInstanceSize = processInstances.size();
        long processInstanceId = session.startProcess("com.sample.ruleflow2").getId();
        logger.debug("Checking process instances for process 'com.sample.ruleflow2'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow2");
        Assertions.assertThat((int)processInstances.size()).isEqualTo(initialProcessInstanceSize + 1);
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assertions.assertThat((Date)processInstance.getStart()).isNotNull();
        ((AbstractDateAssert)Assertions.assertThat((Date)processInstance.getEnd()).isNotNull()).withFailMessage("ProcessInstanceLog does not contain end date.", new Object[0]);
        Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
        Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow2");
        List nodeInstances = auditLogService.findNodeInstances(processInstanceId);
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            logger.debug("{} -> {}", (Object)nodeInstance.toString(), (Object)nodeInstance.getDate());
            Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
            Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow2");
            Assertions.assertThat((Date)nodeInstance.getDate()).isNotNull();
        }
        Assertions.assertThat((int)nodeInstances.size()).isEqualTo(14);
        auditLogService.clear();
    }

    public static void runTestLogger4(KieSession session, AuditLogService auditLogService) throws Exception {
        final ArrayList workItemIds = new ArrayList();
        session.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                workItemIds.add(workItem.getId());
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            }
        });
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        int initialProcessInstanceSize = processInstances.size();
        HashMap params = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("One");
        list.add("Two");
        list.add("Three");
        params.put("list", list);
        long processInstanceId = session.startProcess("com.sample.ruleflow3", params).getId();
        List varLogs = auditLogService.findVariableInstancesByName("s", true);
        Assertions.assertThat((List)varLogs).isNotEmpty();
        Assertions.assertThat((int)varLogs.size()).isEqualTo(1);
        for (Long workItemId : workItemIds) {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("Result", "ResultValue");
            session.getWorkItemManager().completeWorkItem(workItemId.longValue(), results);
        }
        logger.debug("Checking process instances for process 'com.sample.ruleflow3'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        Assertions.assertThat((int)processInstances.size()).isEqualTo(initialProcessInstanceSize + 1);
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assertions.assertThat((Date)processInstance.getStart()).isNotNull();
        ((AbstractDateAssert)Assertions.assertThat((Date)processInstance.getEnd()).isNotNull()).withFailMessage("ProcessInstanceLog does not contain end date.", new Object[0]);
        Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
        Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow3");
        List variableInstances = auditLogService.findVariableInstances(processInstanceId);
        Assertions.assertThat((int)variableInstances.size()).isEqualTo(11);
        for (Object variableInstance : variableInstances) {
            logger.debug(variableInstance.toString());
            Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
            Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow3");
            Assertions.assertThat((Date)variableInstance.getDate()).isNotNull();
        }
        List emptyVarLogs = auditLogService.findVariableInstancesByName("s", true);
        Assertions.assertThat((List)emptyVarLogs).isEmpty();
        for (VariableInstanceLog origVarLog : variableInstances) {
            varLogs = auditLogService.findVariableInstancesByName(origVarLog.getVariableId(), false);
            for (VariableInstanceLog varLog : varLogs) {
                Assertions.assertThat((String)varLog.getVariableId()).isEqualTo(origVarLog.getVariableId());
            }
        }
        emptyVarLogs = auditLogService.findVariableInstancesByNameAndValue("s", "InitialValue", true);
        Assertions.assertThat((List)emptyVarLogs).isEmpty();
        String varId = "s";
        String varValue = "ResultValue";
        variableInstances = auditLogService.findVariableInstancesByNameAndValue(varId, varValue, false);
        Assertions.assertThat((int)variableInstances.size()).isEqualTo(3);
        VariableInstanceLog varLog = (VariableInstanceLog)variableInstances.get(0);
        Assertions.assertThat((String)varLog.getVariableId()).isEqualTo(varId);
        Assertions.assertThat((String)varLog.getValue()).isEqualTo(varValue);
        auditLogService.clear();
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        Assertions.assertThat((List)processInstances).isEmpty();
    }

    public static void runTestLogger4LargeVariable(KieSession session, AuditLogService auditLogService) throws Exception {
        session.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                HashMap<String, String> results = new HashMap<String, String>();
                results.put("Result", "ResultValue");
                manager.completeWorkItem(workItem.getId(), results);
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            }
        });
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        int initialProcessInstanceSize = processInstances.size();
        HashMap params = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("One");
        list.add("Two");
        String three = "";
        for (int i = 0; i < 1024; ++i) {
            three = three + "*";
        }
        list.add(three);
        params.put("list", list);
        long processInstanceId = session.startProcess("com.sample.ruleflow3", params).getId();
        logger.debug("Checking process instances for process 'com.sample.ruleflow3'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        int expected = initialProcessInstanceSize + 1;
        Assertions.assertThat((int)processInstances.size()).isEqualTo(expected).withFailMessage(String.format("Expected %d ProcessInstanceLog instances, not %d", expected, processInstances.size()), new Object[0]);
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assertions.assertThat((Date)processInstance.getStart()).isNotNull();
        ((AbstractDateAssert)Assertions.assertThat((Date)processInstance.getEnd()).isNotNull()).withFailMessage("ProcessInstanceLog does not contain end date.", new Object[0]);
        Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
        Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow3");
        List variableInstances = auditLogService.findVariableInstances(processInstanceId);
        Assertions.assertThat((int)variableInstances.size()).isEqualTo(8);
        for (VariableInstanceLog variableInstance : variableInstances) {
            logger.debug(variableInstance.toString());
            Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
            Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow3");
            Assertions.assertThat((Date)variableInstance.getDate()).isNotNull();
        }
        auditLogService.clear();
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        Assertions.assertThat((List)processInstances).isNullOrEmpty();
    }

    public static void runTestLogger5(KieSession session, AuditLogService auditLogService) throws Exception {
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        int initialProcessInstanceSize = processInstances.size();
        long processInstanceId = session.startProcess("com.sample.ruleflow").getId();
        logger.debug("Checking process instances for process 'com.sample.ruleflow'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        Assertions.assertThat((int)processInstances.size()).isEqualTo(initialProcessInstanceSize + 1);
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assertions.assertThat((Date)processInstance.getStart()).isNotNull();
        Assertions.assertThat((Date)processInstance.getEnd()).isNotNull();
        Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
        Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow");
        Assertions.assertThat((int)processInstance.getStatus()).isEqualTo(2);
        List nodeInstances = auditLogService.findNodeInstances(processInstanceId);
        Assertions.assertThat((int)nodeInstances.size()).isEqualTo(6);
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            logger.debug(nodeInstance.toString());
            Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
            Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow");
            Assertions.assertThat((Date)nodeInstance.getDate()).isNotNull();
        }
        auditLogService.clear();
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        Assertions.assertThat((List)processInstances).isEmpty();
    }

    public static void runTestLoggerWithCustomVariableLogLength(KieSession session, AuditLogService auditLogService) throws Exception {
        System.setProperty("org.jbpm.var.log.length", "15");
        final ArrayList workItemIds = new ArrayList();
        session.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                workItemIds.add(workItem.getId());
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            }
        });
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        int initialProcessInstanceSize = processInstances.size();
        processInstances = auditLogService.findActiveProcessInstances();
        int initialActiveProcessInstanceSize = processInstances.size();
        String variableValue = "very short value that should be trimmed by custom variable log length";
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> list = new ArrayList<String>();
        list.add("One");
        list.add("Two");
        list.add("Three");
        params.put("list", list);
        params.put("s", variableValue);
        long processInstanceId = session.startProcess("com.sample.ruleflow3", params).getId();
        int numActiveProcesses = auditLogService.findActiveProcessInstances().size();
        Assertions.assertThat((int)numActiveProcesses).isEqualTo(initialActiveProcessInstanceSize + 1).withFailMessage("find active processes did not work", new Object[0]);
        List varLogs = auditLogService.findVariableInstancesByName("s", true);
        varLogs = varLogs.stream().sorted((o1, o2) -> Long.compare(o1.getId(), o2.getId())).collect(Collectors.toList());
        Assertions.assertThat(varLogs).isNotEmpty();
        Assertions.assertThat((int)varLogs.size()).isEqualTo(2);
        Assertions.assertThat(varLogs).flatExtracting(new ThrowingExtractor[]{VariableInstanceLog::getValue}).containsExactly(new Object[]{"InitialValue", variableValue.substring(0, 15)});
        for (Long workItemId : workItemIds) {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("Result", "ResultValue");
            session.getWorkItemManager().completeWorkItem(workItemId.longValue(), results);
        }
        logger.debug("Checking process instances for process 'com.sample.ruleflow3'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        Assertions.assertThat((int)processInstances.size()).isEqualTo(initialProcessInstanceSize + 1);
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assertions.assertThat((Date)processInstance.getStart()).isNotNull();
        ((AbstractDateAssert)Assertions.assertThat((Date)processInstance.getEnd()).isNotNull()).withFailMessage("ProcessInstanceLog does not contain end date.", new Object[0]);
        Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
        Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow3");
        List variableInstances = auditLogService.findVariableInstances(processInstanceId);
        Assertions.assertThat((int)variableInstances.size()).isEqualTo(12);
        for (Object variableInstance : variableInstances) {
            logger.debug(variableInstance.toString());
            Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
            Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow3");
            Assertions.assertThat((Date)variableInstance.getDate()).isNotNull();
        }
        List emptyVarLogs = auditLogService.findVariableInstancesByName("s", true);
        Assertions.assertThat((List)emptyVarLogs).isEmpty();
        for (VariableInstanceLog origVarLog : variableInstances) {
            varLogs = auditLogService.findVariableInstancesByName(origVarLog.getVariableId(), false);
            for (VariableInstanceLog varLog : varLogs) {
                Assertions.assertThat((String)varLog.getVariableId()).isEqualTo(origVarLog.getVariableId());
            }
        }
        emptyVarLogs = auditLogService.findVariableInstancesByNameAndValue("s", "InitialValue", true);
        Assertions.assertThat((List)emptyVarLogs).isEmpty();
        String varId = "s";
        String varValue = "ResultValue";
        variableInstances = auditLogService.findVariableInstancesByNameAndValue(varId, varValue, false);
        Assertions.assertThat((int)variableInstances.size()).isEqualTo(3);
        VariableInstanceLog varLog = (VariableInstanceLog)variableInstances.get(0);
        Assertions.assertThat((String)varLog.getVariableId()).isEqualTo(varId);
        Assertions.assertThat((String)varLog.getValue()).isEqualTo(varValue);
        auditLogService.clear();
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        Assertions.assertThat((List)processInstances).isEmpty();
    }

    public static void runTestLogger4WithCustomVariableIndexer(KieSession session, AuditLogService auditLogService) throws Exception {
        final ArrayList workItemIds = new ArrayList();
        session.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                workItemIds.add(workItem.getId());
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            }
        });
        List processInstances = auditLogService.findProcessInstances("com.sample.ruleflow");
        int initialProcessInstanceSize = processInstances.size();
        HashMap params = new HashMap();
        LinkedList<String> list = new LinkedList<String>();
        list.add("One");
        list.add("Two");
        list.add("Three");
        params.put("list", list);
        long processInstanceId = session.startProcess("com.sample.ruleflow3", params).getId();
        List varLogs = auditLogService.findVariableInstancesByName("s", true);
        Assertions.assertThat((List)varLogs).isNotEmpty();
        Assertions.assertThat((int)varLogs.size()).isEqualTo(1);
        for (Long workItemId : workItemIds) {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("Result", "ResultValue");
            session.getWorkItemManager().completeWorkItem(workItemId.longValue(), results);
        }
        logger.debug("Checking process instances for process 'com.sample.ruleflow3'");
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        Assertions.assertThat((int)processInstances.size()).isEqualTo(initialProcessInstanceSize + 1);
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assertions.assertThat((Date)processInstance.getStart()).isNotNull();
        Assertions.assertThat((Date)processInstance.getEnd()).isNotNull();
        Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
        Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow3");
        List variableInstances = auditLogService.findVariableInstances(processInstanceId);
        Assertions.assertThat((int)variableInstances.size()).isEqualTo(13);
        for (Object variableInstance : variableInstances) {
            logger.debug(variableInstance.toString());
            Assertions.assertThat((long)processInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
            Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("com.sample.ruleflow3");
            Assertions.assertThat((Date)variableInstance.getDate()).isNotNull();
        }
        ArrayList<VariableInstanceLog> listVariables = new ArrayList<VariableInstanceLog>();
        for (VariableInstanceLog v : variableInstances) {
            if (!v.getVariableInstanceId().equals("list")) continue;
            listVariables.add(v);
        }
        Assertions.assertThat((int)listVariables.size()).isEqualTo(3);
        ArrayList<String> variableValues = new ArrayList<String>();
        ArrayList<String> variableIds = new ArrayList<String>();
        for (VariableInstanceLog variableInstanceLog : listVariables) {
            variableValues.add(variableInstanceLog.getValue());
            variableIds.add(variableInstanceLog.getVariableId());
            Assertions.assertThat((String)variableInstanceLog.getOldValue()).isIn(new Object[]{"", " ", null});
            Assertions.assertThat((Long)variableInstanceLog.getProcessInstanceId()).isEqualTo((Object)processInstance.getProcessInstanceId());
            Assertions.assertThat((String)variableInstanceLog.getProcessId()).isEqualTo(processInstance.getProcessId());
            Assertions.assertThat((String)variableInstanceLog.getVariableInstanceId()).isEqualTo("list");
        }
        Assertions.assertThat(variableValues).contains((Object[])new String[]{"One", "Two", "Three"});
        Assertions.assertThat(variableIds).contains((Object[])new String[]{"list[0]", "list[1]", "list[2]"});
        List emptyVarLogs = auditLogService.findVariableInstancesByName("s", true);
        Assertions.assertThat((List)emptyVarLogs).isEmpty();
        for (VariableInstanceLog origVarLog : variableInstances) {
            varLogs = auditLogService.findVariableInstancesByName(origVarLog.getVariableId(), false);
            for (VariableInstanceLog varLog : varLogs) {
                Assertions.assertThat((String)varLog.getVariableId()).isEqualTo(origVarLog.getVariableId());
            }
        }
        emptyVarLogs = auditLogService.findVariableInstancesByNameAndValue("s", "InitialValue", true);
        Assertions.assertThat((List)emptyVarLogs).isEmpty();
        String string = "s";
        String varValue = "ResultValue";
        variableInstances = auditLogService.findVariableInstancesByNameAndValue(string, varValue, false);
        Assertions.assertThat((int)variableInstances.size()).isEqualTo(3);
        VariableInstanceLog varLog = (VariableInstanceLog)variableInstances.get(0);
        Assertions.assertThat((String)varLog.getVariableId()).isEqualTo(string);
        Assertions.assertThat((String)varLog.getValue()).isEqualTo(varValue);
        auditLogService.clear();
        processInstances = auditLogService.findProcessInstances("com.sample.ruleflow3");
        Assertions.assertThat((List)processInstances).isEmpty();
    }
}

