/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.jbpm.process.audit.ProcessInstanceExecutorFrame;
import org.jbpm.process.instance.impl.demo.UIWorkItemHandler;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItemHandler;

public class ProcessInstanceExecutor {
    public static final void main(String[] args) {
        try {
            KieBase kbase = ProcessInstanceExecutor.createKnowledgeBase();
            KieSession session = kbase.newKieSession();
            new JPAWorkingMemoryDbLogger(session);
            UIWorkItemHandler uiHandler = new UIWorkItemHandler();
            session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)uiHandler);
            uiHandler.setVisible(true);
            new ProcessInstanceExecutorFrame(session).setVisible(true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static KieBase createKnowledgeBase() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        InputStreamReader source = new InputStreamReader(ProcessInstanceExecutor.class.getResourceAsStream("/ruleflow.rf"));
        builder.addProcessFromXml((Reader)source);
        source = new InputStreamReader(ProcessInstanceExecutor.class.getResourceAsStream("/ruleflow2.rf"));
        builder.addProcessFromXml((Reader)source);
        InternalKnowledgeBase ruleBase = KnowledgeBaseFactory.newKnowledgeBase();
        ruleBase.addPackages(Arrays.asList(builder.getPackages()));
        return ruleBase;
    }
}

