/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.query;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.QueryHelper;
import org.jbpm.process.audit.command.AuditCommand;
import org.jbpm.query.jpa.builder.impl.AbstractDeleteBuilderImpl;
import org.jbpm.query.jpa.data.QueryWhere;
import org.jbpm.query.jpa.impl.QueryAndParameterAppender;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.Context;
import org.kie.internal.query.ParametrizedUpdate;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.runtime.manager.audit.query.AuditDeleteBuilder;

public abstract class AbstractAuditDeleteBuilderImpl<T>
extends AbstractDeleteBuilderImpl<T>
implements AuditDeleteBuilder<T> {
    protected Integer[] statuses = new Integer[]{2, 3};
    protected String deploymentId;
    protected int recordsPerTransaction;
    protected final CommandExecutor executor;
    protected final JPAAuditLogService jpaAuditService;
    private AuditCommand<JPAAuditLogService> getJpaAuditLogServiceCommand = new AuditCommand<JPAAuditLogService>(){
        private static final long serialVersionUID = 101L;

        public JPAAuditLogService execute(Context context) {
            this.setLogEnvironment(context);
            return (JPAAuditLogService)this.auditLogService;
        }
    };

    protected AbstractAuditDeleteBuilderImpl(JPAAuditLogService jpaService) {
        this.executor = null;
        this.jpaAuditService = jpaService;
    }

    protected AbstractAuditDeleteBuilderImpl(CommandExecutor cmdExecutor) {
        this.executor = cmdExecutor;
        this.jpaAuditService = null;
    }

    protected JPAAuditLogService getJpaAuditLogService() {
        JPAAuditLogService jpaAuditLogService = this.jpaAuditService;
        if (jpaAuditLogService == null) {
            jpaAuditLogService = (JPAAuditLogService)this.executor.execute(this.getJpaAuditLogServiceCommand);
        }
        return jpaAuditLogService;
    }

    public T date(Date ... date) {
        if (this.checkIfNull(date)) {
            return (T)((Object)this);
        }
        date = this.ensureDateNotTimestamp(date);
        this.addObjectParameter(QueryParameterIdentifiers.DATE_LIST, "date", date);
        return (T)((Object)this);
    }

    public T dateRangeStart(Date rangeStart) {
        if (this.checkIfNull(rangeStart)) {
            return (T)((Object)this);
        }
        rangeStart = this.ensureDateNotTimestamp(rangeStart)[0];
        this.addRangeParameter(QueryParameterIdentifiers.DATE_LIST, "date range start", rangeStart, true);
        return (T)((Object)this);
    }

    public T dateRangeEnd(Date rangeEnd) {
        if (this.checkIfNull(rangeEnd)) {
            return (T)((Object)this);
        }
        rangeEnd = this.ensureDateNotTimestamp(rangeEnd)[0];
        this.addRangeParameter(QueryParameterIdentifiers.DATE_LIST, "date range end", rangeEnd, false);
        return (T)((Object)this);
    }

    public T recordsPerTransaction(int numRecords) {
        this.recordsPerTransaction = numRecords;
        return (T)((Object)this);
    }

    public T processInstanceId(long ... processInstanceId) {
        if (this.checkIfNull((P[])new long[][]{processInstanceId})) {
            return (T)((Object)this);
        }
        this.addLongParameter(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "process instance id", processInstanceId);
        return (T)((Object)this);
    }

    public T processId(String ... processId) {
        if (this.checkIfNull(processId)) {
            return (T)((Object)this);
        }
        this.addObjectParameter(QueryParameterIdentifiers.PROCESS_ID_LIST, "process id", processId);
        return (T)((Object)this);
    }

    public T logBelongsToProcessInStatus(Integer ... statuses) {
        if (this.checkIfNull(statuses)) {
            return (T)((Object)this);
        }
        this.statuses = statuses;
        return (T)((Object)this);
    }

    public T logBelongsToProcessInDeployment(String deploymentId) {
        if (this.checkIfNull(deploymentId)) {
            return (T)((Object)this);
        }
        this.deploymentId = deploymentId;
        return (T)((Object)this);
    }

    protected <P> boolean checkIfNull(P ... parameter) {
        if (parameter == null) {
            return true;
        }
        for (int i = 0; i < parameter.length; ++i) {
            if (parameter[i] != null) continue;
            return true;
        }
        return false;
    }

    protected Date[] ensureDateNotTimestamp(Date ... date) {
        Date[] validated = new Date[date.length];
        for (int i = 0; i < date.length; ++i) {
            validated[i] = date[i] instanceof Timestamp ? new Date(date[i].getTime()) : date[i];
        }
        return validated;
    }

    protected abstract Class<?> getQueryType();

    protected abstract String getQueryTable();

    protected boolean isSubquerySupported() {
        return false;
    }

    protected Subquery getSubQuery() {
        return new Subquery("l.processInstanceId", "SELECT spl.processInstanceId FROM ProcessInstanceLog spl", 1);
    }

    protected Subquery applyParameters(Subquery subquery) {
        return subquery.parameter(QueryParameterIdentifiers.SUBQUERY_STATUS, this.statuses).parameter(QueryParameterIdentifiers.SUBQUERY_DEPLOYMENT, this.deploymentId);
    }

    public ParametrizedUpdate build() {
        return new ParametrizedUpdate(){
            private QueryWhere queryWhere;
            {
                this.queryWhere = new QueryWhere(AbstractAuditDeleteBuilderImpl.this.getQueryWhere());
            }

            public int execute() {
                HashMap<String, Object> params = new HashMap<String, Object>();
                String subquerySQL = null;
                if (AbstractAuditDeleteBuilderImpl.this.isSubquerySupported()) {
                    Subquery subquery = AbstractAuditDeleteBuilderImpl.this.applyParameters(AbstractAuditDeleteBuilderImpl.this.getSubQuery());
                    subquerySQL = subquery.build();
                    params.putAll(subquery.getQueryParams());
                }
                return AbstractAuditDeleteBuilderImpl.this.recordsPerTransaction <= 0 ? AbstractAuditDeleteBuilderImpl.this.getJpaAuditLogService().doDelete(AbstractAuditDeleteBuilderImpl.this.getQueryTable(), this.queryWhere, subquerySQL, params) : AbstractAuditDeleteBuilderImpl.this.getJpaAuditLogService().doPartialDelete(AbstractAuditDeleteBuilderImpl.this.getQueryTable(), this.queryWhere, subquerySQL, params, AbstractAuditDeleteBuilderImpl.this.recordsPerTransaction);
            }
        };
    }

    protected static class Subquery {
        private String field;
        private String queryBase;
        private int queryParamId;
        private QueryWhere where;
        private String join;
        private QueryAndParameterAppender queryAndParameterAppender;

        public Subquery(String field, String queryBase, int queryParamId) {
            this(field, queryBase, queryParamId, "in");
        }

        public Subquery(String field, String queryBase, int queryParamId, String join) {
            this.field = field;
            this.queryBase = queryBase;
            this.queryParamId = queryParamId;
            this.where = new QueryWhere();
            this.join = join;
        }

        public Subquery parameter(String listId, Object ... values) {
            if (values == null || values.length == 0 || values[0] == null) {
                return this;
            }
            this.where.setToIntersection();
            this.where.addParameter(listId, values);
            return this;
        }

        Map<String, Object> getQueryParams() {
            if (this.queryAndParameterAppender != null) {
                return this.queryAndParameterAppender.getQueryParams();
            }
            return null;
        }

        public String build() {
            if (this.queryAndParameterAppender == null) {
                this.queryAndParameterAppender = QueryHelper.createQuery(this.queryBase, this.where, new HashMap<String, Object>(), this.queryParamId);
            }
            return this.field + " " + this.join + " (" + this.queryAndParameterAppender.toSQL() + ")";
        }
    }
}

