/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import org.drools.core.WorkingMemory;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.api.event.process.ProcessAsyncNodeScheduledEvent;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessDataChangedEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;

public abstract class AbstractAuditLoggerAdapter
extends AbstractAuditLogger {
    public static final String METADATA_PROCESSINTANCE_LOG = "ProcessInstanceLog";
    public static final String METADATA_NODEINSTANCE_LOG = "NodeInstanceLog";
    public static final String METADATA_VARIABLEINSTANCE_LOG = "VariableInstanceLog";

    public AbstractAuditLoggerAdapter() {
    }

    public AbstractAuditLoggerAdapter(WorkingMemory workingMemory) {
        super(workingMemory);
    }

    public void setProcessInstanceMetadata(ProcessInstance pi, String key, Object value) {
        ((ProcessInstanceImpl)pi).getMetaData().put(key, value);
    }

    public Object getProcessInstanceMetadata(ProcessInstance pi, String key) {
        return ((ProcessInstanceImpl)pi).getMetaData().get(key);
    }

    public void setNodeInstanceMetadata(NodeInstance pi, String key, Object value) {
        ((NodeInstanceImpl)pi).getMetaData().put(key, value);
    }

    public Object getNodeInstanceMetadata(NodeInstance pi, String key) {
        return ((NodeInstanceImpl)pi).getMetaData().get(key);
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        this.processStarted(event);
    }

    protected abstract void processStarted(ProcessStartedEvent var1);

    public void onAsyncNodeScheduledEvent(ProcessAsyncNodeScheduledEvent event) {
        this.nodeScheduled(event);
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        this.processCompleted(event);
    }

    protected abstract void processCompleted(ProcessCompletedEvent var1);

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        this.nodeEnter(event);
    }

    protected abstract void nodeScheduled(ProcessAsyncNodeScheduledEvent var1);

    protected abstract void nodeEnter(ProcessNodeTriggeredEvent var1);

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
        NodeInstanceLog log = (NodeInstanceLog)((NodeInstanceImpl)event.getNodeInstance()).getMetaData().get(METADATA_NODEINSTANCE_LOG);
        this.builder.buildEvent(event, (Object)log);
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        this.nodeLeft(event);
    }

    protected abstract void nodeLeft(ProcessNodeLeftEvent var1);

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        this.variableChanged(event);
    }

    protected abstract void variableChanged(ProcessVariableChangedEvent var1);

    public void afterSLAViolated(SLAViolatedEvent event) {
        if (event.getNodeInstance() != null) {
            this.slaNodeInstanceViolated(event);
        } else {
            this.slaProcessInstanceViolated(event);
        }
    }

    protected abstract void slaNodeInstanceViolated(SLAViolatedEvent var1);

    protected abstract void slaProcessInstanceViolated(SLAViolatedEvent var1);

    public void onProcessDataChangedEvent(ProcessDataChangedEvent event) {
        this.processDataChanged(event);
    }

    protected abstract void processDataChanged(ProcessDataChangedEvent var1);
}

