/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.xml.XmlDumper;
import org.drools.definition.process.Node;
import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallActivityHandler
extends AbstractNodeHandler {
    @Override
    protected org.jbpm.workflow.core.Node createNode(Attributes attrs) {
        return new SubProcessNode();
    }

    public Class generateNodeFor() {
        return SubProcessNode.class;
    }

    @Override
    protected void handleNode(org.jbpm.workflow.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        String independent;
        String waitForCompletion;
        super.handleNode(node, element, uri, localName, parser);
        SubProcessNode subProcessNode = (SubProcessNode)node;
        String processId = element.getAttribute("calledElement");
        if (processId != null) {
            subProcessNode.setProcessId(processId);
        }
        if ((waitForCompletion = element.getAttribute("waitForCompletion")) != null && "false".equals(waitForCompletion)) {
            subProcessNode.setWaitForCompletion(false);
        }
        if ((independent = element.getAttribute("independent")) != null && "false".equals(independent)) {
            subProcessNode.setIndependent(false);
        }
        HashMap<String, String> dataInputs = new HashMap<String, String>();
        HashMap<String, String> dataOutputs = new HashMap<String, String>();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, dataInputs, dataOutputs);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, subProcessNode, dataInputs);
                continue;
            }
            if (!"dataOutputAssociation".equals(nodeName)) continue;
            this.readDataOutputAssociation(xmlNode, subProcessNode, dataOutputs);
        }
    }

    protected void readIoSpecification(org.w3c.dom.Node xmlNode, Map<String, String> dataInputs, Map<String, String> dataOutputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        while (subNode instanceof Element) {
            String id;
            String subNodeName = subNode.getNodeName();
            if ("dataInput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String inputName = ((Element)subNode).getAttribute("name");
                dataInputs.put(id, inputName);
            } else if ("dataOutput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String outputName = ((Element)subNode).getAttribute("name");
                dataOutputs.put(id, outputName);
            }
            subNode = subNode.getNextSibling();
        }
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, SubProcessNode subProcessNode, Map<String, String> dataInputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        String from = subNode.getTextContent();
        subNode = subNode.getNextSibling();
        String to = subNode.getTextContent();
        subProcessNode.addInMapping(dataInputs.get(to), from);
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, SubProcessNode subProcessNode, Map<String, String> dataOutputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        String from = subNode.getTextContent();
        subNode = subNode.getNextSibling();
        String to = subNode.getTextContent();
        subProcessNode.addOutMapping(dataOutputs.get(from), to);
    }

    @Override
    public void writeNode(org.jbpm.workflow.core.Node node, StringBuilder xmlDump, int metaDataType) {
        SubProcessNode subProcessNode = (SubProcessNode)node;
        this.writeNode("callActivity", (org.jbpm.workflow.core.Node)subProcessNode, xmlDump, metaDataType);
        if (subProcessNode.getProcessId() != null) {
            xmlDump.append("calledElement=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(subProcessNode.getProcessId()) + "\" ");
        }
        if (!subProcessNode.isWaitForCompletion()) {
            xmlDump.append("tns:waitForCompletion=\"false\" ");
        }
        if (!subProcessNode.isIndependent()) {
            xmlDump.append("tns:independent=\"false\" ");
        }
        xmlDump.append(">" + EOL);
        this.writeIO(subProcessNode, xmlDump);
        this.endNode("callActivity", xmlDump);
    }

    protected void writeIO(SubProcessNode subProcessNode, StringBuilder xmlDump) {
        xmlDump.append("      <ioSpecification>" + EOL);
        for (Map.Entry entry : subProcessNode.getInMappings().entrySet()) {
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)subProcessNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        for (Map.Entry entry : subProcessNode.getOutMappings().entrySet()) {
            xmlDump.append("        <dataOutput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)subProcessNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Output\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        xmlDump.append("        <inputSet>" + EOL);
        for (Map.Entry entry : subProcessNode.getInMappings().entrySet()) {
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)subProcessNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</dataInputRefs>" + EOL);
        }
        xmlDump.append("        </inputSet>" + EOL);
        xmlDump.append("        <outputSet>" + EOL);
        for (Map.Entry entry : subProcessNode.getOutMappings().entrySet()) {
            xmlDump.append("          <dataOutputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)subProcessNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</dataOutputRefs>" + EOL);
        }
        xmlDump.append("        </outputSet>" + EOL);
        xmlDump.append("      </ioSpecification>" + EOL);
        for (Map.Entry entry : subProcessNode.getInMappings().entrySet()) {
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)subProcessNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</targetRef>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : subProcessNode.getOutMappings().entrySet()) {
            xmlDump.append("      <dataOutputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)subProcessNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</sourceRef>" + EOL + "        <targetRef>" + (String)entry.getValue() + "</targetRef>" + EOL);
            xmlDump.append("      </dataOutputAssociation>" + EOL);
        }
    }
}

