/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.drools.compiler.xml.XmlDumper;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.NodeContainer;
import org.drools.definition.process.WorkflowProcess;
import org.drools.process.core.Work;
import org.drools.process.core.datatype.impl.type.ObjectDataType;
import org.drools.xml.Handler;
import org.drools.xml.SemanticModule;
import org.jbpm.bpmn2.core.Association;
import org.jbpm.bpmn2.core.DataStore;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.Process;
import org.jbpm.process.core.context.swimlane.Swimlane;
import org.jbpm.process.core.context.swimlane.SwimlaneContext;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;
import org.jbpm.workflow.core.node.WorkItemNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBPMNProcessDumper {
    public static final String JAVA_LANGUAGE = "http://www.java.com/java";
    public static final String RULE_LANGUAGE = "http://www.jboss.org/drools/rule";
    public static final String XPATH_LANGUAGE = "http://www.w3.org/1999/XPath";
    public static final int NO_META_DATA = 0;
    public static final int META_DATA_AS_NODE_PROPERTY = 1;
    public static final int META_DATA_USING_DI = 2;
    public static XmlBPMNProcessDumper INSTANCE = new XmlBPMNProcessDumper();
    private static final String EOL = System.getProperty("line.separator");
    private SemanticModule semanticModule = new BPMNSemanticModule();
    private int metaDataType = 2;

    private XmlBPMNProcessDumper() {
    }

    public String dump(WorkflowProcess process) {
        return this.dump(process, 2);
    }

    public String dump(WorkflowProcess process, boolean includeMeta) {
        return this.dump(process, 1);
    }

    public String dump(WorkflowProcess process, int metaDataType) {
        StringBuilder xmlDump = new StringBuilder();
        this.visitProcess(process, xmlDump, metaDataType);
        return xmlDump.toString();
    }

    public int getMetaDataType() {
        return this.metaDataType;
    }

    public void setMetaDataType(int metaDataType) {
        this.metaDataType = metaDataType;
    }

    protected void visitProcess(WorkflowProcess process, StringBuilder xmlDump, int metaDataType) {
        String version;
        String packageName;
        String targetNamespace = (String)process.getMetaData().get("TargetNamespace");
        if (targetNamespace == null) {
            targetNamespace = "http://www.jboss.org/drools";
        }
        xmlDump.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?> " + EOL + "<definitions id=\"Definition\"" + EOL + "             targetNamespace=\"" + targetNamespace + "\"" + EOL + "             typeLanguage=\"http://www.java.com/javaTypes\"" + EOL + "             expressionLanguage=\"http://www.mvel.org/2.0\"" + EOL + "             xmlns=\"http://www.omg.org/spec/BPMN/20100524/MODEL\"" + EOL + "             xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + EOL + "             xsi:schemaLocation=\"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd\"" + EOL + "             xmlns:g=\"http://www.jboss.org/drools/flow/gpd\"" + EOL + (metaDataType == 2 ? "             xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\"" + EOL + "             xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\"" + EOL + "             xmlns:di=\"http://www.omg.org/spec/DD/20100524/DI\"" + EOL : "") + "             xmlns:tns=\"http://www.jboss.org/drools\">" + EOL + EOL);
        VariableScope variableScope = (VariableScope)((Process)process).getDefaultContext("VariableScope");
        this.visitVariableScope(variableScope, "_", xmlDump);
        this.visitSubVariableScopes(process.getNodes(), xmlDump);
        this.visitInterfaces(process.getNodes(), xmlDump);
        this.visitEscalations(process.getNodes(), xmlDump, new ArrayList<String>());
        this.visitErrors(process.getNodes(), xmlDump, new ArrayList<String>());
        Definitions def = (Definitions)process.getMetaData().get("Definitions");
        if (def != null && def.getDataStores() != null) {
            for (DataStore dataStore : def.getDataStores()) {
                this.visitDataStore(dataStore, xmlDump);
            }
        }
        xmlDump.append("  <process processType=\"Private\" isExecutable=\"true\" ");
        if (process.getId() != null) {
            xmlDump.append("id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(process.getId()) + "\" ");
        }
        if (process.getName() != null) {
            xmlDump.append("name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(process.getName()) + "\" ");
        }
        if ((packageName = process.getPackageName()) != null && !"org.drools.bpmn2".equals(packageName)) {
            xmlDump.append("tns:packageName=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(packageName) + "\" ");
        }
        if (((org.jbpm.workflow.core.WorkflowProcess)process).isDynamic()) {
            xmlDump.append("tns:adHoc=\"true\" ");
        }
        if ((version = process.getVersion()) != null && !"".equals(version)) {
            xmlDump.append("tns:version=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(version) + "\" ");
        }
        xmlDump.append(">" + EOL + EOL);
        this.visitLanes(process, xmlDump);
        this.visitHeader(process, xmlDump, metaDataType);
        this.visitNodes(process, xmlDump, metaDataType);
        this.visitConnections(process.getNodes(), xmlDump, metaDataType);
        if (def != null && def.getAssociations() != null) {
            for (Association association : def.getAssociations()) {
                this.visitAssociation(association, xmlDump);
            }
        }
        xmlDump.append("  </process>" + EOL + EOL);
        if (metaDataType == 2) {
            xmlDump.append("  <bpmndi:BPMNDiagram>" + EOL + "    <bpmndi:BPMNPlane bpmnElement=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(process.getId()) + "\" >" + EOL);
            this.visitNodesDi(process.getNodes(), xmlDump);
            this.visitConnectionsDi(process.getNodes(), xmlDump);
            xmlDump.append("    </bpmndi:BPMNPlane>" + EOL + "  </bpmndi:BPMNDiagram>" + EOL + EOL);
        }
        xmlDump.append("</definitions>");
    }

    private void visitDataStore(DataStore dataStore, StringBuilder xmlDump) {
        String itemSubjectRef = dataStore.getItemSubjectRef();
        String itemDefId = itemSubjectRef.substring(itemSubjectRef.indexOf(58) + 1);
        xmlDump.append("  <itemDefinition id=\"" + itemDefId + "\" ");
        if (dataStore.getType() != null && !"java.lang.Object".equals(dataStore.getType().getStringType())) {
            xmlDump.append("structureRef=\"" + XmlDumper.replaceIllegalChars((String)dataStore.getType().getStringType()) + "\" ");
        }
        xmlDump.append("/>" + EOL);
        xmlDump.append("  <dataStore name=\"" + XmlDumper.replaceIllegalChars((String)dataStore.getName()) + "\"");
        xmlDump.append(" id=\"" + XmlDumper.replaceIllegalChars((String)dataStore.getId()) + "\"");
        xmlDump.append(" itemSubjectRef=\"" + XmlDumper.replaceIllegalChars((String)dataStore.getItemSubjectRef()) + "\"");
        xmlDump.append("/>" + EOL);
    }

    private void visitAssociation(Association association, StringBuilder xmlDump) {
        xmlDump.append("    <association id=\"" + association.getId() + "\" ");
        xmlDump.append(" sourceRef=\"" + association.getSourceRef() + "\" ");
        xmlDump.append(" targetRef=\"" + association.getTargetRef() + "\" ");
        xmlDump.append("/>" + EOL);
    }

    private void visitVariableScope(VariableScope variableScope, String prefix, StringBuilder xmlDump) {
        if (variableScope != null && !variableScope.getVariables().isEmpty()) {
            for (Variable variable : variableScope.getVariables()) {
                xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(prefix + variable.getName()) + "Item\" ");
                if (variable.getType() != null && !"java.lang.Object".equals(variable.getType().getStringType())) {
                    xmlDump.append("structureRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(variable.getType().getStringType()) + "\" ");
                }
                xmlDump.append("/>" + EOL);
            }
            xmlDump.append(EOL);
        }
    }

    private void visitSubVariableScopes(Node[] nodes, StringBuilder xmlDump) {
        for (Node node : nodes) {
            VariableScope variableScope;
            if (node instanceof ContextContainer && (variableScope = (VariableScope)((ContextContainer)node).getDefaultContext("VariableScope")) != null) {
                this.visitVariableScope(variableScope, XmlBPMNProcessDumper.getUniqueNodeId(node) + "-", xmlDump);
            }
            if (!(node instanceof NodeContainer)) continue;
            this.visitSubVariableScopes(((NodeContainer)node).getNodes(), xmlDump);
        }
    }

    private void visitLanes(WorkflowProcess process, StringBuilder xmlDump) {
        Collection swimlanes = ((SwimlaneContext)((org.jbpm.workflow.core.WorkflowProcess)process).getDefaultContext("SwimlaneScope")).getSwimlanes();
        if (!swimlanes.isEmpty()) {
            xmlDump.append("    <laneSet>" + EOL);
            for (Swimlane swimlane : swimlanes) {
                xmlDump.append("      <lane name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(swimlane.getName()) + "\" >" + EOL);
                this.visitLane((NodeContainer)process, swimlane.getName(), xmlDump);
                xmlDump.append("      </lane>" + EOL);
            }
            xmlDump.append("    </laneSet>" + EOL);
        }
    }

    private void visitLane(NodeContainer container, String lane, StringBuilder xmlDump) {
        for (Node node : container.getNodes()) {
            String swimlane;
            if (node instanceof HumanTaskNode) {
                swimlane = ((HumanTaskNode)node).getSwimlane();
                if (lane.equals(swimlane)) {
                    xmlDump.append("        <flowNodeRef>" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "</flowNodeRef>" + EOL);
                }
            } else {
                swimlane = (String)node.getMetaData().get("Lane");
                if (lane.equals(swimlane)) {
                    xmlDump.append("        <flowNodeRef>" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "</flowNodeRef>" + EOL);
                }
            }
            if (!(node instanceof NodeContainer)) continue;
            this.visitLane((NodeContainer)node, lane, xmlDump);
        }
    }

    protected void visitHeader(WorkflowProcess process, StringBuilder xmlDump, int metaDataType) {
        VariableScope variableScope;
        List imports = ((Process)process).getImports();
        Map globals = ((Process)process).getGlobals();
        if (imports != null && !imports.isEmpty() || globals != null && globals.size() > 0) {
            xmlDump.append("    <extensionElements>" + EOL);
            if (imports != null) {
                for (String string : imports) {
                    xmlDump.append("     <tns:import name=\"" + string + "\" />" + EOL);
                }
            }
            if (globals != null) {
                for (Map.Entry entry : globals.entrySet()) {
                    xmlDump.append("     <tns:global identifier=\"" + (String)entry.getKey() + "\" type=\"" + (String)entry.getValue() + "\" />" + EOL);
                }
            }
            xmlDump.append("    </extensionElements>" + EOL);
        }
        if ((variableScope = (VariableScope)((Process)process).getDefaultContext("VariableScope")) != null) {
            XmlBPMNProcessDumper.visitVariables(variableScope.getVariables(), xmlDump);
        }
    }

    public static void visitVariables(List<Variable> variables, StringBuilder xmlDump) {
        if (!variables.isEmpty()) {
            xmlDump.append("    <!-- process variables -->" + EOL);
            for (Variable variable : variables) {
                if (variable.getMetaData("DataObject") != null) continue;
                xmlDump.append("    <property id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(variable.getName()) + "\" ");
                if (variable.getType() != null) {
                    xmlDump.append("itemSubjectRef=\"_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(variable.getName()) + "Item\"");
                }
                xmlDump.append("/>" + EOL);
            }
            for (Variable variable : variables) {
                if (variable.getMetaData("DataObject") == null) continue;
                xmlDump.append("    <dataObject id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(variable.getName()) + "\" ");
                if (variable.getType() != null) {
                    xmlDump.append("itemSubjectRef=\"_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(variable.getName()) + "Item\"");
                }
                xmlDump.append("/>" + EOL);
            }
            xmlDump.append(EOL);
        }
    }

    protected void visitInterfaces(Node[] nodes, StringBuilder xmlDump) {
        for (Node node : nodes) {
            String messageType;
            String messageType2;
            if (node instanceof WorkItemNode) {
                Work work = ((WorkItemNode)node).getWork();
                if (work != null) {
                    if ("Service Task".equals(work.getName())) {
                        String parameterType;
                        String operationName;
                        String interfaceName = (String)work.getParameter("Interface");
                        if (interfaceName == null) {
                            interfaceName = "";
                        }
                        if ((operationName = (String)work.getParameter("Operation")) == null) {
                            operationName = "";
                        }
                        if ((parameterType = (String)work.getParameter("ParameterType")) == null) {
                            parameterType = "";
                        }
                        xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_InMessageType\" " + ("".equals(parameterType) || "java.lang.Object".equals(parameterType) ? "" : "structureRef=\"" + parameterType + "\" ") + "/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_InMessage\" itemRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_InMessageType\" />" + EOL + "  <interface id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_ServiceInterface\" name=\"" + interfaceName + "\">" + EOL + "    <operation id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_ServiceOperation\" name=\"" + operationName + "\">" + EOL + "      <inMessageRef>" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_InMessage</inMessageRef>" + EOL + "    </operation>" + EOL + "  </interface>" + EOL + EOL);
                    } else if ("Send Task".equals(work.getName())) {
                        String messageType3 = (String)work.getParameter("MessageType");
                        if (messageType3 == null) {
                            messageType3 = "";
                        }
                        xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" " + ("".equals(messageType3) || "java.lang.Object".equals(messageType3) ? "" : "structureRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(messageType3) + "\" ") + "/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_Message\" itemRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" />" + EOL + EOL);
                    } else if ("Receive Task".equals(work.getName())) {
                        String messageId = (String)work.getParameter("MessageId");
                        messageType2 = (String)work.getParameter("MessageType");
                        if (messageType2 == null) {
                            messageType2 = "";
                        }
                        xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" " + ("".equals(messageType2) || "java.lang.Object".equals(messageType2) ? "" : "structureRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(messageType2) + "\" ") + "/>" + EOL + "  <message id=\"" + messageId + "\" itemRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" />" + EOL + EOL);
                    }
                }
            } else if (node instanceof EndNode) {
                messageType = (String)node.getMetaData().get("MessageType");
                if (messageType != null) {
                    xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" " + ("".equals(messageType) || "java.lang.Object".equals(messageType) ? "" : "structureRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(messageType) + "\" ") + "/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_Message\" itemRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" />" + EOL + EOL);
                }
            } else if (node instanceof ActionNode) {
                messageType = (String)node.getMetaData().get("MessageType");
                if (messageType != null) {
                    xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" " + ("".equals(messageType) || "java.lang.Object".equals(messageType) ? "" : "structureRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(messageType) + "\" ") + "/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_Message\" itemRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" />" + EOL + EOL);
                }
            } else if (node instanceof EventNode) {
                String messageRef;
                List filters;
                if (node.getMetaData().get("AttachedTo") == null && (filters = ((EventNode)node).getEventFilters()).size() > 0 && (messageRef = ((EventTypeFilter)filters.get(0)).getType()).startsWith("Message-")) {
                    messageRef = messageRef.substring(8);
                    messageType2 = (String)node.getMetaData().get("MessageType");
                    xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(messageRef) + "Type\" " + ("".equals(messageType2) || "java.lang.Object".equals(messageType2) ? "" : "structureRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(messageType2) + "\" ") + "/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(messageRef) + "\" itemRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(messageRef) + "Type\" />" + EOL + EOL);
                }
            } else if (node instanceof StartNode) {
                String eventType;
                Trigger trigger;
                StartNode startNode = (StartNode)node;
                if (startNode.getTriggers() != null && !startNode.getTriggers().isEmpty() && (trigger = (Trigger)startNode.getTriggers().get(0)) instanceof EventTrigger && (eventType = ((EventTypeFilter)((EventTrigger)trigger).getEventFilters().get(0)).getType()).startsWith("Message-")) {
                    eventType = eventType.substring(8);
                    String messageType4 = (String)node.getMetaData().get("MessageType");
                    xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(eventType) + "Type\" " + ("".equals(messageType4) || "java.lang.Object".equals(messageType4) ? "" : "structureRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(messageType4) + "\" ") + "/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(eventType) + "\" itemRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(eventType) + "Type\" />" + EOL + EOL);
                }
            } else if (node instanceof ForEachNode) {
                ForEachNode forEachNode = (ForEachNode)node;
                String type = null;
                if (forEachNode.getVariableType() instanceof ObjectDataType) {
                    type = ((ObjectDataType)forEachNode.getVariableType()).getClassName();
                }
                xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)forEachNode) + "_multiInstanceItemType\" " + (type == null || "java.lang.Object".equals(type) ? "" : "structureRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type) + "\" ") + "/>" + EOL + EOL);
            }
            if (!(node instanceof CompositeNode)) continue;
            this.visitInterfaces(((CompositeNode)node).getNodes(), xmlDump);
        }
    }

    protected void visitEscalations(Node[] nodes, StringBuilder xmlDump, List<String> escalations) {
        for (Node node : nodes) {
            EventNode eventNode;
            String type;
            if (node instanceof FaultNode) {
                String escalationCode;
                FaultNode faultNode = (FaultNode)node;
                if (!faultNode.isTerminateParent() && !escalations.contains(escalationCode = faultNode.getFaultName())) {
                    escalations.add(escalationCode);
                    xmlDump.append("  <escalation id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(escalationCode) + "\" escalationCode=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(escalationCode) + "\" />" + EOL);
                }
            } else if (node instanceof ActionNode) {
                String type2;
                String s;
                ActionNode actionNode = (ActionNode)node;
                DroolsConsequenceAction action = (DroolsConsequenceAction)actionNode.getAction();
                if (action != null && (s = action.getConsequence()).startsWith("org.drools.process.instance.context.exception.ExceptionScopeInstance scopeInstance = (org.drools.process.instance.context.exception.ExceptionScopeInstance) ((org.drools.workflow.instance.NodeInstance) kcontext.getNodeInstance()).resolveContextInstance(org.drools.process.core.context.exception.ExceptionScope.EXCEPTION_SCOPE, \"") && !escalations.contains(type2 = (s = s.substring(327)).substring(0, s.indexOf("\"")))) {
                    escalations.add(type2);
                    xmlDump.append("  <escalation id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type2) + "\" escalationCode=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type2) + "\" />" + EOL);
                }
            } else if (node instanceof EventNode && (type = (String)(eventNode = (EventNode)node).getMetaData("EscalationEvent")) != null && !escalations.contains(type)) {
                escalations.add(type);
                xmlDump.append("  <escalation id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type) + "\" escalationCode=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type) + "\" />" + EOL);
            }
            if (!(node instanceof CompositeNode)) continue;
            this.visitEscalations(((CompositeNode)node).getNodes(), xmlDump, escalations);
        }
    }

    protected void visitErrors(Node[] nodes, StringBuilder xmlDump, List<String> errors) {
        for (Node node : nodes) {
            EventNode eventNode;
            String type;
            if (node instanceof FaultNode) {
                String errorCode;
                FaultNode faultNode = (FaultNode)node;
                if (faultNode.isTerminateParent() && !errors.contains(errorCode = faultNode.getFaultName())) {
                    errors.add(errorCode);
                    xmlDump.append("  <error id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(errorCode) + "\" errorCode=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(errorCode) + "\" />" + EOL);
                }
            } else if (node instanceof EventNode && (type = (String)(eventNode = (EventNode)node).getMetaData("ErrorEvent")) != null && !errors.contains(type)) {
                errors.add(type);
                xmlDump.append("  <error id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type) + "\" errorCode=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type) + "\" />" + EOL);
            }
            if (!(node instanceof CompositeNode)) continue;
            this.visitErrors(((CompositeNode)node).getNodes(), xmlDump, errors);
        }
    }

    private void visitNodes(WorkflowProcess process, StringBuilder xmlDump, int metaDataType) {
        xmlDump.append("    <!-- nodes -->" + EOL);
        for (Node node : process.getNodes()) {
            this.visitNode(node, xmlDump, metaDataType);
        }
        xmlDump.append(EOL);
    }

    public void visitNode(Node node, StringBuilder xmlDump, int metaDataType) {
        Handler handler = this.semanticModule.getHandlerByClass(node.getClass());
        if (handler == null) {
            throw new IllegalArgumentException("Unknown node type: " + node);
        }
        ((AbstractNodeHandler)handler).writeNode((org.jbpm.workflow.core.Node)node, xmlDump, metaDataType);
    }

    private void visitNodesDi(Node[] nodes, StringBuilder xmlDump) {
        for (Node node : nodes) {
            int offsetY;
            int offsetX;
            Integer x = (Integer)node.getMetaData().get("x");
            Integer y = (Integer)node.getMetaData().get("y");
            Integer width = (Integer)node.getMetaData().get("width");
            Integer height = (Integer)node.getMetaData().get("height");
            if (x == null) {
                x = 0;
            }
            if (y == null) {
                y = 0;
            }
            if (width == null) {
                width = 48;
            }
            if (height == null) {
                height = 48;
            }
            if (node instanceof StartNode || node instanceof EndNode || node instanceof EventNode || node instanceof FaultNode) {
                offsetX = (width - 48) / 2;
                width = 48;
                x = x + offsetX;
                offsetY = (height - 48) / 2;
                y = y + offsetY;
                height = 48;
            } else if (node instanceof Join || node instanceof Split) {
                offsetX = (width - 48) / 2;
                width = 48;
                x = x + offsetX;
                offsetY = (height - 48) / 2;
                y = y + offsetY;
                height = 48;
            }
            int parentOffsetX = 0;
            int parentOffsetY = 0;
            NodeContainer nodeContainer = node.getNodeContainer();
            while (nodeContainer instanceof CompositeNode) {
                Integer parentY;
                CompositeNode parent = (CompositeNode)nodeContainer;
                Integer parentX = (Integer)parent.getMetaData().get("x");
                if (parentX != null) {
                    parentOffsetX += parentX.intValue();
                }
                if ((parentY = (Integer)parent.getMetaData().get("y")) != null) {
                    parentOffsetY += ((Integer)parent.getMetaData().get("y")).intValue();
                }
                nodeContainer = parent.getNodeContainer();
            }
            x = x + parentOffsetX;
            y = y + parentOffsetY;
            xmlDump.append("      <bpmndi:BPMNShape bpmnElement=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "\" >" + EOL + "        <dc:Bounds x=\"" + x + "\" " + "y=\"" + y + "\" " + "width=\"" + width + "\" " + "height=\"" + height + "\" />" + EOL + "      </bpmndi:BPMNShape>" + EOL);
            if (!(node instanceof CompositeNode)) continue;
            this.visitNodesDi(((CompositeNode)node).getNodes(), xmlDump);
        }
    }

    private void visitConnections(Node[] nodes, StringBuilder xmlDump, int metaDataType) {
        xmlDump.append("    <!-- connections -->" + EOL);
        ArrayList connections = new ArrayList();
        for (Node node : nodes) {
            for (List connectionList : node.getIncomingConnections().values()) {
                connections.addAll(connectionList);
            }
        }
        for (Connection connection : connections) {
            this.visitConnection(connection, xmlDump, metaDataType);
        }
        xmlDump.append(EOL);
    }

    public void visitConnection(Connection connection, StringBuilder xmlDump, int metaDataType) {
        String bendpoints;
        xmlDump.append("    <sequenceFlow id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getFrom()) + "-" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getTo()) + "\" sourceRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getFrom()) + "\" ");
        xmlDump.append("targetRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getTo()) + "\" ");
        if (metaDataType == 1 && (bendpoints = (String)connection.getMetaData().get("bendpoints")) != null) {
            xmlDump.append("g:bendpoints=\"" + bendpoints + "\" ");
        }
        if (connection.getFrom() instanceof Split) {
            Split split = (Split)connection.getFrom();
            if (split.getType() == 2 || split.getType() == 3) {
                Constraint constraint = split.getConstraint(connection);
                if (constraint == null) {
                    xmlDump.append(">" + EOL + "      <conditionExpression xsi:type=\"tFormalExpression\" />");
                } else {
                    if (constraint.getName() != null && constraint.getName().trim().length() > 0) {
                        xmlDump.append("name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(constraint.getName()) + "\" ");
                    }
                    if (constraint.getPriority() != 0) {
                        xmlDump.append("tns:priority=\"" + constraint.getPriority() + "\" ");
                    }
                    xmlDump.append(">" + EOL + "      <conditionExpression xsi:type=\"tFormalExpression\" ");
                    if ("code".equals(constraint.getType())) {
                        if ("java".equals(constraint.getDialect())) {
                            xmlDump.append("language=\"http://www.java.com/java\" ");
                        } else if ("XPath".equals(constraint.getDialect())) {
                            xmlDump.append("language=\"http://www.w3.org/1999/XPath\" ");
                        }
                    } else {
                        xmlDump.append("language=\"http://www.jboss.org/drools/rule\" ");
                    }
                    String constraintString = constraint.getConstraint();
                    if (constraintString == null) {
                        constraintString = "";
                    }
                    xmlDump.append(">" + XmlDumper.replaceIllegalChars((String)constraintString) + "</conditionExpression>");
                }
                xmlDump.append(EOL + "    </sequenceFlow>" + EOL);
            } else {
                xmlDump.append("/>" + EOL);
            }
        } else {
            xmlDump.append("/>" + EOL);
        }
    }

    private void visitConnectionsDi(Node[] nodes, StringBuilder xmlDump) {
        ArrayList connections = new ArrayList();
        for (Node node : nodes) {
            for (List connectionList : node.getIncomingConnections().values()) {
                connections.addAll(connectionList);
            }
            if (!(node instanceof CompositeNode)) continue;
            this.visitConnectionsDi(((CompositeNode)node).getNodes(), xmlDump);
        }
        for (Connection connection : connections) {
            Integer height;
            Integer width;
            Integer y;
            String bendpoints = (String)connection.getMetaData().get("bendpoints");
            xmlDump.append("      <bpmndi:BPMNEdge bpmnElement=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getFrom()) + "-" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getTo()) + "\" >" + EOL);
            Integer x = (Integer)connection.getFrom().getMetaData().get("x");
            if (x == null) {
                x = 0;
            }
            if ((y = (Integer)connection.getFrom().getMetaData().get("y")) == null) {
                y = 0;
            }
            if ((width = (Integer)connection.getFrom().getMetaData().get("width")) == null) {
                width = 40;
            }
            if ((height = (Integer)connection.getFrom().getMetaData().get("height")) == null) {
                height = 40;
            }
            xmlDump.append("        <di:waypoint x=\"" + (x + width / 2) + "\" y=\"" + (y + height / 2) + "\" />" + EOL);
            if (bendpoints != null) {
                String[] points;
                bendpoints = bendpoints.substring(1, bendpoints.length() - 1);
                for (String point : points = bendpoints.split(";")) {
                    String[] coords = point.split(",");
                    if (coords.length != 2) continue;
                    xmlDump.append("        <di:waypoint x=\"" + coords[0] + "\" y=\"" + coords[1] + "\" />" + EOL);
                }
            }
            if ((x = (Integer)connection.getTo().getMetaData().get("x")) == null) {
                x = 0;
            }
            if ((y = (Integer)connection.getTo().getMetaData().get("y")) == null) {
                y = 0;
            }
            if ((width = (Integer)connection.getTo().getMetaData().get("width")) == null) {
                width = 40;
            }
            if ((height = (Integer)connection.getTo().getMetaData().get("height")) == null) {
                height = 40;
            }
            xmlDump.append("        <di:waypoint x=\"" + (x + width / 2) + "\" y=\"" + (y + height / 2) + "\" />" + EOL);
            xmlDump.append("      </bpmndi:BPMNEdge>" + EOL);
        }
    }

    public static String getUniqueNodeId(Node node) {
        String result = (String)node.getMetaData().get("UniqueId");
        if (result != null) {
            return result;
        }
        result = node.getId() + "";
        NodeContainer nodeContainer = node.getNodeContainer();
        while (nodeContainer instanceof CompositeNode) {
            CompositeNode composite = (CompositeNode)nodeContainer;
            result = composite.getId() + "-" + result;
            nodeContainer = composite.getNodeContainer();
        }
        return "_" + result;
    }

    public static String replaceIllegalCharsAttribute(String code) {
        StringBuilder sb = new StringBuilder();
        if (code != null) {
            int n = code.length();
            block6: for (int i = 0; i < n; ++i) {
                char c = code.charAt(i);
                switch (c) {
                    case '<': {
                        sb.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block6;
                    }
                    case '&': {
                        sb.append("&amp;");
                        continue block6;
                    }
                    case '\"': {
                        sb.append("&quot;");
                        continue block6;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

