/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.audit.WorkingMemoryInMemoryLogger;
import org.drools.audit.event.LogEvent;
import org.drools.audit.event.RuleFlowNodeLogEvent;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.process.Node;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.io.ResourceFactory;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.NodeInstance;
import org.drools.runtime.process.NodeInstanceContainer;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.jbpm.process.audit.JPAProcessInstanceDbLog;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JbpmBpmn2TestCase
extends TestCase {
    protected static final String EOL = System.getProperty("line.separator");
    protected boolean persistence = true;
    private HashMap<String, Object> context;
    private TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
    public StatefulKnowledgeSession ksession;
    private WorkingMemoryInMemoryLogger logger;

    public JbpmBpmn2TestCase() {
        this(false);
    }

    public JbpmBpmn2TestCase(boolean persistence) {
        this.persistence = persistence;
    }

    public boolean isPersistence() {
        return this.persistence;
    }

    protected void setUp() {
        System.out.println("RUNNING: " + this.getName());
        if (this.persistence) {
            this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        }
    }

    protected void tearDown() {
        if (this.persistence) {
            PersistenceUtil.tearDown(this.context);
        }
    }

    protected KnowledgeBase createKnowledgeBase(String ... process) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String p : process) {
            kbuilder.add(ResourceFactory.newClassPathResource((String)p), ResourceType.BPMN2);
        }
        return kbuilder.newKnowledgeBase();
    }

    protected KnowledgeBase createKnowledgeBase(Map<String, ResourceType> resources) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (Map.Entry<String, ResourceType> entry : resources.entrySet()) {
            kbuilder.add(ResourceFactory.newClassPathResource((String)entry.getKey()), entry.getValue());
        }
        return kbuilder.newKnowledgeBase();
    }

    protected KnowledgeBase createKnowledgeBaseGuvnor(String ... packages) throws Exception {
        return this.createKnowledgeBaseGuvnor(false, "http://localhost:8080/drools-guvnor", "admin", "admin", packages);
    }

    protected KnowledgeBase createKnowledgeBaseGuvnorAssets(String pkg, String ... assets) throws Exception {
        return this.createKnowledgeBaseGuvnor(false, "http://localhost:8080/drools-guvnor", "admin", "admin", pkg, assets);
    }

    protected KnowledgeBase createKnowledgeBaseGuvnor(boolean dynamic, String url, String username, String password, String pkg, String ... assets) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String changeSet = "<change-set xmlns='http://drools.org/drools-5.0/change-set'" + EOL + "            xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'" + EOL + "            xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >" + EOL + "    <add>" + EOL;
        for (String a : assets) {
            if (a.indexOf(".bpmn") >= 0) {
                a = a.substring(0, a.indexOf(".bpmn"));
            }
            changeSet = changeSet + "        <resource source='" + url + "/rest/packages/" + pkg + "/assets/" + a + "/binary' type='BPMN2' basicAuthentication=\"enabled\" username=\"" + username + "\" password=\"" + password + "\" />" + EOL;
        }
        changeSet = changeSet + "    </add>" + EOL + "</change-set>";
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])changeSet.getBytes()), ResourceType.CHANGE_SET);
        return kbuilder.newKnowledgeBase();
    }

    protected KnowledgeBase createKnowledgeBaseGuvnor(boolean dynamic, String url, String username, String password, String ... packages) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String changeSet = "<change-set xmlns='http://drools.org/drools-5.0/change-set'" + EOL + "            xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'" + EOL + "            xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >" + EOL + "    <add>" + EOL;
        for (String p : packages) {
            changeSet = changeSet + "        <resource source='" + url + "/rest/packages/" + p + "/binary' type='PKG' basicAuthentication=\"enabled\" username=\"" + username + "\" password=\"" + password + "\" />" + EOL;
        }
        changeSet = changeSet + "    </add>" + EOL + "</change-set>";
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])changeSet.getBytes()), ResourceType.CHANGE_SET);
        return kbuilder.newKnowledgeBase();
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase) {
        if (this.persistence) {
            Environment env = PersistenceUtil.createEnvironment(this.context);
            StatefulKnowledgeSession result = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
            new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)result);
            JPAProcessInstanceDbLog.setEnvironment((Environment)result.getEnvironment());
            return result;
        }
        StatefulKnowledgeSession result = kbase.newStatefulKnowledgeSession();
        this.logger = new WorkingMemoryInMemoryLogger((KnowledgeRuntimeEventManager)result);
        return result;
    }

    protected StatefulKnowledgeSession createKnowledgeSession(String ... process) {
        KnowledgeBase kbase = this.createKnowledgeBase(process);
        return this.createKnowledgeSession(kbase);
    }

    protected StatefulKnowledgeSession restoreSession(StatefulKnowledgeSession ksession, boolean noCache) {
        if (this.persistence) {
            int id = ksession.getId();
            KnowledgeBase kbase = ksession.getKnowledgeBase();
            Environment env = null;
            env = noCache ? PersistenceUtil.createEnvironment(this.context) : ksession.getEnvironment();
            KnowledgeSessionConfiguration config = ksession.getSessionConfiguration();
            StatefulKnowledgeSession result = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, (KnowledgeSessionConfiguration)config, (Environment)env);
            new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)result);
            return result;
        }
        return ksession;
    }

    public Object getVariableValue(String name, long processInstanceId, StatefulKnowledgeSession ksession) {
        return ((WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId)).getVariable(name);
    }

    public void assertProcessInstanceCompleted(long processInstanceId, StatefulKnowledgeSession ksession) {
        JbpmBpmn2TestCase.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    public void assertProcessInstanceAborted(long processInstanceId, StatefulKnowledgeSession ksession) {
        JbpmBpmn2TestCase.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    public void assertProcessInstanceActive(long processInstanceId, StatefulKnowledgeSession ksession) {
        JbpmBpmn2TestCase.assertNotNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    public void assertNodeActive(long processInstanceId, StatefulKnowledgeSession ksession, String ... name) {
        ArrayList<String> names = new ArrayList<String>();
        for (String n : name) {
            names.add(n);
        }
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        if (processInstance instanceof WorkflowProcessInstance) {
            this.assertNodeActive((NodeInstanceContainer)((WorkflowProcessInstance)processInstance), names);
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmBpmn2TestCase.fail((String)("Node(s) not active: " + s));
        }
    }

    private void assertNodeActive(NodeInstanceContainer container, List<String> names) {
        for (NodeInstance nodeInstance : container.getNodeInstances()) {
            String nodeName = nodeInstance.getNodeName();
            if (names.contains(nodeName)) {
                names.remove(nodeName);
            }
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            this.assertNodeActive((NodeInstanceContainer)nodeInstance, names);
        }
    }

    public void assertNodeTriggered(long processInstanceId, String ... nodeNames) {
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : nodeNames) {
            names.add(nodeName);
        }
        if (this.persistence) {
            List logs = JPAProcessInstanceDbLog.findNodeInstances((long)processInstanceId);
            if (logs != null) {
                for (NodeInstanceLog l : logs) {
                    String nodeName;
                    nodeName = l.getNodeName();
                    if (l.getType() != 0 || !names.contains(nodeName)) continue;
                    names.remove(nodeName);
                }
            }
        } else {
            for (LogEvent event : this.logger.getLogEvents()) {
                String nodeName;
                if (!(event instanceof RuleFlowNodeLogEvent) || !names.contains(nodeName = ((RuleFlowNodeLogEvent)event).getNodeName())) continue;
                names.remove(nodeName);
            }
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmBpmn2TestCase.fail((String)("Node(s) not executed: " + s));
        }
    }

    protected void clearHistory() {
        if (this.persistence) {
            JPAProcessInstanceDbLog.clear();
        } else {
            this.logger.clear();
        }
    }

    public TestWorkItemHandler getTestWorkItemHandler() {
        return this.workItemHandler;
    }

    public void assertProcessVarExists(ProcessInstance process, String ... processVarNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : processVarNames) {
            names.add(nodeName);
        }
        for (String pvar : instance.getVariables().keySet()) {
            if (!names.contains(pvar)) continue;
            names.remove(pvar);
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmBpmn2TestCase.fail((String)("Process Variable(s) do not exist: " + s));
        }
    }

    public void assertNodeExists(ProcessInstance process, String ... nodeNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String string : nodeNames) {
            names.add(string);
        }
        for (String string : instance.getNodeContainer().getNodes()) {
            if (!names.contains(string.getName())) continue;
            names.remove(string.getName());
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmBpmn2TestCase.fail((String)("Node(s) do not exist: " + s));
        }
    }

    public void assertNumOfIncommingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getIncomingConnections().size() == num) break;
            JbpmBpmn2TestCase.fail((String)("Expected incomming connections: " + num + " - found " + node.getIncomingConnections().size()));
        }
    }

    public void assertNumOfOutgoingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getOutgoingConnections().size() == num) break;
            JbpmBpmn2TestCase.fail((String)("Expected outgoing connections: " + num + " - found " + node.getOutgoingConnections().size()));
        }
    }

    public void assertVersionEquals(ProcessInstance process, String version) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getVersion().equals(version)) {
            JbpmBpmn2TestCase.fail((String)("Expected version: " + version + " - found " + instance.getWorkflowProcess().getVersion()));
        }
    }

    public void assertProcessNameEquals(ProcessInstance process, String name) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getName().equals(name)) {
            JbpmBpmn2TestCase.fail((String)("Expected name: " + name + " - found " + instance.getWorkflowProcess().getName()));
        }
    }

    public void assertPackageNameEquals(ProcessInstance process, String packageName) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getPackageName().equals(packageName)) {
            JbpmBpmn2TestCase.fail((String)("Expected package name: " + packageName + " - found " + instance.getWorkflowProcess().getPackageName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestWorkItemHandler
    implements WorkItemHandler {
        private List<WorkItem> workItems = new ArrayList<WorkItem>();

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItems.add(workItem);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            if (this.workItems.size() == 0) {
                return null;
            }
            if (this.workItems.size() == 1) {
                WorkItem result = this.workItems.get(0);
                this.workItems.clear();
                return result;
            }
            throw new IllegalArgumentException("More than one work item active");
        }

        public List<WorkItem> getWorkItems() {
            ArrayList<WorkItem> result = new ArrayList<WorkItem>(this.workItems);
            this.workItems.clear();
            return result;
        }
    }
}

