/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.event.process.DefaultProcessEventListener;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.process.ProcessStartedEvent;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItemHandler;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;

public class SignalEventsTest
extends JbpmBpmn2TestCase {
    public SignalEventsTest() {
        super(true);
    }

    public void testSignalBetweenProcesses() {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchSignalSingle.bpmn2", "BPMN2-IntermediateThrowEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler handler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = ksession.startProcess("BPMN2-IntermediateCatchSignalSingle");
        ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        ProcessInstance processInstance2 = ksession.startProcess("SignalIntermediateEvent");
        this.assertProcessInstanceCompleted(processInstance2.getId(), ksession);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testSignalToStartProcess() {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-SignalStart.bpmn2", "BPMN2-IntermediateThrowEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler handler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        final ArrayList startedProcesses = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                startedProcesses.add(event.getProcessInstance().getProcessId());
            }
        });
        ProcessInstance processInstance2 = ksession.startProcess("SignalIntermediateEvent");
        this.assertProcessInstanceCompleted(processInstance2.getId(), ksession);
        SignalEventsTest.assertEquals((int)2, (int)startedProcesses.size());
    }
}

